/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import java.util.Arrays;
import java.util.HashMap;
import mekanism.client.render.FluidRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderThermalEvaporationController
extends TileEntitySpecialRenderer<TileEntityThermalEvaporationController> {
    private static HashMap<Fluid, MekanismRenderer.DisplayInteger[]> cachedCenterFluids = new HashMap();
    private static final int LEVELS = 16;
    private static final int ALL_LEVELS = 18;
    private static final int RING_INDEX = 16;
    private static final int CONCAVE_INDEX = 17;

    public void render(TileEntityThermalEvaporationController tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.structured && tileEntity.inputTank.getFluid() != null) {
            this.func_147499_a(MekanismRenderer.getBlocksTexture());
            if (tileEntity.height - 2 >= 1 && tileEntity.inputTank.getCapacity() > 0) {
                this.push();
                FluidRenderer.translateToOrigin(tileEntity.getRenderLocation());
                MekanismRenderer.glowOn(tileEntity.inputTank.getFluid().getFluid().getLuminosity());
                MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(tileEntity.inputTank.getFluid().getFluid());
                float levels = Math.min((float)tileEntity.inputTank.getFluidAmount() / (float)tileEntity.inputTank.getCapacity(), 1.0f);
                int partialLevels = (int)(((levels *= (float)(tileEntity.height - 2)) - (float)((int)levels)) * 16.0f);
                switch (tileEntity.facing) {
                    case SOUTH: {
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                        break;
                    }
                }
                GlStateManager.func_179137_b((double)0.0, (double)0.01, (double)0.0);
                if ((int)levels > 0) {
                    displayList[17].render();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                    for (int i = 1; i < (int)levels; ++i) {
                        displayList[16].render();
                        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                displayList[partialLevels].render();
                MekanismRenderer.glowOff();
                this.pop();
            }
        }
    }

    private void pop() {
        GL11.glPopAttrib();
        GlStateManager.func_179121_F();
    }

    private void push() {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(Fluid fluid) {
        if (cachedCenterFluids.containsKey(fluid)) {
            return cachedCenterFluids.get(fluid);
        }
        Object[] displays = new MekanismRenderer.DisplayInteger[18];
        MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
        model.baseBlock = fluid.getBlock();
        model.setTexture(MekanismRenderer.getFluidTexture(fluid, MekanismRenderer.FluidType.STILL));
        MekanismRenderer.colorFluid(fluid);
        if (fluid.getStill() == null) {
            MekanismRenderer.DisplayInteger empty = MekanismRenderer.DisplayInteger.createAndStart();
            MekanismRenderer.DisplayInteger.endList();
            Arrays.fill(displays, 0, 16, empty);
        } else {
            model.setSideRender(EnumFacing.DOWN, false);
            for (int i = 0; i < 16; ++i) {
                displays[i] = this.generateLevel(i, model);
            }
            model.setSideRender(EnumFacing.UP, false);
            displays[16] = this.generateLevel(15, model);
            model.setSideRender(EnumFacing.DOWN, true);
            displays[17] = this.generateLevel(15, model);
        }
        MekanismRenderer.resetColor();
        cachedCenterFluids.put(fluid, (MekanismRenderer.DisplayInteger[])displays);
        return displays;
    }

    private MekanismRenderer.DisplayInteger generateLevel(int height, MekanismRenderer.Model3D model) {
        MekanismRenderer.DisplayInteger displayInteger = MekanismRenderer.DisplayInteger.createAndStart();
        model.minX = 0.01;
        model.minY = 0.0;
        model.minZ = 0.01;
        model.maxX = 1.99;
        model.maxY = (double)((float)height / 15.0f) + (height == 0 ? 0.02 : 0.0);
        model.maxZ = 1.99;
        MekanismRenderer.renderObject(model);
        MekanismRenderer.DisplayInteger.endList();
        return displayInteger;
    }

    public static void resetDisplayInts() {
        cachedCenterFluids.clear();
    }
}

