/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.InfuseStorage;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public interface IFactory {
    public int getRecipeType(ItemStack var1);

    public void setRecipeType(int var1, ItemStack var2);

    public static enum RecipeType implements IStringSerializable
    {
        SMELTING("Smelting", "smelter", BlockStateMachine.MachineType.ENERGIZED_SMELTER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ENERGIZED_SMELTER),
        ENRICHING("Enriching", "enrichment", BlockStateMachine.MachineType.ENRICHMENT_CHAMBER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.ENRICHMENT_CHAMBER),
        CRUSHING("Crushing", "crusher", BlockStateMachine.MachineType.CRUSHER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.CRUSHER),
        COMPRESSING("Compressing", "compressor", BlockStateMachine.MachineType.OSMIUM_COMPRESSOR, MachineFuelType.ADVANCED, false, RecipeHandler.Recipe.OSMIUM_COMPRESSOR),
        COMBINING("Combining", "combiner", BlockStateMachine.MachineType.COMBINER, MachineFuelType.DOUBLE, false, RecipeHandler.Recipe.COMBINER),
        PURIFYING("Purifying", "purifier", BlockStateMachine.MachineType.PURIFICATION_CHAMBER, MachineFuelType.ADVANCED, true, RecipeHandler.Recipe.PURIFICATION_CHAMBER),
        INJECTING("Injecting", "injection", BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER, MachineFuelType.ADVANCED, true, RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER),
        INFUSING("Infusing", "metalinfuser", BlockStateMachine.MachineType.METALLURGIC_INFUSER, MachineFuelType.BASIC, false, RecipeHandler.Recipe.METALLURGIC_INFUSER);

        private String name;
        private ResourceLocation sound;
        private BlockStateMachine.MachineType type;
        private MachineFuelType fuelType;
        private boolean fuelSpeed;
        private RecipeHandler.Recipe recipe;
        private TileEntityAdvancedElectricMachine cacheTile;

        public BasicMachineRecipe getRecipe(ItemStackInput input) {
            return RecipeHandler.getRecipe(input, this.recipe.get());
        }

        public BasicMachineRecipe getRecipe(ItemStack input) {
            return this.getRecipe(new ItemStackInput(input));
        }

        public AdvancedMachineRecipe getRecipe(AdvancedMachineInput input) {
            return RecipeHandler.getRecipe(input, this.recipe.get());
        }

        public AdvancedMachineRecipe getRecipe(ItemStack input, Gas gas) {
            return this.getRecipe(new AdvancedMachineInput(input, gas));
        }

        public DoubleMachineRecipe getRecipe(DoubleMachineInput input) {
            return RecipeHandler.getRecipe(input, this.recipe.get());
        }

        public DoubleMachineRecipe getRecipe(ItemStack input, ItemStack extra) {
            return this.getRecipe(new DoubleMachineInput(input, extra));
        }

        public MetallurgicInfuserRecipe getRecipe(InfusionInput input) {
            return RecipeHandler.getMetallurgicInfuserRecipe(input);
        }

        public MetallurgicInfuserRecipe getRecipe(ItemStack input, InfuseStorage storage) {
            return this.getRecipe(new InfusionInput(storage, input));
        }

        public MachineRecipe getAnyRecipe(ItemStack slotStack, ItemStack extraStack, Gas gasType, InfuseStorage infuse) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getRecipe(slotStack, gasType);
            }
            if (this.fuelType == MachineFuelType.DOUBLE) {
                return this.getRecipe(slotStack, extraStack);
            }
            if (this == INFUSING) {
                if (infuse.type != null) {
                    return RecipeHandler.getMetallurgicInfuserRecipe(new InfusionInput(infuse, slotStack));
                }
                Iterator iterator = RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry obj;
                    Map.Entry entry = obj = iterator.next();
                    InfusionInput input = (InfusionInput)entry.getKey();
                    if (!input.inputStack.func_77969_a(slotStack)) continue;
                    return (MetallurgicInfuserRecipe)entry.getValue();
                }
            }
            return this.getRecipe(slotStack);
        }

        public GasStack getItemGas(ItemStack itemstack) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().getItemGas(itemstack);
            }
            return null;
        }

        public int getSecondaryEnergyPerTick() {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().BASE_SECONDARY_ENERGY_PER_TICK;
            }
            return 0;
        }

        public boolean canReceiveGas(EnumFacing side, Gas type) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().canReceiveGas(side, type);
            }
            return false;
        }

        public boolean canTubeConnect(EnumFacing side) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().canTubeConnect(side);
            }
            return false;
        }

        public boolean isValidGas(Gas gas) {
            if (this.fuelType == MachineFuelType.ADVANCED) {
                return this.getTile().isValidGas(gas);
            }
            return false;
        }

        public boolean hasRecipe(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return false;
            }
            for (Map.Entry obj : this.recipe.get().entrySet()) {
                if (!(obj.getKey() instanceof AdvancedMachineInput)) continue;
                Map.Entry entry = obj;
                ItemStack stack = ((AdvancedMachineInput)entry.getKey()).itemStack;
                if (!StackUtils.equalsWildcard(stack, itemStack)) continue;
                return true;
            }
            return false;
        }

        public boolean hasRecipeForExtra(ItemStack extraStack) {
            if (extraStack.func_190926_b()) {
                return false;
            }
            for (Map.Entry obj : this.recipe.get().entrySet()) {
                if (!(obj.getKey() instanceof DoubleMachineInput)) continue;
                Map.Entry entry = obj;
                ItemStack stack = ((DoubleMachineInput)entry.getKey()).extraStack;
                if (!StackUtils.equalsWildcard(stack, extraStack)) continue;
                return true;
            }
            return false;
        }

        public TileEntityAdvancedElectricMachine getTile() {
            if (this.cacheTile == null) {
                BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getStack());
                this.cacheTile = (TileEntityAdvancedElectricMachine)type.create();
            }
            return this.cacheTile;
        }

        public double getEnergyUsage() {
            return this.type.getUsage();
        }

        public int getMaxSecondaryEnergy() {
            return 200;
        }

        public ItemStack getStack() {
            return this.type.getStack();
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("gui.factory." + this.name);
        }

        public ResourceLocation getSound() {
            return this.sound;
        }

        public MachineFuelType getFuelType() {
            return this.fuelType;
        }

        public boolean fuelEnergyUpgrades() {
            return this.fuelSpeed;
        }

        public static RecipeType getFromMachine(Block block, int meta) {
            RecipeType type = null;
            for (RecipeType iterType : RecipeType.values()) {
                ItemStack machineStack = iterType.getStack();
                if (Block.func_149634_a((Item)machineStack.func_77973_b()) != block || machineStack.func_77952_i() != meta) continue;
                type = iterType;
                break;
            }
            return type;
        }

        private RecipeType(String s, String s1, BlockStateMachine.MachineType t, MachineFuelType ft, boolean b1, RecipeHandler.Recipe r) {
            this.name = s;
            this.sound = new ResourceLocation("mekanism", "tile.machine." + s1);
            this.type = t;
            this.fuelType = ft;
            this.fuelSpeed = b1;
            this.recipe = r;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public BlockStateMachine.MachineType getType() {
            return this.type;
        }
    }

    public static enum MachineFuelType {
        BASIC,
        ADVANCED,
        DOUBLE;

    }
}

