/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.assemblicator;

import java.util.ArrayList;
import java.util.List;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.RecipeUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class RecipeFormula {
    private InventoryCrafting dummy = MekanismUtils.getDummyCraftingInv();
    public NonNullList<ItemStack> input = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public IRecipe recipe = null;

    public RecipeFormula(World world, NonNullList<ItemStack> inv) {
        this(world, inv, 0);
    }

    public RecipeFormula(World world, NonNullList<ItemStack> inv, int start) {
        for (int i = 0; i < 9; ++i) {
            this.input.set(i, (Object)StackUtils.size((ItemStack)inv.get(start + i), 1));
        }
        this.resetToRecipe();
        this.recipe = RecipeUtils.getRecipeFromGrid(this.dummy, world);
    }

    private void resetToRecipe() {
        for (int i = 0; i < 9; ++i) {
            this.dummy.func_70299_a(i, (ItemStack)this.input.get(i));
        }
    }

    public boolean matches(World world, NonNullList<ItemStack> newInput, int start) {
        for (int i = 0; i < 9; ++i) {
            this.dummy.func_70299_a(i, (ItemStack)newInput.get(start + i));
        }
        return this.recipe.func_77569_a(this.dummy, world);
    }

    public boolean isIngredientInPos(World world, ItemStack stack, int i) {
        this.resetToRecipe();
        this.dummy.func_70299_a(i, stack);
        return this.recipe.func_77569_a(this.dummy, world);
    }

    public boolean isIngredient(World world, ItemStack stack) {
        for (int i = 0; i < 9; ++i) {
            this.dummy.func_70299_a(i, stack);
            if (this.recipe.func_77569_a(this.dummy, world)) {
                return true;
            }
            this.dummy.func_70299_a(i, (ItemStack)this.input.get(i));
        }
        return false;
    }

    public List<Integer> getIngredientIndices(World world, ItemStack stack) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < 9; ++i) {
            this.dummy.func_70299_a(i, stack);
            if (this.recipe.func_77569_a(this.dummy, world)) {
                ret.add(i);
            }
            this.dummy.func_70299_a(i, (ItemStack)this.input.get(i));
        }
        return ret;
    }

    public boolean isValidFormula(World world) {
        return this.getRecipe(world) != null;
    }

    public IRecipe getRecipe(World world) {
        return this.recipe;
    }

    public boolean isFormulaEqual(World world, RecipeFormula formula) {
        return formula.getRecipe(world) == this.getRecipe(world);
    }
}

