/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.transmitters.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.energy.EnergyStack;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.base.EnergyAcceptorWrapper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public class EnergyNetwork
extends DynamicNetwork<EnergyAcceptorWrapper, EnergyNetwork> {
    private double lastPowerScale = 0.0;
    private double joulesTransmitted = 0.0;
    private double jouleBufferLastTick = 0.0;
    public double clientEnergyScale = 0.0;
    public EnergyStack buffer = new EnergyStack(0.0);

    public EnergyNetwork() {
    }

    public EnergyNetwork(Collection<EnergyNetwork> networks) {
        for (EnergyNetwork net : networks) {
            if (net == null) continue;
            if (net.jouleBufferLastTick > this.jouleBufferLastTick || net.clientEnergyScale > this.clientEnergyScale) {
                this.clientEnergyScale = net.clientEnergyScale;
                this.jouleBufferLastTick = net.jouleBufferLastTick;
                this.joulesTransmitted = net.joulesTransmitted;
                this.lastPowerScale = net.lastPowerScale;
            }
            this.buffer.amount += net.buffer.amount;
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.register();
    }

    public static double round(double d) {
        return Math.round(d * 10000.0) / 10000L;
    }

    @Override
    public void absorbBuffer(IGridTransmitter<EnergyAcceptorWrapper, EnergyNetwork> transmitter) {
        EnergyStack energy = (EnergyStack)transmitter.getBuffer();
        this.buffer.amount += energy.amount;
        energy.amount = 0.0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer.amount > (double)this.getCapacity()) {
            this.buffer.amount = this.getCapacity();
        }
        if (this.buffer.amount < 0.0) {
            this.buffer.amount = 0.0;
        }
    }

    @Override
    protected void updateMeanCapacity() {
        int numCables = this.transmitters.size();
        double reciprocalSum = 0.0;
        for (IGridTransmitter cable : this.transmitters) {
            reciprocalSum += 1.0 / (double)cable.getCapacity();
        }
        this.meanCapacity = (double)numCables / reciprocalSum;
    }

    public double getEnergyNeeded() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        return (double)this.getCapacity() - this.buffer.amount;
    }

    public double tickEmit(double energyToSend) {
        boolean tryAgain;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return 0.0;
        }
        double sent = 0.0;
        int i = 0;
        do {
            double prev = sent;
            tryAgain = energyToSend - (sent += this.doEmit(energyToSend - sent)) > 0.0 && sent - prev > 0.0 && i < 100;
            ++i;
        } while (tryAgain);
        this.joulesTransmitted = sent;
        return sent;
    }

    public double emit(double energyToSend, boolean doEmit) {
        double toUse = Math.min(this.getEnergyNeeded(), energyToSend);
        if (doEmit) {
            this.buffer.amount += toUse;
        }
        return energyToSend - toUse;
    }

    public double doEmit(double energyToSend) {
        double sent = 0.0;
        ArrayList<Pair<Coord4D, EnergyAcceptorWrapper>> availableAcceptors = new ArrayList<Pair<Coord4D, EnergyAcceptorWrapper>>();
        availableAcceptors.addAll(this.getAcceptors(null));
        Collections.shuffle(availableAcceptors);
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            double remaining = energyToSend % (double)divider;
            double sending = (energyToSend - remaining) / (double)divider;
            block0: for (Pair pair : availableAcceptors) {
                EnergyAcceptorWrapper acceptor = (EnergyAcceptorWrapper)pair.getRight();
                double currentSending = sending + remaining;
                EnumSet sides = (EnumSet)this.acceptorDirections.get(pair.getLeft());
                if (sides == null || sides.isEmpty()) continue;
                for (EnumFacing side : sides) {
                    double prev = sent;
                    if (!((sent += acceptor.acceptEnergy(side, currentSending, false)) > prev)) continue;
                    continue block0;
                }
            }
        }
        return sent;
    }

    @Override
    public Set<Pair<Coord4D, EnergyAcceptorWrapper>> getAcceptors(Object data) {
        HashSet<Pair<Coord4D, EnergyAcceptorWrapper>> toReturn = new HashSet<Pair<Coord4D, EnergyAcceptorWrapper>>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        block0: for (Coord4D coord : this.possibleAcceptors.keySet()) {
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            if (sides == null || sides.isEmpty()) continue;
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.getWorld());
            for (EnumFacing side : sides) {
                EnergyAcceptorWrapper acceptor = EnergyAcceptorWrapper.get(tile, side);
                if (acceptor == null || !acceptor.canReceiveEnergy(side) || !acceptor.needsEnergy(side)) continue;
                toReturn.add((Pair<Coord4D, EnergyAcceptorWrapper>)Pair.of((Object)coord, (Object)acceptor));
                continue block0;
            }
        }
        return toReturn;
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.clearJoulesTransmitted();
        double currentPowerScale = this.getPowerScale();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (Math.abs(currentPowerScale - this.lastPowerScale) > 0.01 || currentPowerScale != this.lastPowerScale && (currentPowerScale == 0.0 || currentPowerScale == 1.0)) {
                this.needsUpdate = true;
            }
            if (this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this, currentPowerScale));
                this.lastPowerScale = currentPowerScale;
                this.needsUpdate = false;
            }
            if (this.buffer.amount > 0.0) {
                this.buffer.amount -= this.tickEmit(this.buffer.amount);
            }
        }
    }

    public double getPowerScale() {
        return Math.max(this.jouleBufferLastTick == 0.0 ? 0.0 : Math.min(Math.ceil(Math.log10(this.getPower()) * 2.0) / 10.0, 1.0), this.getCapacity() == 0 ? 0.0 : this.buffer.amount / (double)this.getCapacity());
    }

    public void clearJoulesTransmitted() {
        this.jouleBufferLastTick = this.buffer.amount;
        this.joulesTransmitted = 0.0;
    }

    public double getPower() {
        return this.jouleBufferLastTick * 20.0;
    }

    @Override
    public String getNeededInfo() {
        return MekanismUtils.getEnergyDisplay(this.getEnergyNeeded());
    }

    @Override
    public String getStoredInfo() {
        return MekanismUtils.getEnergyDisplay(this.buffer.amount);
    }

    @Override
    public String getFlowInfo() {
        return MekanismUtils.getEnergyDisplay(this.joulesTransmitted) + "/t";
    }

    public static class EnergyTransferEvent
    extends Event {
        public final EnergyNetwork energyNetwork;
        public final double power;

        public EnergyTransferEvent(EnergyNetwork network, double currentPower) {
            this.energyNetwork = network;
            this.power = currentPower;
        }
    }
}

