/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.BlockWrapper;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiTapper;
import cofh.thermalexpansion.gui.container.device.ContainerTapper;
import cofh.thermalexpansion.init.TEBlocks;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.device.TapperManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileTapper
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.TAPPER.getMetadata();
    private static final int NUM_LEAVES = 3;
    private static final int TIME_CONSTANT = 500;
    private static boolean requireFertilizer = false;
    private static int boostCycles = 8;
    private int timeConstant = 500;
    private FluidStack genFluid = new FluidStack(TFFluids.fluidResin, 50);
    private boolean cached;
    private int inputTracker;
    private int outputTrackerFluid;
    private boolean validTree;
    private int boostMult;
    private int boostTime;
    private FluidTankCore tank = new FluidTankCore(8000);
    private BlockPos trunkPos;
    private BlockPos[] leafPos = new BlockPos[3];
    private int offset;

    public static void initialize() {
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE] = new SideConfig();
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].numConfig = 5;
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].slotGroups = new int[][]{new int[0], {0}, new int[0], {0}, {0}};
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileTapper.SIDE_CONFIGS[TileTapper.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE] = new SlotConfig();
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE].allowInsertionSlot = new boolean[]{true};
        TileTapper.SLOT_CONFIGS[TileTapper.TYPE].allowExtractionSlot = new boolean[]{false};
        GameRegistry.registerTileEntity(TileTapper.class, (String)"thermalexpansion:device_tapper");
        TileTapper.config();
    }

    public static void config() {
        String category = "Device.Tapper";
        BlockDevice.enable[TileTapper.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "If TRUE, the Arboreal Extractor will REQUIRE Phyto-Gro to operate.";
        requireFertilizer = ThermalExpansion.CONFIG.get(category, "RequireFertilizer", requireFertilizer, comment);
        comment = "Adjust this value to set the number of cycles Phyto-Gro lasts.";
        boostCycles = ThermalExpansion.CONFIG.getConfiguration().getInt("FertilizerDuration", category, boostCycles, 2, 64, comment);
    }

    public TileTapper() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.offset = MathHelper.RANDOM.nextInt(500);
        this.hasAutoInput = true;
        this.hasAutoOutput = true;
        this.enableAutoInput = true;
        this.enableAutoOutput = true;
        this.trunkPos = new BlockPos((Vec3i)this.field_174879_c);
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos((Vec3i)this.field_174879_c);
        }
    }

    public int getType() {
        return TYPE;
    }

    public void blockPlaced() {
        super.blockPlaced();
        if (this.validTree && this.redstoneControlOrDisable()) {
            this.isActive = true;
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateValidity();
    }

    public void func_73660_a() {
        if (!this.timeCheckOffset()) {
            return;
        }
        this.transferInput();
        boolean curActive = this.isActive;
        Fluid curFluid = this.genFluid.getFluid();
        if (this.isActive) {
            if (this.validTree) {
                this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                if (this.boostTime > 0) {
                    this.tank.fill(new FluidStack(this.genFluid, this.genFluid.amount * this.boostMult), true);
                    --this.boostTime;
                } else {
                    this.boostMult = TapperManager.getFertilizerMultiplier(this.inventory[0]);
                    if (this.boostMult > 0) {
                        this.tank.fill(new FluidStack(this.genFluid, this.genFluid.amount * this.boostMult), true);
                        this.boostTime = boostCycles - 1;
                        this.inventory[0].func_190918_g(1);
                        if (this.inventory[0].func_190916_E() <= 0) {
                            this.inventory[0] = ItemStack.field_190927_a;
                        }
                    } else if (!requireFertilizer) {
                        this.tank.fill(this.genFluid, true);
                    }
                }
                this.updateValidity();
            }
            if (!this.redstoneControlOrDisable() || !this.validTree) {
                this.isActive = false;
            }
        } else if (this.validTree && this.redstoneControlOrDisable()) {
            this.isActive = true;
        }
        if (!this.cached) {
            this.updateValidity();
        }
        if (curFluid != this.genFluid.getFluid()) {
            this.sendTilePacket(Side.CLIENT);
        }
        this.transferOutput();
        this.updateIfChanged(curActive);
    }

    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    protected void transferOutput() {
        if (!this.getTransferOut() || this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), 1000));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    protected void updateValidity() {
        if (ServerHelper.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        this.timeConstant = this.getTimeConstant();
        if (this.validTree) {
            if (this.isTrunkBase(this.trunkPos)) {
                Set<BlockWrapper> leafSet = TapperManager.getLeaf(this.field_145850_b.func_180495_p(this.trunkPos));
                int leafCount = 0;
                for (int i = 0; i < 3; ++i) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.leafPos[i]);
                    BlockWrapper target = new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    if (!leafSet.contains(target)) continue;
                    ++leafCount;
                }
                if (leafCount >= 3) {
                    IBlockState state;
                    Iterable scanArea = BlockPos.func_177975_b((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
                    for (BlockPos scan : scanArea) {
                        state = this.field_145850_b.func_180495_p(scan);
                        Material material = state.func_185904_a();
                        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                        this.validTree = false;
                        this.cached = true;
                        return;
                    }
                    scanArea = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
                    for (BlockPos scan : scanArea) {
                        state = this.field_145850_b.func_180495_p(scan);
                        if (state.func_177230_c() != TEBlocks.blockDevice || TEBlocks.blockDevice.func_176201_c(state) != TYPE) continue;
                        this.validTree = false;
                        this.cached = true;
                        return;
                    }
                    this.cached = true;
                    this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
                    return;
                }
            }
            this.validTree = false;
        }
        if (this.isTrunkBase(this.field_174879_c.func_177976_e())) {
            this.trunkPos = this.field_174879_c.func_177976_e();
        } else if (this.isTrunkBase(this.field_174879_c.func_177974_f())) {
            this.trunkPos = this.field_174879_c.func_177974_f();
        } else if (this.isTrunkBase(this.field_174879_c.func_177978_c())) {
            this.trunkPos = this.field_174879_c.func_177978_c();
        } else if (this.isTrunkBase(this.field_174879_c.func_177968_d())) {
            this.trunkPos = this.field_174879_c.func_177968_d();
        }
        if (!this.isTrunkBase(this.trunkPos)) {
            this.validTree = false;
            this.cached = true;
            return;
        }
        Iterable area = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(-1, 0, -1), (BlockPos)this.field_174879_c.func_177982_a(1, Math.min(256 - this.field_174879_c.func_177956_o(), 40), 1));
        Set<BlockWrapper> leafSet = TapperManager.getLeaf(this.field_145850_b.func_180495_p(this.trunkPos));
        int leafCount = 0;
        for (BlockPos scan : area) {
            IBlockState state = this.field_145850_b.func_180495_p(scan);
            BlockWrapper target = new BlockWrapper(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
            if (!leafSet.contains(target)) continue;
            this.leafPos[leafCount] = new BlockPos((Vec3i)scan);
            if (++leafCount < 3) continue;
            break;
        }
        if (leafCount >= 3) {
            IBlockState state;
            Iterable scanArea = BlockPos.func_177975_b((BlockPos)this.trunkPos, (BlockPos)this.trunkPos.func_177982_a(0, this.leafPos[0].func_177956_o() - this.trunkPos.func_177956_o(), 0));
            for (BlockPos scan : scanArea) {
                state = this.field_145850_b.func_180495_p(scan);
                Material material = state.func_185904_a();
                if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) continue;
                this.validTree = false;
                this.cached = true;
                return;
            }
            scanArea = BlockPos.func_177975_b((BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), (BlockPos)this.field_174879_c.func_177982_a(0, this.leafPos[0].func_177956_o() - this.field_174879_c.func_177956_o(), 0));
            for (BlockPos scan : scanArea) {
                state = this.field_145850_b.func_180495_p(scan);
                if (state.func_177230_c() != TEBlocks.blockDevice || TEBlocks.blockDevice.func_176201_c(state) != TYPE) continue;
                this.validTree = false;
                this.cached = true;
                return;
            }
            this.validTree = true;
            this.genFluid = TapperManager.getFluid(this.field_145850_b.func_180495_p(this.trunkPos));
        }
        this.cached = true;
    }

    protected boolean timeCheckOffset() {
        return (this.field_145850_b.func_82737_E() + (long)this.offset) % (long)this.timeConstant == 0L;
    }

    protected int getTimeConstant() {
        int constant = 250;
        Iterable area = BlockPos.func_177975_b((BlockPos)this.trunkPos.func_177982_a(-1, 0, -1), (BlockPos)this.trunkPos.func_177982_a(1, 0, 1));
        for (BlockPos scan : area) {
            if (!TileTapper.isTapper(this.field_145850_b.func_180495_p(scan))) continue;
            constant += 250;
        }
        return MathHelper.clamp((int)constant, (int)500, (int)1000);
    }

    protected boolean isTrunkBase(BlockPos checkPos) {
        IBlockState state = this.field_145850_b.func_180495_p(checkPos.func_177977_b());
        Material material = state.func_185904_a();
        if (material != Material.field_151577_b && material != Material.field_151578_c && material != Material.field_151576_e) {
            return false;
        }
        return TapperManager.mappingExists(this.field_145850_b.func_180495_p(checkPos)) && TapperManager.mappingExists(this.field_145850_b.func_180495_p(checkPos.func_177984_a())) && TapperManager.mappingExists(this.field_145850_b.func_180495_p(checkPos.func_177981_b(2)));
    }

    protected static boolean isTapper(IBlockState state) {
        return state.func_177230_c() == TEBlocks.blockDevice && state.func_177229_b(BlockDevice.VARIANT) == BlockDevice.Type.TAPPER;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTapper(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTapper(inventory, (TileEntity)this);
    }

    public int getScaledSpeed(int scale) {
        if (!this.isActive) {
            return 0;
        }
        return MathHelper.round((double)(scale * this.boostTime / boostCycles));
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getBoostMult() {
        return this.boostMult;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.validTree = nbt.func_74767_n("Tree");
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut");
        this.tank.readFromNBT(nbt);
        this.boostMult = nbt.func_74762_e("BoostMult");
        this.boostTime = nbt.func_74762_e("BoostTime");
        this.timeConstant = nbt.func_74762_e("TimeConstant");
        if (this.timeConstant <= 0) {
            this.timeConstant = 500;
        }
        for (int i = 0; i < 3; ++i) {
            this.leafPos[i] = new BlockPos(nbt.func_74762_e("LeafX" + i), nbt.func_74762_e("LeafY" + i), nbt.func_74762_e("LeafZ" + i));
        }
        this.trunkPos = new BlockPos(nbt.func_74762_e("TrunkX"), nbt.func_74762_e("TrunkY"), nbt.func_74762_e("TrunkZ"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Tree", this.validTree);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        nbt.func_74768_a("BoostMult", this.boostMult);
        nbt.func_74768_a("BoostTime", this.boostTime);
        nbt.func_74768_a("TimeConstant", this.timeConstant);
        for (int i = 0; i < 3; ++i) {
            nbt.func_74768_a("LeafX" + i, this.leafPos[i].func_177958_n());
            nbt.func_74768_a("LeafY" + i, this.leafPos[i].func_177956_o());
            nbt.func_74768_a("LeafZ" + i, this.leafPos[i].func_177952_p());
        }
        nbt.func_74768_a("TrunkX", this.trunkPos.func_177958_n());
        nbt.func_74768_a("TrunkY", this.trunkPos.func_177956_o());
        nbt.func_74768_a("TrunkZ", this.trunkPos.func_177952_p());
        return nbt;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.boostTime);
        payload.addInt(this.boostMult);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addBool(this.validTree);
        payload.addFluidStack(this.genFluid);
        return payload;
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.boostTime = payload.getInt();
        this.boostMult = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.validTree = payload.getBool();
        this.genFluid = payload.getFluidStack();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.genFluid) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.genFluid;
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? this.genFluid.getFluid().getColor(this.genFluid) << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return TapperManager.getFertilizerMultiplier(stack) > 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileTapper.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileTapper)TileTapper.this).sideConfig.sideTypes[TileTapper.this.sideCache[from.ordinal()]])) {
                        return TileTapper.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileTapper)TileTapper.this).sideConfig.sideTypes[TileTapper.this.sideCache[from.ordinal()]])) {
                        return TileTapper.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

