/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.storage;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.ModelErrorStateProperty;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.texture.IWorldBlockTextureProvider;
import codechicken.lib.texture.TextureUtils;
import cofh.core.block.BlockCore;
import cofh.core.init.CoreEnchantments;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.storage.ItemBlockCache;
import cofh.thermalexpansion.block.storage.TileCache;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.render.BakeryCache;
import cofh.thermalfoundation.item.ItemMaterial;
import cofh.thermalfoundation.item.ItemUpgrade;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockCache
extends BlockTEBase
implements IModelRegister,
IBakeryProvider,
IWorldBlockTextureProvider {
    public static boolean enable = true;
    public static boolean enableCreative = true;
    public static boolean enableSecurity = true;
    public static boolean enableClassicRecipes = false;
    public static boolean enableUpgradeKitCrafting = false;
    public static ItemStack[] cache;
    public static ItemStack cacheCreative;
    public static ItemBlockCache itemBlock;

    public BlockCache() {
        super(Material.field_151573_f);
        this.func_149663_c("cache");
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.standardGui = false;
        this.configGui = true;
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this);
        builder.add(new IUnlistedProperty[]{ModelErrorStateProperty.ERROR_STATE});
        builder.add(new IUnlistedProperty[]{TEProps.TILE_CACHE});
        builder.add(new IUnlistedProperty[]{TEProps.BAKERY_WORLD});
        return builder.build();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (enable) {
            if (TEProps.creativeTabShowAllBlockLevels) {
                for (int j = 0; j <= 4; ++j) {
                    items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), j));
                }
            } else {
                items.add((Object)itemBlock.setDefaultTag(new ItemStack((Block)this), TEProps.creativeTabLevel));
            }
            if (TEProps.creativeTabShowCreative) {
                items.add((Object)itemBlock.setCreativeTag(new ItemStack((Block)this)));
            }
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCache();
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        TileCache tile = (TileCache)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return;
        }
        int extractAmount = !player.func_70093_af() && !player.field_71075_bZ.field_75098_d ? 1 : 64;
        ItemStack extract = tile.extractItem(extractAmount, true);
        if (extract.func_190926_b()) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (!player.field_71071_by.func_70441_a(extract)) {
                if (extract.func_190916_E() == extractAmount) {
                    return;
                }
                extractAmount -= extract.func_190916_E();
            }
            tile.extractItem(extractAmount, false);
        } else {
            player.field_71071_by.func_70441_a(extract);
            tile.extractItem(extractAmount, false);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.4f, 0.8f);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        if (stack.func_77978_p() != null) {
            TileCache tile = (TileCache)world.func_175625_s(pos);
            tile.isCreative = stack.func_77978_p().func_74767_n("Creative");
            tile.enchantHolding = (byte)MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack), (int)0, (int)CoreEnchantments.holding.func_77325_b());
            tile.setLevel(stack.func_77978_p().func_74771_c("Level"));
            if (stack.func_77978_p().func_74764_b("Item")) {
                ItemStack item = ItemHelper.readItemStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Item"));
                tile.getHandler().setItem(item);
                tile.setLocked(stack.func_77978_p().func_74767_n("Lock"));
            }
        }
        super.func_180633_a(world, pos, state, living, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean onBlockActivatedDelegate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileCache tile = (TileCache)world.func_175625_s(pos);
        if (tile == null || !tile.canPlayerAccess(player)) {
            return false;
        }
        if (ItemHelper.isPlayerHoldingNothing((EntityPlayer)player) && player.func_70093_af()) {
            tile.setLocked(!tile.isLocked());
            if (tile.isLocked()) {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.2f, 0.8f);
            } else {
                world.func_184133_a(null, pos, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f);
            }
            return true;
        }
        boolean playSound = false;
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack ret = tile.insertItem(heldItem, false);
        long time = player.getEntityData().func_74763_f("thermalexpansion:CacheClick");
        long currentTime = world.func_82737_E();
        player.getEntityData().func_74772_a("thermalexpansion:CacheClick", currentTime);
        if (!player.field_71075_bZ.field_75098_d) {
            if (ret != heldItem) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ret);
                playSound = true;
            }
            if (!tile.getStoredInstance().func_190926_b() && currentTime - time < 15L) {
                playSound &= !BlockCache.insertAllItemsFromPlayer(tile, player);
            }
        }
        if (playSound) {
            world.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.1f, 0.7f);
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.field_71075_bZ.field_75098_d && !player.func_70093_af()) {
            this.func_180649_a(world, pos, player);
            return false;
        }
        this.func_176208_a(world, pos, world.func_180495_p(pos), player);
        return world.func_175698_g(pos);
    }

    private static boolean insertAllItemsFromPlayer(TileCache tile, EntityPlayer player) {
        boolean playSound = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (tile.insertItem(player.field_71071_by.func_70301_a(i), true) == player.field_71071_by.func_70301_a(i)) continue;
            player.field_71071_by.func_70299_a(i, tile.insertItem(player.field_71071_by.func_70301_a(i), false));
            playSound = true;
        }
        if (playSound) {
            tile.func_145831_w().func_184133_a(null, tile.func_174877_v(), SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.1f, 0.7f);
        }
        return playSound;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !ForgeHooks.isToolEffective((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) {
            return -1.0f;
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public NBTTagCompound getItemStackTag(IBlockAccess world, BlockPos pos) {
        NBTTagCompound retTag = super.getItemStackTag(world, pos);
        TileCache tile = (TileCache)world.func_175625_s(pos);
        if (tile != null) {
            if (tile.enchantHolding > 0) {
                CoreEnchantments.addEnchantment((NBTTagCompound)retTag, (Enchantment)CoreEnchantments.holding, (int)tile.enchantHolding);
            }
            if (!tile.getStoredInstance().func_190926_b()) {
                retTag.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)tile.getStoredInstance(), (int)tile.getStoredCount(), (NBTTagCompound)new NBTTagCompound()));
                retTag.func_74757_a("Lock", tile.lock);
            }
        }
        return retTag;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ModelBakery.handleExtendedState((IExtendedBlockState)((IExtendedBlockState)super.getExtendedState(state, world, pos)), (IBlockAccess)world, (BlockPos)pos);
    }

    public IBakery getBakery() {
        return BakeryCache.INSTANCE;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, ItemStack stack) {
        boolean isCreative = itemBlock.isCreative(stack);
        int level = itemBlock.getLevel(stack);
        if (side == EnumFacing.DOWN) {
            return isCreative ? TETextures.CACHE_BOTTOM_C : TETextures.CACHE_BOTTOM[level];
        }
        if (side == EnumFacing.UP) {
            return isCreative ? TETextures.CACHE_TOP_C : TETextures.CACHE_TOP[level];
        }
        return side != EnumFacing.NORTH ? (isCreative ? TETextures.CACHE_SIDE_C : TETextures.CACHE_SIDE[level]) : (isCreative ? TETextures.CACHE_FACE_C : TETextures.CACHE_FACE[level]);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(EnumFacing side, IBlockState state, BlockRenderLayer layer, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileCache) {
            TileCache tile = (TileCache)tileEntity;
            return tile.getTexture(side.ordinal(), layer == BlockRenderLayer.SOLID ? 0 : 1);
        }
        return TextureUtils.getMissingSprite();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper("thermalexpansion", "cache", "cache");
        ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)mapper.location);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)mapper);
        ModelLoader.setCustomMeshDefinition((Item)itemBlock, (ItemMeshDefinition)mapper);
        ModelRegistryHelper.register((ModelResourceLocation)mapper.location, (IBakedModel)new CCBakeryModel());
        ModelBakery.registerBlockKeyGenerator((Block)this, state -> {
            TileCache tile = (TileCache)((Object)((Object)state.getValue(TEProps.TILE_CACHE)));
            StringBuilder builder = new StringBuilder(state.func_177230_c().getRegistryName().toString() + "|" + state.func_177230_c().func_176201_c((IBlockState)state));
            builder.append(",creative=").append(tile.isCreative);
            builder.append(",level=").append(tile.getLevel());
            builder.append(",holding=").append(tile.enchantHolding);
            builder.append(",facing=").append(tile.getFacing());
            builder.append(",scale=").append(MathHelper.clamp((int)(tile.getStoredCount() > 0 ? 1 + tile.getScaledItemsStored(8) : 0), (int)0, (int)8));
            return builder.toString();
        });
        ModelBakery.registerItemKeyGenerator((Item)itemBlock, stack -> ModelBakery.defaultItemKeyGenerator.generateKey(stack) + ",creative=" + itemBlock.isCreative(stack) + ",level=" + itemBlock.getLevel(stack));
    }

    public boolean preInit() {
        this.setRegistryName("cache");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        itemBlock = new ItemBlockCache((BlockCore)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        TileCache.initialize();
        ThermalExpansion.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        cache = new ItemStack[5];
        for (int i = 0; i < 5; ++i) {
            BlockCache.cache[i] = itemBlock.setDefaultTag(new ItemStack((Block)this), i);
        }
        cacheCreative = itemBlock.setCreativeTag(new ItemStack((Block)this));
        this.addRecipes();
        this.addUpgradeRecipes();
        this.addClassicRecipes();
        return true;
    }

    private void addRecipes() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)cache[0], (Object[])new Object[]{" I ", "ICI", " P ", Character.valueOf('C'), "chestWood", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), ItemMaterial.redstoneServo});
        }
    }

    private void addUpgradeRecipes() {
        int j;
        if (!enableUpgradeKitCrafting || !enable) {
            return;
        }
        if (!enableClassicRecipes) {
            for (j = 0; j < 4; ++j) {
                RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cache[j + 1], (Object[])new Object[]{cache[j], ItemUpgrade.upgradeIncremental[j]});
            }
            for (j = 1; j < 4; ++j) {
                for (int k = 0; k <= j; ++k) {
                    RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cache[j + 1], (Object[])new Object[]{cache[k], ItemUpgrade.upgradeFull[j]});
                }
            }
        }
        for (j = 0; j < 5; ++j) {
            RecipeHelper.addShapelessUpgradeKitRecipe((ItemStack)cacheCreative, (Object[])new Object[]{cache[j], ItemUpgrade.upgradeCreative});
        }
    }

    private void addClassicRecipes() {
        if (!enableClassicRecipes || !enable) {
            return;
        }
        RecipeHelper.addShapedRecipe((ItemStack)cache[1], (Object[])new Object[]{"YIY", "ICI", "YPY", Character.valueOf('C'), "chestWood", Character.valueOf('I'), "ingotTin", Character.valueOf('P'), ItemMaterial.redstoneServo, Character.valueOf('Y'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cache[1], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cache[0], Character.valueOf('I'), "ingotInvar"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cache[2], (Object[])new Object[]{"YIY", "ICI", "YIY", Character.valueOf('C'), cache[1], Character.valueOf('I'), "ingotElectrum", Character.valueOf('Y'), "blockGlassHardened"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cache[3], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cache[2], Character.valueOf('I'), "ingotSignalum"});
        RecipeHelper.addShapedUpgradeRecipe((ItemStack)cache[4], (Object[])new Object[]{" I ", "ICI", " I ", Character.valueOf('C'), cache[3], Character.valueOf('I'), "ingotEnderium"});
    }
}

