/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.ItemStackPlusScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.ItemStackPlusClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryPlusModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    public InventoryPlusModuleItem() {
        super("inventoryplus_module");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.ITEMSTACK_RFPERTICK + " RF/tick");
        boolean hasTarget = false;
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.func_74779_i("text"));
            if (tagCompound.func_74764_b("monitorx")) {
                int dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                int monitorx = tagCompound.func_74762_e("monitorx");
                int monitory = tagCompound.func_74762_e("monitory");
                int monitorz = tagCompound.func_74762_e("monitorz");
                String monitorname = tagCompound.func_74779_i("monitorname");
                list.add(TextFormatting.YELLOW + "Monitoring: " + monitorname + " (at " + monitorx + "," + monitory + "," + monitorz + ")");
                list.add(TextFormatting.YELLOW + "Dimension: " + dim);
                hasTarget = true;
            }
        }
        if (!hasTarget) {
            list.add(TextFormatting.YELLOW + "Sneak right-click on an inventory to set the");
            list.add(TextFormatting.YELLOW + "target for this inventory module");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "This is not a valid inventory!"));
            }
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (CapabilityTools.hasItemCapabilitySafe((TileEntity)te) || te instanceof IInventory) {
            tagCompound.func_74768_a("monitordim", world.field_73011_w.getDimension());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockAccess)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)("Inventory module is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((EntityPlayer)player, (String)"Inventory module is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return EnumActionResult.SUCCESS;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public Class<ItemStackPlusScreenModule> getServerScreenModule() {
        return ItemStackPlusScreenModule.class;
    }

    public Class<ItemStackPlusClientScreenModule> getClientScreenModule() {
        return ItemStackPlusClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Inv";
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Slot 1:").integer("slot1", "Slot index to show").nl().label("Slot 2:").integer("slot2", "Slot index to show").nl().label("Slot 3:").integer("slot3", "Slot index to show").nl().label("Slot 4:").integer("slot4", "Slot index to show").nl().block("monitor").nl();
    }
}

