/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.block;

import buildcraft.api.tools.IToolWrench;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.block.states.BlockStateReactor;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockReactor
extends Block
implements ITileEntityProvider {
    public BlockReactor() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
        this.func_149647_a((CreativeTabs)Mekanism.tabMekanism);
    }

    public static BlockReactor getReactorBlock(final BlockStateReactor.ReactorBlock block) {
        return new BlockReactor(){

            @Override
            public BlockStateReactor.ReactorBlock getReactorBlock() {
                return block;
            }
        };
    }

    public abstract BlockStateReactor.ReactorBlock getReactorBlock();

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (tile instanceof TileEntityReactorController) {
            state = state.func_177226_a((IProperty)BlockStateReactor.activeProperty, (Comparable)Boolean.valueOf(((IActiveState)tile).getActive()));
        }
        if (tile instanceof TileEntityReactorPort) {
            state = state.func_177226_a((IProperty)BlockStateReactor.activeProperty, (Comparable)Boolean.valueOf(((TileEntityReactorPort)tile).fluidEject));
        }
        return state;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateReactor(this, this.getTypeProperty());
    }

    public IBlockState func_176203_a(int meta) {
        BlockStateReactor.ReactorBlockType type = BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateReactor.ReactorBlockType type = (BlockStateReactor.ReactorBlockType)((Object)state.func_177229_b(this.getTypeProperty()));
        return type.meta;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityElectricBlock tileEntity = (TileEntityElectricBlock)world.func_175625_s(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && MekanismUtils.isBCWrench((Item)stack.func_77973_b()) && !stack.func_77977_a().contains("omniwrench")) {
            if (entityplayer.func_70093_af()) {
                this.dismantleBlock(world, pos, false);
                return true;
            }
            ((IToolWrench)stack.func_77973_b()).wrenchUsed(entityplayer, hand, stack, new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos));
            return true;
        }
        if (tileEntity instanceof TileEntityReactorController && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)MekanismGenerators.instance, BlockStateReactor.ReactorBlockType.get((Block)this, (int)metadata).guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        if (tileEntity instanceof TileEntityReactorLogicAdapter && !entityplayer.func_70093_af()) {
            entityplayer.openGui((Object)MekanismGenerators.instance, BlockStateReactor.ReactorBlockType.get((Block)this, (int)metadata).guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        for (BlockStateReactor.ReactorBlockType type : BlockStateReactor.ReactorBlockType.values()) {
            if (type.blockType != this.getReactorBlock()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.meta));
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if (BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), metadata) == null) {
            return null;
        }
        return BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), metadata).create();
    }

    public BlockRenderLayer func_180664_k() {
        return this == GeneratorsBlocks.Reactor ? BlockRenderLayer.CUTOUT : BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState stateOffset;
        int meta = state.func_177230_c().func_176201_c(state);
        BlockStateReactor.ReactorBlockType type = BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), meta);
        if ((type == BlockStateReactor.ReactorBlockType.REACTOR_GLASS || type == BlockStateReactor.ReactorBlockType.LASER_FOCUS_MATRIX) && this == (stateOffset = world.func_180495_p(pos.func_177972_a(side))).func_177230_c()) {
            int metaOffset = stateOffset.func_177230_c().func_176201_c(stateOffset);
            BlockStateReactor.ReactorBlockType typeOffset = BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), metaOffset);
            if (typeOffset == BlockStateReactor.ReactorBlockType.REACTOR_GLASS || typeOffset == BlockStateReactor.ReactorBlockType.LASER_FOCUS_MATRIX) {
                return false;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = MekanismUtils.getTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (tile instanceof TileEntityReactorLogicAdapter) {
            return ((TileEntityReactorLogicAdapter)tile).checkMode() ? 15 : 0;
        }
        return 0;
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockStateReactor.ReactorBlockType type = BlockStateReactor.ReactorBlockType.get(this.getReactorBlock(), state.func_177230_c().func_176201_c(state));
        switch (type) {
            case REACTOR_FRAME: 
            case REACTOR_PORT: 
            case REACTOR_LOGIC_ADAPTER: {
                return true;
            }
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockStateReactor.ReactorBlockType type = BlockStateReactor.ReactorBlockType.get(this, state.func_177230_c().func_176201_c(state));
        switch (type) {
            case REACTOR_LOGIC_ADAPTER: {
                return true;
            }
        }
        return false;
    }

    public ItemStack dismantleBlock(World world, BlockPos pos, boolean returnBlock) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack itemStack = new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state));
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public PropertyEnum<BlockStateReactor.ReactorBlockType> getTypeProperty() {
        return this.getReactorBlock().getProperty();
    }
}

