/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.planets.venus.tick.VenusTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.venus.tile.SolarModuleNetwork;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayModule;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public abstract class TileEntitySolarTransmitter
extends TileEntityAdvanced
implements ITransmitter {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;
    private boolean validated = true;

    public void func_145829_t() {
        this.validated = false;
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.getNetwork().split((Object)this);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        super.func_145843_s();
        super.onChunkUnload();
    }

    public IGridNetwork getNetwork() {
        if (this.network == null) {
            this.resetNetwork();
        }
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void onNetworkChanged() {
        this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.validated) {
            VenusTickHandlerServer.solarTransmitterUpdates.add(this);
            this.validated = true;
        }
        super.func_73660_a();
    }

    protected void resetNetwork() {
        SolarModuleNetwork network = new SolarModuleNetwork();
        this.setNetwork(network);
        network.addTransmitter(this);
        network.register();
    }

    public void setNetwork(IGridNetwork network) {
        if (this.network == network) {
            return;
        }
        if (this.field_145850_b.field_72995_K && this.network != null) {
            SolarModuleNetwork solarNetwork = (SolarModuleNetwork)this.network;
            solarNetwork.removeTransmitter(this);
            if (solarNetwork.getTransmitters().isEmpty()) {
                solarNetwork.unregister();
            }
        }
        this.network = network;
        if (this.field_145850_b.field_72995_K && this.network != null) {
            ((SolarModuleNetwork)this.network).getTransmitters().add(this);
        }
    }

    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            BlockVec3 thisVec = new BlockVec3((TileEntity)this);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, side);
                if (tileEntity == null || tileEntity.getClass() != ((Object)((Object)this)).getClass() || !(tileEntity instanceof INetworkProvider) || !((INetworkProvider)tileEntity).hasNetwork() || tileEntity instanceof ITransmitter && !((ITransmitter)tileEntity).canConnect(side.func_176734_d(), ((ITransmitter)tileEntity).getNetworkType())) continue;
                if (!this.hasNetwork()) {
                    this.setNetwork(((INetworkProvider)tileEntity).getNetwork());
                    ((SolarModuleNetwork)this.getNetwork()).addTransmitter(this);
                    continue;
                }
                if (!this.hasNetwork() || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork((IGridNetwork)this.getNetwork().merge((Object)((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = new TileEntity[EnumFacing.field_82609_l.length];
            BlockVec3 thisVec = new BlockVec3((TileEntity)this);
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                TileEntity tileEntity = thisVec.getTileEntityOnSide(this.field_145850_b, direction);
                if (!(tileEntity instanceof TileEntitySolarArrayModule) || !this.field_145850_b.field_72995_K && !((TileEntitySolarArrayModule)tileEntity).canConnect(direction.func_176734_d(), NetworkType.SOLAR_MODULE)) continue;
                this.adjacentConnections[direction.ordinal()] = tileEntity;
            }
        }
        return this.adjacentConnections;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        return type == NetworkType.SOLAR_MODULE;
    }

    public NetworkType getNetworkType() {
        return NetworkType.SOLAR_MODULE;
    }

    public double getPacketRange() {
        return 0.0;
    }

    public int getPacketCooldown() {
        return 0;
    }

    public boolean isNetworkedTile() {
        return false;
    }
}

