/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonConfigurationVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonStartVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.PieceVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.SizedPieceVenus;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class RoomEntranceVenus
extends SizedPieceVenus {
    private final int range = 4;

    public RoomEntranceVenus() {
    }

    public RoomEntranceVenus(World world, DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ) {
        super(configuration, rand.nextInt(4) + 6, rand.nextInt(2) + 5, rand.nextInt(4) + 6, EnumFacing.Plane.HORIZONTAL.func_179518_a(rand));
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX - 4, configuration.getYPosition(), blockPosZ - 4, blockPosX + 4, 150, blockPosZ + 4);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        int i;
        int maxLevel = 0;
        for (int i2 = -4; i2 <= 4; ++i2) {
            for (int k = -4; k <= 4; ++k) {
                Block block;
                int j = this.field_74887_e.func_78882_c();
                while (j >= 0 && (Blocks.field_150350_a == (block = this.func_175807_a(worldIn, i2 + 4, --j, k + 4, this.field_74887_e).func_177230_c()) || block == null)) {
                }
                maxLevel = Math.max(maxLevel, j + 3);
            }
        }
        int startX = 4 - this.sizeX / 2;
        int startZ = 4 - this.sizeZ / 2;
        int endX = 4 + this.sizeX / 2;
        int endZ = 4 + this.sizeZ / 2;
        for (i = startX; i <= endX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = startZ; k <= endZ; ++k) {
                    if (i == startX || i == endX || j == 0 || j == this.sizeY || k == startZ || k == endZ) {
                        this.func_175811_a(worldIn, j == 0 || j == this.sizeY ? this.configuration.getBrickBlockFloor() : this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        for (i = -4; i < 4; ++i) {
            for (int k = -4; k < 4; ++k) {
                double xDev = (double)i / 15.0;
                double zDev = (double)k / 15.0;
                double distance = xDev * xDev + zDev * zDev;
                int depth = (int)Math.abs(0.5 / (distance + 1.0E-5));
                int helper = 0;
                for (int j = maxLevel; j > 1 && helper <= depth; --j) {
                    IBlockState block1 = this.func_175807_a(worldIn, i + 4, j, k + 4, this.field_74887_e);
                    if (block1 != this.configuration.getBrickBlockFloor() && j == this.sizeY) continue;
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i + 4, j, k + 4, this.field_74887_e);
                    ++helper;
                }
            }
        }
        return true;
    }

    @Override
    public PieceVenus getNextPiece(DungeonStartVenus startPiece, Random rand) {
        if (startPiece.attachedComponents.isEmpty()) {
            return this.getCorridor(rand, startPiece, 10, false);
        }
        return null;
    }

    @Override
    protected StructureBoundingBox getExtension(EnumFacing direction, int length, int width) {
        int blockZ;
        int blockX;
        int sizeZ;
        int sizeX;
        int startX = this.field_74887_e.field_78897_a + 4 - this.sizeX / 2;
        int startZ = this.field_74887_e.field_78896_c + 4 - this.sizeZ / 2;
        int endX = this.field_74887_e.field_78897_a + 4 + this.sizeX / 2;
        int endZ = this.field_74887_e.field_78896_c + 4 + this.sizeZ / 2;
        switch (direction) {
            case NORTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = startZ - sizeZ;
                break;
            }
            case EAST: {
                sizeX = length;
                sizeZ = width;
                blockX = endX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
                break;
            }
            case SOUTH: {
                sizeX = width;
                sizeZ = length;
                blockX = startX + (endX - startX) / 2 - sizeX / 2;
                blockZ = endZ;
                break;
            }
            default: {
                sizeX = length;
                sizeZ = width;
                blockX = startX - sizeX;
                blockZ = startZ + (endZ - startZ) / 2 - sizeZ / 2;
            }
        }
        return new StructureBoundingBox(blockX, blockZ, blockX + sizeX, blockZ + sizeZ);
    }
}

