/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.fluids;

import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class FluidTankWithTile
extends FluidTank {
    public FluidTankWithTile(TileEntity tileEntity, int capacity) {
        super(capacity);
        this.tile = tileEntity;
    }

    public FluidTankWithTile(TileEntity tileEntity, FluidStack stack, int capacity) {
        super(stack, capacity);
        this.tile = tileEntity;
    }

    public FluidTankWithTile(TileEntity tileEntity, Fluid fluid, int amount, int capacity) {
        super(fluid, amount, capacity);
        this.tile = tileEntity;
    }

    public int fill(FluidStack resource, boolean doFill) {
        this.notifyBlockUpdate();
        this.tile.func_70296_d();
        return super.fill(resource, doFill);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        this.notifyBlockUpdate();
        this.tile.func_70296_d();
        return super.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        this.notifyBlockUpdate();
        this.tile.func_70296_d();
        return super.drain(maxDrain, doDrain);
    }

    private void notifyBlockUpdate() {
        World world = this.tile.func_145831_w();
        BlockPos pos = this.tile.func_174877_v();
        IBlockState state = world.func_180495_p(pos);
        world.func_184138_a(pos, state, state, 3);
    }
}

