/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy.tiles;

import javax.annotation.Nonnull;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyOutputter;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.core.api.asm.TileEnergyHandler;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.energy.ITileEnergyHandler;
import sonar.core.api.utils.ActionType;

@TileEnergyHandler(modid="mekanism", priority=4)
public class TileHandlerMekanism
implements ITileEnergyHandler {
    @Override
    public EnergyType getEnergyType() {
        return EnergyType.MJ;
    }

    @Override
    public boolean canRenderConnection(@Nonnull TileEntity tile, EnumFacing dir) {
        return this.canAddEnergy(tile, dir) || this.canRemoveEnergy(tile, dir);
    }

    @Override
    public boolean canAddEnergy(TileEntity tile, EnumFacing dir) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_ACCEPTOR_CAPABILITY, (EnumFacing)dir)) {
            return ((IStrictEnergyAcceptor)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_ACCEPTOR_CAPABILITY, (EnumFacing)dir)).canReceiveEnergy(dir);
        }
        return false;
    }

    @Override
    public boolean canRemoveEnergy(TileEntity tile, EnumFacing dir) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_OUTPUTTER_CAPABILITY, (EnumFacing)dir)) {
            return ((IStrictEnergyOutputter)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_OUTPUTTER_CAPABILITY, (EnumFacing)dir)).canOutputEnergy(dir);
        }
        return false;
    }

    @Override
    public boolean canReadEnergy(TileEntity tile, EnumFacing dir) {
        return CapabilityUtils.hasCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_STORAGE_CAPABILITY, (EnumFacing)dir);
    }

    @Override
    public long addEnergy(long add, TileEntity tile, EnumFacing dir, ActionType actionType) {
        IStrictEnergyAcceptor accept = (IStrictEnergyAcceptor)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_ACCEPTOR_CAPABILITY, (EnumFacing)dir);
        return (long)accept.acceptEnergy(dir, (double)add, actionType.shouldSimulate());
    }

    @Override
    public long removeEnergy(long remove, TileEntity tile, EnumFacing dir, ActionType actionType) {
        IStrictEnergyOutputter accept = (IStrictEnergyOutputter)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_OUTPUTTER_CAPABILITY, (EnumFacing)dir);
        return (long)accept.pullEnergy(dir, (double)remove, actionType.shouldSimulate());
    }

    @Override
    public long getStored(TileEntity tile, EnumFacing dir) {
        return (long)((IStrictEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_STORAGE_CAPABILITY, (EnumFacing)dir)).getEnergy();
    }

    @Override
    public long getCapacity(TileEntity tile, EnumFacing dir) {
        return (long)((IStrictEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)tile, (Capability)Capabilities.ENERGY_STORAGE_CAPABILITY, (EnumFacing)dir)).getMaxEnergy();
    }
}

