/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.recipes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import sonar.core.SonarCore;
import sonar.core.handlers.inventories.ItemStackHelper;
import sonar.core.recipes.DefaultSonarRecipe;
import sonar.core.recipes.IRecipeHelperV2;
import sonar.core.recipes.ISonarRecipe;
import sonar.core.recipes.ISonarRecipeItem;
import sonar.core.recipes.ISonarRecipeObject;
import sonar.core.recipes.RecipeInteger;
import sonar.core.recipes.RecipeInterchangable;
import sonar.core.recipes.RecipeItemStack;
import sonar.core.recipes.RecipeObjectType;
import sonar.core.recipes.RecipeOreStack;

public abstract class RecipeHelperV2<T extends ISonarRecipe>
implements IRecipeHelperV2<T> {
    public ArrayList<T> recipes = new ArrayList();
    public ArrayList<Class<?>> validInputs = Lists.newArrayList((Object[])new Class[]{ISonarRecipeObject.class, ItemStack.class, Item.class, Block.class, ItemStack[].class, List.class, String.class, Integer.class});
    public ArrayList<Class<?>> validOutputs = Lists.newArrayList((Object[])new Class[]{ISonarRecipeObject.class, ItemStack.class, Item.class, Block.class, String.class, Integer.class});
    public ArrayList<Class<?>> adjusted = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class});

    @Override
    public abstract String getRecipeID();

    public abstract void addRecipes();

    @Override
    public ArrayList<T> getRecipes() {
        return this.recipes;
    }

    public List<ISonarRecipeObject> getInputs(EntityPlayer player, Object ... outputs) {
        T recipe = this.getRecipeFromOutputs(player, outputs);
        return recipe != null ? recipe.inputs() : new ArrayList<ISonarRecipeObject>();
    }

    public List<ISonarRecipeObject> getOutputs(EntityPlayer player, Object ... inputs) {
        T recipe = this.getRecipeFromInputs(player, inputs);
        return recipe != null ? recipe.outputs() : new ArrayList<ISonarRecipeObject>();
    }

    @Nullable
    public T getRecipeFromInputs(@Nullable EntityPlayer player, Object[] inputs) {
        for (ISonarRecipe recipe : this.recipes) {
            if (player != null && !recipe.canUseRecipe(player) || !recipe.matchingInputs(inputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    @Nullable
    public T getRecipeFromOutputs(@Nullable EntityPlayer player, Object[] outputs) {
        for (ISonarRecipe recipe : this.recipes) {
            if (player != null && !recipe.canUseRecipe(player) || !recipe.matchingOutputs(outputs)) continue;
            return (T)recipe;
        }
        return null;
    }

    public boolean addRecipe(T recipe) {
        return recipe != null && this.recipes.add(recipe);
    }

    public boolean removeRecipe(T recipe) {
        return recipe != null && this.recipes.remove(recipe);
    }

    public void addValidInput(Class inputTypes) {
        this.validInputs.add(inputTypes);
    }

    private boolean isValidInputType(Object input) {
        for (Class<?> inputType : this.validInputs) {
            List list;
            if (!(input instanceof List && inputType == List.class ? !(list = (List)input).isEmpty() && this.isValidInputType(list.get(0)) : inputType.isInstance(input))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidOutputType(Object output) {
        for (Class<?> outputType : this.validOutputs) {
            if (!outputType.isInstance(output)) continue;
            return true;
        }
        return false;
    }

    private boolean requiresAdjustment(Object obj) {
        for (Class<?> objectType : this.adjusted) {
            if (!objectType.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ISonarRecipeObject buildRecipeObject(Object obj) {
        if (this.requiresAdjustment(obj)) {
            obj = RecipeHelperV2.adjustObject(obj);
        }
        if (obj instanceof ISonarRecipeObject) {
            return (ISonarRecipeObject)obj;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            ArrayList<ISonarRecipeObject> buildList = new ArrayList<ISonarRecipeObject>();
            if (!list.isEmpty()) {
                for (Object listObj : list) {
                    if (listObj == null) continue;
                    ISonarRecipeObject recipeObject = this.buildRecipeObject(listObj);
                    if (recipeObject != null) {
                        buildList.add(recipeObject);
                        continue;
                    }
                    return null;
                }
                return new RecipeInterchangable(buildList);
            }
            return null;
        }
        if (obj instanceof String) {
            return new RecipeOreStack((String)obj, 1);
        }
        if (obj instanceof Integer) {
            return new RecipeInteger((Integer)obj);
        }
        if (obj instanceof ItemStack) {
            return new RecipeItemStack((ItemStack)obj, true);
        }
        return null;
    }

    public void addRecipe(List inputs, List outputs, List additionals, boolean shapeless) {
        this.addRecipe(this.buildDefaultRecipe(inputs, outputs, additionals, shapeless));
    }

    @Nullable
    public T buildDefaultRecipe(List inputs, List outputs, List additionals, boolean shapeless) {
        ArrayList<ISonarRecipeObject> recipeInputs = new ArrayList<ISonarRecipeObject>();
        ArrayList<ISonarRecipeObject> recipeOutputs = new ArrayList<ISonarRecipeObject>();
        for (Object obj : inputs) {
            if (obj != null && this.isValidInputType(obj)) {
                ISonarRecipeObject input = this.buildRecipeObject(obj);
                if (input == null) {
                    return null;
                }
                recipeInputs.add(input);
                continue;
            }
            SonarCore.logger.error("Invalid Recipe Input for " + this.getRecipeID() + ": " + obj);
            return null;
        }
        for (Object obj : outputs) {
            if (obj != null && this.isValidOutputType(obj)) {
                ISonarRecipeObject output = this.buildRecipeObject(obj);
                if (output == null) {
                    return null;
                }
                recipeOutputs.add(output);
                continue;
            }
            SonarCore.logger.error("Invalid Recipe Output for " + this.getRecipeID() + ": " + obj);
            return null;
        }
        if (!this.isValidRecipe(recipeInputs, recipeOutputs)) {
            SonarCore.logger.error("Invalid Recipe for " + this.getRecipeID() + ": " + recipeInputs.toString() + " -> " + recipeOutputs.toString());
        }
        return this.buildRecipe(recipeInputs, recipeOutputs, additionals, shapeless);
    }

    public boolean isValidRecipe(ArrayList<ISonarRecipeObject> recipeInputs, ArrayList<ISonarRecipeObject> recipeOutputs) {
        return recipeInputs.size() != 0 && recipeOutputs.size() != 0;
    }

    public T buildRecipe(List<ISonarRecipeObject> recipeInputs, List<ISonarRecipeObject> recipeOutputs, List additionals, boolean shapeless) {
        return (T)new DefaultSonarRecipe(recipeInputs, recipeOutputs, shapeless);
    }

    public boolean isValidOutput(Object obj) {
        for (ISonarRecipe recipe : this.recipes) {
            for (ISonarRecipeObject output : recipe.outputs()) {
                if (!output.matches(obj, RecipeObjectType.OUTPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidInput(Object obj) {
        for (ISonarRecipe recipe : this.recipes) {
            for (ISonarRecipeObject input : recipe.inputs()) {
                if (!input.matches(obj, RecipeObjectType.INPUT)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object adjustObject(Object obj) {
        return ItemStackHelper.getOrCreateStack(obj);
    }

    public static ArrayList<List<ItemStack>> getJEIInputsFromList(List<ISonarRecipeObject> list) {
        ArrayList<List<ItemStack>> values = new ArrayList<List<ItemStack>>();
        list.forEach(obj -> values.add(obj.getJEIValue()));
        return values;
    }

    public static List<ItemStack> getJEIOutputsFromList(List<ISonarRecipeObject> list) {
        ArrayList<ItemStack> values = new ArrayList<ItemStack>();
        list.forEach(obj -> values.add(obj.getJEIValue().get(0)));
        return values;
    }

    public static List getValuesFromList(List<ISonarRecipeObject> list) {
        ArrayList values = new ArrayList();
        list.forEach(obj -> values.add(obj.getValue()));
        return values;
    }

    @Nonnull
    public static ItemStack getItemStackFromList(List<ISonarRecipeObject> list, int pos) {
        ISonarRecipeObject obj;
        if (!list.isEmpty() && pos < list.size() && (obj = list.get(pos)) instanceof ISonarRecipeItem) {
            return ((ISonarRecipeItem)((Object)obj)).getOutputStack();
        }
        return ItemStack.field_190927_a;
    }

    public static boolean matchingIngredients(RecipeObjectType type, List<ISonarRecipeObject> ingredients, boolean shapeless, Object[] objs) {
        ArrayList matches = Lists.newArrayList(ingredients);
        if (ingredients.size() != objs.length) {
            return false;
        }
        int pos = -1;
        block0: for (Object obj : objs) {
            if (obj == null) {
                return false;
            }
            ++pos;
            if (obj instanceof List) {
                List list = (List)obj;
                for (Object listObj : list) {
                    if (!RecipeHelperV2.matchingIngredient(listObj, pos, type, matches, ingredients, shapeless)) continue;
                    continue block0;
                }
            }
            if (RecipeHelperV2.matchingIngredient(obj, pos, type, matches, ingredients, shapeless)) continue;
            return false;
        }
        return true;
    }

    public static boolean matchingIngredient(Object obj, int pos, RecipeObjectType type, List<ISonarRecipeObject> matches, List<ISonarRecipeObject> ingredients, boolean shapeless) {
        if (shapeless) {
            for (ISonarRecipeObject ingredient : Lists.newArrayList(matches)) {
                if (!ingredient.matches(obj, type)) continue;
                matches.remove(ingredient);
                return true;
            }
        } else if (ingredients.get(pos).matches(obj, type)) {
            matches.remove(ingredients.get(pos));
            return true;
        }
        if (type == RecipeObjectType.INPUT) {
            return false;
        }
        return false;
    }
}

