/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.ISyncHandler;
import sonar.core.sync.ISyncHandlerFactory;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.ISyncValueFactory;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SonarControlledList;
import sonar.core.sync.SonarValue;
import sonar.core.sync.SonarValueList;
import sonar.core.sync.SyncHandlerGeneral;
import sonar.core.sync.SyncHandlerNBTSyncable;
import sonar.core.sync.SyncHandlerPrimitive;
import sonar.core.sync.SyncValue;
import sonar.core.sync.SyncedValueList;

public class SyncRegistry {
    private static List<ISyncValueFactory> value_factories = new ArrayList<ISyncValueFactory>();
    private static List<ISyncHandlerFactory> handler_factories = new ArrayList<ISyncHandlerFactory>();
    private static Map<Class, ISyncHandler> handlers = new HashMap<Class, ISyncHandler>();

    public static <T> ISonarValue<T> createSonarValue(Class<T> type, IValueWatcher watcher, T setting) {
        return new SonarValue<T>(type, watcher, setting);
    }

    public static <T> ISonarValue<List<T>> createSonarValueList(Class<T> type, IValueWatcher watcher, List<T> setting) {
        return new SonarValueList<T>(type, watcher, setting);
    }

    public static <T> ISonarValue<List<T>> createSonarControlledList(Class<T> type, IValueWatcher watcher, List<T> setting) {
        return new SonarControlledList<T>(type, watcher, setting);
    }

    public static <T> ISyncValue<List<T>> createListValue(Class<T> type, IValueWatcher watcher, String key, List<T> setting) {
        return new SyncedValueList<T>(type, watcher, key, setting);
    }

    public static <T> ISyncValue<T> createValue(Class<T> type, IValueWatcher watcher, String key, T setting) {
        ISyncValue<T> value = SyncRegistry.createValue(type, watcher, key);
        value.setValueInternal(setting);
        return value;
    }

    public static <T> ISyncValue<T> createValue(Class<T> type, IValueWatcher watcher, String key) {
        for (ISyncValueFactory factory : value_factories) {
            ISyncValue value = factory.createValue(type, watcher, key);
            if (value == null) continue;
            return value;
        }
        ISyncHandler handler = SyncRegistry.getHandler(type);
        if (handler != null) {
            return new SyncValue<T>(type, watcher, key);
        }
        throw new NullPointerException("INVALID VALUE TYPE: " + type);
    }

    public static ISyncHandler getHandler(Class clazz) {
        for (ISyncHandlerFactory factory : handler_factories) {
            ISyncHandler handler = factory.createHandler(clazz);
            if (handler == null) continue;
            return handler;
        }
        Optional<Map.Entry> handler = handlers.entrySet().stream().filter(C -> ((Class)C.getKey()).isAssignableFrom(clazz)).findFirst();
        return handler.map(Map.Entry::getValue).orElse(null);
    }

    static {
        handler_factories.add(clazz -> clazz.isEnum() ? new SyncHandlerGeneral.SyncHandlerEnum((Enum[])clazz.getEnumConstants()) : null);
        handler_factories.add(clazz -> INBTSyncable.class.isAssignableFrom(clazz) ? new SyncHandlerNBTSyncable(clazz) : null);
        handlers.put(Boolean.class, new SyncHandlerPrimitive.SyncHandlerBoolean());
        handlers.put(Byte.class, new SyncHandlerPrimitive.SyncHandlerByte());
        handlers.put(Short.class, new SyncHandlerPrimitive.SyncHandlerShort());
        handlers.put(Integer.class, new SyncHandlerPrimitive.SyncHandlerInteger());
        handlers.put(Long.class, new SyncHandlerPrimitive.SyncHandlerLong());
        handlers.put(Float.class, new SyncHandlerPrimitive.SyncHandlerFloat());
        handlers.put(Double.class, new SyncHandlerPrimitive.SyncHandlerDouble());
        handlers.put(byte[].class, new SyncHandlerPrimitive.SyncHandlerByteArray());
        handlers.put(int[].class, new SyncHandlerPrimitive.SyncHandlerIntArray());
        handlers.put(String.class, new SyncHandlerGeneral.SyncHandlerString());
        handlers.put(NBTTagCompound.class, new SyncHandlerGeneral.SyncHandlerNBTTagCompound());
        handlers.put(ItemStack.class, new SyncHandlerGeneral.SyncHandlerItemStack());
        handlers.put(UUID.class, new SyncHandlerGeneral.SyncHandlerUUID());
        value_factories.add((clazz, watcher, key) -> {
            if (UUID.class.isAssignableFrom(clazz)) {
                return new SyncValue(clazz, watcher, key){

                    @Override
                    public boolean canLoadFrom(NBTTagCompound tag) {
                        return tag.func_186855_b(this.getTagName());
                    }
                };
            }
            return null;
        });
    }
}

