/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.service;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import journeymap.client.properties.WebMapProperties;
import journeymap.client.service.BaseService;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.config.BooleanField;
import se.rupy.http.Event;
import se.rupy.http.Query;

public class PropertyService
extends BaseService {
    public static final String CALLBACK_PARAM = "callback";
    WebMapProperties webMapProperties;
    HashMap<String, BooleanField> propMap = new HashMap();

    @Override
    public String path() {
        return "/properties";
    }

    private void init() {
        if (this.propMap.isEmpty()) {
            this.webMapProperties = Journeymap.getClient().getWebMapProperties();
            this.propMap.put("showCaves", this.webMapProperties.showCaves);
            this.propMap.put("showGrid", this.webMapProperties.showGrid);
            this.propMap.put("showWaypoints", this.webMapProperties.showWaypoints);
        }
    }

    @Override
    public void filter(Event event) throws Event, Exception {
        try {
            this.init();
            Query query = event.query();
            query.parse();
            String path = query.path();
            if (query.method() == 2) {
                this.post(event);
                return;
            }
            if (query.method() != 1) {
                throw new Exception("HTTP method not allowed");
            }
            StringBuffer jsonData = new StringBuffer();
            boolean useJsonP = query.containsKey(CALLBACK_PARAM);
            if (useJsonP) {
                jsonData.append(URLEncoder.encode(query.get(CALLBACK_PARAM).toString(), UTF8.name()));
                jsonData.append("(");
            } else {
                jsonData.append("data=");
            }
            HashMap<String, Boolean> valMap = new HashMap<String, Boolean>();
            for (Map.Entry<String, BooleanField> entry : this.propMap.entrySet()) {
                valMap.put(entry.getKey(), entry.getValue().get());
            }
            jsonData.append(GSON.toJson(valMap));
            if (useJsonP) {
                jsonData.append(")");
                BaseService.ResponseHeader.on(event).noCache().contentType(BaseService.ContentType.jsonp);
            }
            this.gzipResponse(event, jsonData.toString());
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            this.throwEventException(500, "Error trying " + this.path, event, true);
        }
    }

    public void post(Event event) throws Event, Exception {
        try {
            Query query = event.query();
            String[] param = query.parameters().split("=");
            if (param.length != 2) {
                throw new Exception("Expected single key-value pair");
            }
            String key = param[0];
            String value = param[1];
            if (this.propMap.containsKey(key)) {
                Boolean boolValue = Boolean.parseBoolean(value);
                this.propMap.get(key).set(boolValue);
                this.webMapProperties.save();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            this.throwEventException(500, "Error trying " + this.path, event, true);
        }
    }
}

