/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.book.pages.bodies;

import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.astronomy.gui.book.Page_WithScroll;
import asmodeuscore.core.utils.BookUtils;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.lwjgl.opengl.GL11;

public class Page_Systems
extends Page_WithScroll {
    private static ResourceLocation bookPageTexture = new ResourceLocation("galaxyspace", "textures/gui/tablet.png");
    private static ResourceLocation starTexture = new ResourceLocation("galaxyspace", "textures/gui/book/star_bg.png");
    private Mode current_mode = Mode.LIST;
    private static List<CelestialBody> planets = new LinkedList<CelestialBody>();
    private Minecraft mc = Minecraft.func_71410_x();
    private int maxX = 0;
    private CelestialBody selected_body;
    private Moon selected_moon;
    private Map<CelestialBody, ItemStack[]> resources = new HashMap<CelestialBody, ItemStack[]>();
    private SolarSystem system;

    public Page_Systems(SolarSystem system) {
        this.system = system;
        this.setResources((CelestialBody)SolarSystemBodies.planetMercury, new ItemStack(GSBlocks.MERCURY_BLOCKS, 1, 3), new ItemStack(GSBlocks.MERCURY_BLOCKS, 1, 4), new ItemStack(GSBlocks.MERCURY_BLOCKS, 1, 5));
        this.setResources((CelestialBody)VenusModule.planetVenus, new ItemStack(VenusBlocks.venusBlock, 1, 6), new ItemStack(VenusBlocks.venusBlock, 1, 7), new ItemStack(VenusBlocks.venusBlock, 1, 8), new ItemStack(VenusBlocks.venusBlock, 1, 9), new ItemStack(VenusBlocks.venusBlock, 1, 10), new ItemStack(VenusBlocks.venusBlock, 1, 11), new ItemStack(VenusBlocks.venusBlock, 1, 13));
        this.setResources((CelestialBody)GalacticraftCore.planetOverworld, new ItemStack(Blocks.field_150365_q, 1, 0), new ItemStack(Blocks.field_150366_p, 1, 0), new ItemStack(Blocks.field_150352_o, 1, 0), new ItemStack(Blocks.field_150450_ax, 1, 0), new ItemStack(Blocks.field_150369_x, 1, 0), new ItemStack(Blocks.field_150482_ag, 1, 0), new ItemStack(Blocks.field_150412_bA, 1, 0), new ItemStack(GCBlocks.basicBlock, 1, 5), new ItemStack(GCBlocks.basicBlock, 1, 6), new ItemStack(GCBlocks.basicBlock, 1, 7), new ItemStack(GCBlocks.basicBlock, 1, 8), new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 0), new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 1), new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 2));
        this.setResources((CelestialBody)GalacticraftCore.moonMoon, new ItemStack(GCBlocks.blockMoon, 1, 0), new ItemStack(GCBlocks.blockMoon, 1, 1), new ItemStack(GCBlocks.blockMoon, 1, 2), new ItemStack(GCBlocks.blockMoon, 1, 6));
        this.setResources((CelestialBody)MarsModule.planetMars, new ItemStack(MarsBlocks.marsBlock, 1, 0), new ItemStack(MarsBlocks.marsBlock, 1, 1), new ItemStack(MarsBlocks.marsBlock, 1, 2), new ItemStack(MarsBlocks.marsBlock, 1, 3));
        this.setResources((CelestialBody)SolarSystemBodies.planetCeres, new ItemStack(GSBlocks.CERES_BLOCKS, 1, 2), new ItemStack(GSBlocks.CERES_BLOCKS, 1, 3));
        this.setResources((CelestialBody)AsteroidsModule.planetAsteroids, new ItemStack(AsteroidBlocks.blockBasic, 1, 3), new ItemStack(AsteroidBlocks.blockBasic, 1, 4), new ItemStack(AsteroidBlocks.blockBasic, 1, 5));
        this.setResources((CelestialBody)SolarSystemBodies.ioJupiter, new ItemStack(GSBlocks.IO_BLOCKS, 1, 3), new ItemStack(GSBlocks.IO_BLOCKS, 1, 4), new ItemStack(GSBlocks.IO_BLOCKS, 1, 5));
        this.setResources((CelestialBody)SolarSystemBodies.europaJupiter, new ItemStack(GSBlocks.EUROPA_BLOCKS, 1, 2), new ItemStack(GSBlocks.EUROPA_BLOCKS, 1, 3), new ItemStack(GSBlocks.EUROPA_BLOCKS, 1, 4), new ItemStack(GSBlocks.EUROPA_BLOCKS, 1, 5));
        this.setResources((CelestialBody)SolarSystemBodies.ganymedeJupiter, new ItemStack(GSBlocks.GANYMEDE_BLOCKS, 1, 2), new ItemStack(GSBlocks.GANYMEDE_BLOCKS, 1, 3));
        this.setResources((CelestialBody)SolarSystemBodies.enceladusSaturn, new ItemStack(GSBlocks.ENCELADUS_BLOCKS, 1, 2), new ItemStack(GSBlocks.ENCELADUS_CRYSTAL, 1, 0));
        this.setResources((CelestialBody)SolarSystemBodies.titanSaturn, new ItemStack(GSItems.EM_CANISTER, 1, 1));
        this.setResources((CelestialBody)SolarSystemBodies.mirandaUranus, new ItemStack(GSBlocks.MIRANDA_BLOCKS, 1, 3), new ItemStack(GSBlocks.MIRANDA_BLOCKS, 1, 4));
        this.setResources((CelestialBody)SolarSystemBodies.planetKuiperBelt, new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 0), new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 1), new ItemStack(GSBlocks.OVERWORLD_ORES, 1, 2), new ItemStack(Blocks.field_150365_q, 1, 0));
    }

    public String titlePage() {
        return this.system.getUnlocalizedName();
    }

    public ResourceLocation iconTitle() {
        return this.system.getMainStar().getBodyIcon();
    }

    public void drawPage(int x, int y, FontRenderer font, int mouseX, int mouseY) {
        block30: {
            block31: {
                block29: {
                    super.drawPage(x, y, font, mouseX, mouseY);
                    if (this.current_mode != Mode.LIST) break block29;
                    planets.clear();
                    for (Object planet : GalaxyRegistry.getPlanetsForSolarSystem((SolarSystem)this.system)) {
                        planets.add((CelestialBody)planet);
                    }
                    int posY = 0;
                    for (CelestialBody s : planets) {
                        int currX = font.func_78256_a(s.getLocalizedName());
                        this.maxX = this.maxX < currX ? currX : this.maxX;
                    }
                    int offsetX = 21;
                    for (int i = this.getScroll(); i < planets.size(); ++i) {
                        if (i >= 8 + this.getScroll()) continue;
                        int yOffset = i - this.getScroll();
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        posY = 0;
                        if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * yOffset && mouseY <= y + 41 + offsetX * yOffset + 16) {
                            posY = 17;
                        }
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 20, y + 41 + offsetX * yOffset, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                        this.mc.func_110434_K().func_110577_a(planets.get(i).getBodyIcon());
                        this.drawTexturedModalRect(x + 25, y + 45 + offsetX * yOffset, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 40, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * yOffset, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * yOffset, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        font.func_78276_b(planets.get(i).getLocalizedName(), x + 52, y + 46 + offsetX * yOffset, 0xFFFFFF);
                    }
                    this.mc.func_110434_K().func_110577_a(starTexture);
                    this.drawTexturedModalRect(x + 80 + this.maxX, y + 45, 60.0f, 60.0f, 0.0f, 0.0f, 256.0f, 256.0f, false, false, 256.0f, 256.0f);
                    this.mc.func_110434_K().func_110577_a(this.system.getMainStar().getBodyIcon());
                    this.drawTexturedModalRect(x + 80 + this.maxX + 30 - 6, y + 45 + 30 - 6, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                    font.func_78276_b(GCCoreUtil.translate((String)this.system.getMainStar().getUnlocalizedName()), x + 150 + this.maxX, y + 45, 0xFFFFFF);
                    break block30;
                }
                if (this.current_mode != Mode.BODY) break block31;
                int offsetX = 0;
                int posY = 17;
                int i = 1;
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 20, y + 41 + offsetX, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                this.mc.func_110434_K().func_110577_a(this.selected_body.getBodyIcon());
                this.drawTexturedModalRect(x + 25, y + 45 + offsetX, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 40, y + 41 + offsetX, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                font.func_78276_b(this.selected_body.getLocalizedName(), x + 52, y + 46 + offsetX, 0xFFFFFF);
                if (this.selected_body instanceof Planet) {
                    offsetX = 21;
                    for (Moon moon : GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body))) {
                        posY = 0;
                        if (mouseX >= x + 44 && mouseX < x + 40 + 25 + this.maxX && mouseY >= y + 41 + offsetX * i && mouseY <= y + 41 + offsetX * i + 16) {
                            posY = 17;
                        }
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 20, y + 41 + offsetX * i, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                        this.mc.func_110434_K().func_110577_a(moon.getBodyIcon());
                        this.drawTexturedModalRect(x + 25, y + 45 + offsetX * i, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                        this.mc.func_110434_K().func_110577_a(bookPageTexture);
                        this.drawTexturedModalRect(x + 40, y + 41 + offsetX * i, 25.0f, 16.0f, 400.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + 16, y + 41 + offsetX * i, this.maxX, 16.0f, 410.0f, posY, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                        this.drawTexturedModalRect(x + 40 + this.maxX, y + 41 + offsetX * i, 25.0f, 16.0f, 467.0f, posY, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                        font.func_78279_b(moon.getLocalizedName(), x + 52, y + 46 + offsetX * i, 260, 0xFFFFFF);
                        ++i;
                    }
                }
                if (this.selected_body == null) break block30;
                font.func_78279_b(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_body.getName().toLowerCase())), x + 80 + this.maxX, y + 46, 260, 0xFFFFFF);
                int offsetY = font.func_78256_a(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_body.getName().toLowerCase()))) / 260 * font.field_78288_b;
                WorldProvider dim = WorldUtil.getProviderForDimensionClient((int)this.selected_body.getDimensionID());
                if (dim instanceof IGalacticraftWorldProvider) {
                    IGalacticraftWorldProvider gcdim = (IGalacticraftWorldProvider)dim;
                    String[] stringArray = new String[]{"Distance from star: " + this.selected_body.getRelativeDistanceFromCenter().unScaledDistance, "Gravity: " + gcdim.getGravity(), "Thermal Level: " + gcdim.getThermalLevelModifier(), "Wind Level: " + gcdim.getWindLevel(), "Breathable Atmoshpere: " + gcdim.hasBreathableAtmosphere()};
                    BodiesHelper.BodiesData data = (BodiesHelper.BodiesData)BodiesHelper.data.get(this.selected_body);
                    if (data != null) {
                        // empty if block
                    }
                    for (int k = 0; k < stringArray.length; ++k) {
                        font.func_78276_b(stringArray[k], x + 80 + this.maxX, y + 70 + k * font.field_78288_b + offsetY, 0xFFFFFF);
                    }
                }
                if (!this.selected_body.getReachable()) {
                    return;
                }
                font.func_78276_b("Resources:", x + 80 + this.maxX, y + 126 + offsetY, 0xFFFFFF);
                if (this.resources.containsKey(this.selected_body)) {
                    int k = 0;
                    for (ItemStack stacks : this.resources.get(this.selected_body)) {
                        RenderHelper.func_74520_c();
                        if (k >= 14) {
                            this.mc.func_175599_af().func_180450_b(stacks, x + 80 + this.maxX + (k - 14) * 20, y + 140 + 18 + offsetY);
                            if (mouseX >= x + 80 + this.maxX + (k - 14) * 20 && mouseX <= x + 80 + this.maxX + (k - 14) * 20 + 16 && mouseY >= y + 100 + 18 + offsetY && mouseY <= y + 100 + 18 + 16 + offsetY) {
                                this.drawToolTip(mouseX, y + 135 + 18 + offsetY, stacks.func_82833_r());
                            }
                        } else {
                            this.mc.func_175599_af().func_180450_b(stacks, x + 80 + this.maxX + k * 20, y + 140 + offsetY);
                            if (mouseX >= x + 80 + this.maxX + k * 20 && mouseX <= x + 80 + this.maxX + k * 20 + 16 && mouseY >= y + 140 + offsetY && mouseY <= y + 140 + 16 + offsetY) {
                                this.drawToolTip(mouseX, y + 135 + offsetY, stacks.func_82833_r());
                            }
                        }
                        RenderHelper.func_74518_a();
                        ++k;
                    }
                }
                break block30;
                break block30;
            }
            if (this.current_mode == Mode.MOON) {
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 20, y + 41, 21.0f, 21.0f, 461.0f, 35.0f, 18.0f, 21.0f, false, false, 512.0f, 256.0f);
                this.mc.func_110434_K().func_110577_a(this.selected_moon.getBodyIcon());
                this.drawTexturedModalRect(x + 25, y + 45, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f, false, false, 16.0f, 16.0f);
                this.mc.func_110434_K().func_110577_a(bookPageTexture);
                this.drawTexturedModalRect(x + 40, y + 41, 25.0f, 16.0f, 400.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + 16, y + 41, this.maxX, 16.0f, 410.0f, 17.0f, 70.0f, 15.0f, false, false, 512.0f, 256.0f);
                this.drawTexturedModalRect(x + 40 + this.maxX, y + 41, 25.0f, 16.0f, 467.0f, 17.0f, 20.0f, 15.0f, false, false, 512.0f, 256.0f);
                font.func_78276_b(this.selected_moon.getLocalizedName(), x + 52, y + 46, 0xFFFFFF);
                if (this.selected_moon != null) {
                    font.func_78276_b(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_moon.getName().toLowerCase())), x + 80 + this.maxX, y + 46, 0xFFFFFF);
                    int offsetY = font.func_78256_a(GCCoreUtil.translate((String)("book.page.solarsystem." + this.selected_moon.getName().toLowerCase()))) / 260 * font.field_78288_b;
                    WorldProvider dim = WorldUtil.getProviderForDimensionClient((int)this.selected_moon.getDimensionID());
                    if (dim instanceof IGalacticraftWorldProvider) {
                        IGalacticraftWorldProvider gcdim = (IGalacticraftWorldProvider)dim;
                        String[] infos = new String[]{"Gravity: " + gcdim.getGravity(), "Thermal Level: " + gcdim.getThermalLevelModifier(), "Wind Level: " + gcdim.getWindLevel(), "Breathable Atmoshpere: " + gcdim.hasBreathableAtmosphere()};
                        BodiesHelper.BodiesData data = (BodiesHelper.BodiesData)BodiesHelper.data.get(this.selected_moon);
                        if (data != null) {
                            // empty if block
                        }
                        for (int k = 0; k < infos.length; ++k) {
                            font.func_78276_b(infos[k], x + 80 + this.maxX, y + 70 + k * font.field_78288_b + offsetY, 0xFFFFFF);
                        }
                    }
                    if (!this.selected_moon.getReachable()) {
                        return;
                    }
                    font.func_78276_b("Resources:", x + 80 + this.maxX, y + 126 + offsetY, 0xFFFFFF);
                    if (this.resources.containsKey(this.selected_moon)) {
                        int k = 0;
                        for (ItemStack itemStack : this.resources.get(this.selected_moon)) {
                            RenderHelper.func_74520_c();
                            if (k >= 14) {
                                this.mc.func_175599_af().func_180450_b(itemStack, x + 80 + this.maxX + (k - 14) * 20, y + 140 + 18 + offsetY);
                                if (mouseX >= x + 80 + this.maxX + (k - 14) * 20 && mouseX <= x + 80 + this.maxX + (k - 14) * 20 + 16 && mouseY >= y + 140 + 18 + offsetY && mouseY <= y + 140 + 18 + 16 + offsetY) {
                                    this.drawToolTip(mouseX, y + 135 + 18 + offsetY, itemStack.func_82833_r());
                                }
                            } else {
                                this.mc.func_175599_af().func_180450_b(itemStack, x + 80 + this.maxX + k * 20, y + 140);
                                if (mouseX >= x + 80 + this.maxX + k * 20 && mouseX <= x + 80 + this.maxX + k * 20 + 16 && mouseY >= y + 140 + offsetY && mouseY <= y + 140 + 16 + offsetY) {
                                    this.drawToolTip(mouseX, y + 135 + offsetY, itemStack.func_82833_r());
                                }
                            }
                            RenderHelper.func_74518_a();
                            ++k;
                        }
                    }
                }
            }
        }
    }

    public void mouseClick(int mouseX, int mouseY, int mouseButton, int x, int y) {
        block3: {
            int offsetX;
            block2: {
                super.mouseClick(mouseX, mouseY, mouseButton, x, y);
                offsetX = 21;
                if (this.current_mode != Mode.LIST) break block2;
                for (int i = this.getScroll(); i < planets.size(); ++i) {
                    if (i >= 8 + this.getScroll()) continue;
                    int yOffset = i - this.getScroll();
                    if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * yOffset || mouseY > y + 41 + offsetX * yOffset + 16) continue;
                    this.selected_body = planets.get(i);
                    this.current_mode = Mode.BODY;
                }
                break block3;
            }
            if (this.current_mode != Mode.BODY) break block3;
            for (int i = 1; i < GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).size() + 1; ++i) {
                if (mouseX < x + 44 || mouseX >= x + 40 + 25 + this.maxX || mouseY < y + 41 + offsetX * i || mouseY > y + 41 + offsetX * i + 16) continue;
                this.selected_moon = (Moon)GalaxyRegistry.getMoonsForPlanet((Planet)((Planet)this.selected_body)).get(i - 1);
                this.current_mode = Mode.MOON;
            }
        }
    }

    public boolean hookBackButton() {
        if (this.current_mode == Mode.BODY) {
            this.current_mode = Mode.LIST;
            return true;
        }
        if (this.current_mode == Mode.MOON) {
            this.current_mode = Mode.BODY;
            return true;
        }
        return false;
    }

    public String getCategory() {
        return BookUtils.Book_Cateroies.BODIES.getName();
    }

    public int getMaxScroll() {
        if (this.current_mode == Mode.LIST && planets.size() > 8) {
            return planets.size() % 8;
        }
        return 0;
    }

    protected void setResources(CelestialBody body, ItemStack ... stack) {
        this.resources.put(body, stack);
    }

    private void drawToolTip(int mousePosX, int mousePosY, String tooltip) {
        this.drawToolTip(mousePosX, mousePosY, tooltip, this.mc.field_71466_p.func_78256_a(tooltip), 8);
    }

    private void drawToolTip(int mousePosX, int mousePosY, String tooltip, int width, int height) {
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)300.0f);
        int k = width;
        int j2 = mousePosX - k / 2;
        int k2 = mousePosY - 12;
        int i1 = height;
        int j1 = ColorUtil.to32BitColor((int)190, (int)0, (int)153, (int)255);
        this.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
        this.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
        this.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
        this.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
        this.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
        int k1 = ColorUtil.to32BitColor((int)170, (int)0, (int)153, (int)255);
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        this.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
        this.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
        this.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
        this.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
        this.mc.field_71466_p.func_78279_b(tooltip, j2, k2, 150, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
        GL11.glPopMatrix();
    }

    protected void drawGradientRect(int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        float zLevel = 0.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    static enum Mode {
        LIST,
        BODY,
        MOON;

    }
}

