/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTMethods;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.RecipeHelper;

public class RemoveProcessorRecipe
implements IAction {
    public static boolean hasErrored = false;
    public List<IItemIngredient> itemIngredients;
    public List<IFluidIngredient> fluidIngredients;
    public IngredientSorption type;
    public ProcessorRecipe recipe;
    public boolean wasNull;
    public boolean wrongSize;
    public final NCRecipes.Type recipeType;

    public RemoveProcessorRecipe(NCRecipes.Type recipeType, IngredientSorption type, List<IIngredient> ctIngredients) {
        Object ingredient;
        int i;
        int fluidSize;
        this.recipeType = recipeType;
        this.type = type;
        int itemSize = type == IngredientSorption.INPUT ? recipeType.getRecipeHandler().itemInputSize : recipeType.getRecipeHandler().itemOutputSize;
        int n = fluidSize = type == IngredientSorption.INPUT ? recipeType.getRecipeHandler().fluidInputSize : recipeType.getRecipeHandler().fluidOutputSize;
        if (ctIngredients.size() != itemSize + fluidSize) {
            CraftTweakerAPI.logError((String)("A " + recipeType.getRecipeName() + " recipe was the wrong size"));
            this.wrongSize = true;
            return;
        }
        ArrayList<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
        ArrayList<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
        for (i = 0; i < itemSize; ++i) {
            ingredient = CTMethods.buildRemovalItemIngredient(ctIngredients.get(i), recipeType);
            if (ingredient == null) {
                this.wasNull = true;
                return;
            }
            itemIngredients.add((IItemIngredient)ingredient);
        }
        for (i = itemSize; i < fluidSize; ++i) {
            ingredient = CTMethods.buildRemovalFluidIngredient(ctIngredients.get(i), recipeType);
            if (ingredient == null) {
                this.wasNull = true;
                return;
            }
            fluidIngredients.add((IFluidIngredient)ingredient);
        }
        this.itemIngredients = itemIngredients;
        this.fluidIngredients = fluidIngredients;
        ProcessorRecipe processorRecipe = this.recipe = type == IngredientSorption.INPUT ? (ProcessorRecipe)recipeType.getRecipeHandler().getRecipeFromIngredients(itemIngredients, fluidIngredients) : (ProcessorRecipe)recipeType.getRecipeHandler().getRecipeFromProducts(itemIngredients, fluidIngredients);
        if (this.recipe == null) {
            this.wasNull = true;
        }
    }

    public void apply() {
        boolean removed;
        if (!this.wasNull && !this.wrongSize && (removed = this.recipeType.getRecipeHandler().removeRecipe(this.recipe))) {
            while (removed) {
                this.recipe = this.type == IngredientSorption.INPUT ? (ProcessorRecipe)this.recipeType.getRecipeHandler().getRecipeFromIngredients(this.itemIngredients, this.fluidIngredients) : (ProcessorRecipe)this.recipeType.getRecipeHandler().getRecipeFromProducts(this.itemIngredients, this.fluidIngredients);
                removed = this.recipeType.getRecipeHandler().removeRecipe(this.recipe);
            }
            return;
        }
        RemoveProcessorRecipe.callError();
    }

    public String describe() {
        if (this.wasNull || this.wrongSize) {
            return String.format("Error: Failed to remove %s recipe with %s as the " + (this.type == IngredientSorption.INPUT ? "input" : "output"), this.recipeType.getRecipeName(), RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients));
        }
        if (this.type == IngredientSorption.INPUT) {
            return String.format("Removing %s recipe: %s", this.recipeType.getRecipeName(), RecipeHelper.getRecipeString(this.recipe));
        }
        return String.format("Removing %s recipes for: %s", this.recipeType.getRecipeName(), RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients));
    }

    public static void callError() {
        if (!hasErrored) {
            CraftTweakerAPI.logError((String)"At least one NuclearCraft CraftTweaker recipe removal method has errored - check the CraftTweaker log for more details");
        }
        hasErrored = true;
    }
}

