/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.integration.jei.IJEIHandler;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.RecipeHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class JEIRecipeWrapperAbstract<T extends JEIRecipeWrapperAbstract>
implements IRecipeWrapper {
    public final ProcessorRecipeHandler recipeHandler;
    public final ProcessorRecipe recipe;
    public final List<List<ItemStack>> itemInputs;
    public final List<List<FluidStack>> fluidInputs;
    public List<List<ItemStack>> itemOutputs;
    public List<List<FluidStack>> fluidOutputs;
    public final IDrawableAnimated arrow;
    public final int arrowDrawPosX;
    public final int arrowDrawPosY;

    public JEIRecipeWrapperAbstract(IGuiHelper guiHelper, IJEIHandler handler, ProcessorRecipeHandler recipeHandler, ProcessorRecipe recipe, int backX, int backY, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        this(guiHelper, handler, recipeHandler, recipe, "", backX, backY, arrowX, arrowY, arrowWidth, arrowHeight, arrowPosX, arrowPosY);
    }

    public JEIRecipeWrapperAbstract(IGuiHelper guiHelper, IJEIHandler handler, ProcessorRecipeHandler recipeHandler, ProcessorRecipe recipe, String guiExtra, int backX, int backY, int arrowX, int arrowY, int arrowWidth, int arrowHeight, int arrowPosX, int arrowPosY) {
        this.recipeHandler = recipeHandler;
        this.recipe = recipe;
        this.itemInputs = RecipeHelper.getItemInputLists(recipe.itemIngredients());
        this.fluidInputs = RecipeHelper.getFluidInputLists(recipe.fluidIngredients());
        this.itemOutputs = RecipeHelper.getItemOutputLists(recipe.itemProducts());
        this.fluidOutputs = RecipeHelper.getFluidOutputLists(recipe.fluidProducts());
        ResourceLocation location = new ResourceLocation("nuclearcraft:textures/gui/container/" + handler.getTextureName() + guiExtra + ".png");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(location, arrowX, arrowY, arrowWidth, arrowHeight);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, Math.max(1, (int)(this.getProcessTime() / 5.0)), IDrawableAnimated.StartDirection.LEFT, false);
        this.arrowDrawPosX = arrowPosX - backX;
        this.arrowDrawPosY = arrowPosY - backY;
    }

    protected abstract double getProcessTime();

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.itemInputs);
        ingredients.setInputLists(FluidStack.class, this.fluidInputs);
        ingredients.setOutputLists(ItemStack.class, this.itemOutputs);
        ingredients.setOutputLists(FluidStack.class, this.fluidOutputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.arrow.draw(minecraft, this.arrowDrawPosX, this.arrowDrawPosY);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

