/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import nc.config.NCConfig;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.container.ContainerTurbineController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.network.TurbineUpdatePacket;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.multiblock.validation.IMultiblockValidator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Turbine
extends CuboidalMultiblockBase<TurbineUpdatePacket> {
    protected Set<TileTurbineController> controllers = new HashSet<TileTurbineController>();
    protected TileTurbineController controller;
    public int redstoneSignal = 0;
    protected int updateCount = 0;
    public boolean isTurbineOn;

    public Turbine(World world) {
        super(world);
    }

    public Set<TileTurbineController> getControllers() {
        return this.controllers;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.turbine_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.turbine_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileTurbineController) {
            this.controllers.add((TileTurbineController)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileTurbineController) {
            this.controllers.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileTurbineController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileTurbineController contr;
            this.controller = contr = iterator.next();
        }
        this.calculateTurbineStats();
    }

    @Override
    protected void onMachineRestored() {
        this.calculateTurbineStats();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isTurbineOn = false;
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        this.setIsTurbineOn();
        if (this.shouldUpdate()) {
            this.calculateTurbineStats();
        }
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    protected void setIsTurbineOn() {
        boolean oldIsTurbineOn = this.isTurbineOn;
        boolean bl = this.isTurbineOn = this.controller.isRedstonePowered() && this.isAssembled();
        if (this.isTurbineOn != oldIsTurbineOn) {
            this.sendUpdateToAllPlayers();
        }
    }

    protected void calculateTurbineStats() {
    }

    private void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= this.updateTime();
    }

    private int updateTime() {
        return NCConfig.machine_update_rate / 4;
    }

    private boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
    }

    public void onPacket(boolean isTurbineOn) {
        this.isTurbineOn = isTurbineOn;
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerTurbineController(player, this.controller);
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }

    @Override
    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 0;
    }

    @Override
    protected int getMaximumXSize() {
        return 0;
    }

    @Override
    protected int getMaximumZSize() {
        return 0;
    }

    @Override
    protected int getMaximumYSize() {
        return 0;
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
    }

    @Override
    protected TurbineUpdatePacket getUpdatePacket() {
        return new TurbineUpdatePacket(this.controller.func_174877_v(), this.isTurbineOn);
    }
}

