/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import nc.config.NCConfig;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;

public class HeatExchangerRecipes
extends ProcessorRecipeHandler {
    private static final String[] COOLANTS = new String[]{"", "redstone_", "quartz_", "gold_", "glowstone_", "lapis_", "diamond_", "liquidhelium_", "ender_", "cryotheum_", "iron_", "emerald_", "copper_", "tin_", "magnesium_"};

    public HeatExchangerRecipes() {
        super("heat_exchanger", 0, 1, 0, 1);
    }

    @Override
    public void addRecipes() {
        for (int i = 0; i < COOLANTS.length; ++i) {
            this.addHeatExchange(this.fluidStack(COOLANTS[i] + "nak_hot", NCConfig.salt_fission_cooling_max_rate), this.fluidStack(COOLANTS[i] + "nak", NCConfig.salt_fission_cooling_max_rate), NCConfig.salt_fission_cooling_rate[i] * NCConfig.heat_exchanger_coolant_mult);
        }
        this.addHeatExchange(this.fluidStack("water", 200), this.fluidStack("high_pressure_steam", 1000), 32000.0);
        this.addHeatExchange(this.fluidStack("preheated_water", 200), this.fluidStack("high_pressure_steam", 1000), 16000.0);
        this.addHeatExchange(this.fluidStack("exhaust_steam", 1000), this.fluidStack("low_pressure_steam", 1000), 16000.0);
        this.addRecipe(this.fluidStack("high_pressure_steam", 250), this.fluidStack("steam", 1000), 4000.0, 1200, 800);
        this.addHeatExchange(this.fluidStack("condensate_water", 1000), this.fluidStack("preheated_water", 1000), 32000.0);
    }

    public void addHeatExchange(IFluidIngredient fluidIn, IFluidIngredient fluidOut, double heatRequired) {
        this.addRecipe(fluidIn, fluidOut, heatRequired, fluidIn.getStack().getFluid().getTemperature(), fluidOut.getStack().getFluid().getTemperature());
    }
}

