/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.radiation;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.config.NCConfig;
import nc.radiation.environment.RadiationEnvironmentHandler;
import nc.radiation.environment.RadiationEnvironmentInfo;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.passive.TilePassiveAbstract;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.MaterialHelper;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileRadiationScrubber
extends TilePassiveAbstract
implements ITileRadiationEnvironment,
SimpleComponent {
    private static final int RADIUS = 5;
    private static final double OCCLUSION_PENALTY_FRACTION = NCConfig.radiation_scrubber_fraction / 52.0;
    public static final double MAX_SCRUBBER_RATE_FRACTION = NCConfig.radiation_scrubber_fraction;
    private double scrubberRateFraction = 0.0;
    public double rawScrubberRate = 0.0;
    private double currentChunkBuffer = 0.0;
    public final Map<BlockPos, Integer> occlusionMap = new ConcurrentHashMap<BlockPos, Integer>();
    private int radCheckCount = 0;

    public TileRadiationScrubber() {
        super("radiation_scrubber", new OreIngredient("dustBorax", 1), -NCConfig.radiation_scrubber_borax_rate, -NCConfig.radiation_scrubber_power, NCConfig.machine_update_rate / 5);
        this.stackChange = new OreIngredient("dustBorax", MathHelper.func_76130_a((int)this.itemChange) * NCConfig.machine_update_rate / 5);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            for (int x = -5; x <= 5; ++x) {
                for (int y = -5; y <= 5; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        RadiationEnvironmentHandler.addTile(this.field_174879_c.func_177982_a(x, y, z), this);
                    }
                }
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.tickTile();
            this.tickRadCount();
            if (this.shouldRadCheck()) {
                this.checkSurroundings();
            }
        }
    }

    public void checkSurroundings() {
        this.checkRadiationEnvironmentInfo();
        this.rawScrubberRate = !this.isActive ? 0.0 : -this.currentChunkBuffer * this.scrubberRateFraction;
    }

    public void tickRadCount() {
        ++this.radCheckCount;
        this.radCheckCount %= NCConfig.machine_update_rate * 20;
    }

    public boolean shouldRadCheck() {
        return this.radCheckCount == 0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        RadiationEnvironmentHandler.removeTile(this);
    }

    @Override
    public void checkRadiationEnvironmentInfo() {
        double newScrubberRateFraction = MAX_SCRUBBER_RATE_FRACTION;
        Iterator<Map.Entry<BlockPos, Integer>> occlusionIterator = this.occlusionMap.entrySet().iterator();
        int occlusionCount = 0;
        double tileCount = 0.0;
        while (occlusionIterator.hasNext()) {
            Map.Entry<BlockPos, Integer> occlusion = occlusionIterator.next();
            if (TileRadiationScrubber.isOcclusive(this.field_174879_c, this.field_145850_b, occlusion.getKey())) {
                newScrubberRateFraction -= OCCLUSION_PENALTY_FRACTION / this.field_174879_c.func_177951_i((Vec3i)occlusion.getKey());
                ++occlusionCount;
                tileCount += Math.max(1.0, Math.sqrt(occlusion.getValue().intValue()));
                continue;
            }
            occlusionIterator.remove();
        }
        this.scrubberRateFraction = occlusionCount == 0 ? MAX_SCRUBBER_RATE_FRACTION : Math.max(0.0, newScrubberRateFraction * (double)occlusionCount / tileCount);
    }

    @Override
    public void handleRadiationEnvironmentInfo(RadiationEnvironmentInfo info) {
        BlockPos blockPos = info.pos;
        if (!this.field_174879_c.equals((Object)blockPos) && TileRadiationScrubber.isOcclusive(this.field_174879_c, this.field_145850_b, blockPos)) {
            this.occlusionMap.put(blockPos, Math.max(1, info.tileMap.size()));
        }
    }

    @Override
    public double getChunkBufferContributionFraction() {
        return this.isActive ? -this.scrubberRateFraction : 0.0;
    }

    @Override
    public double getCurrentChunkBuffer() {
        return this.currentChunkBuffer;
    }

    @Override
    public void setCurrentChunkBuffer(double buffer) {
        this.currentChunkBuffer = buffer;
    }

    private static boolean isOcclusive(BlockPos pos, World world, BlockPos otherPos) {
        return pos.func_177951_i((Vec3i)otherPos) < (double)NCMath.square(5) && !MaterialHelper.isEmpty(world.func_180495_p(otherPos).func_185904_a());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TileRadiationScrubber)) {
            return false;
        }
        return this.field_174879_c.equals((Object)((TileRadiationScrubber)obj).field_174879_c);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("scrubberRate", this.scrubberRateFraction);
        nbt.func_74780_a("rawScrubberRate", this.rawScrubberRate);
        nbt.func_74780_a("currentChunkBuffer", this.currentChunkBuffer);
        int count = 0;
        for (Map.Entry<BlockPos, Integer> occlusion : this.occlusionMap.entrySet()) {
            BlockPos pos = occlusion.getKey();
            nbt.func_74783_a("occlusion" + count, new int[]{occlusion.getValue(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            ++count;
        }
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.scrubberRateFraction = nbt.func_74769_h("scrubberRate");
        this.rawScrubberRate = nbt.func_74769_h("rawScrubberRate");
        this.currentChunkBuffer = nbt.func_74769_h("currentChunkBuffer");
        for (String key : nbt.func_150296_c()) {
            int[] data;
            if (!key.startsWith("occlusion") || (data = nbt.func_74759_k(key)).length < 4) continue;
            this.occlusionMap.put(new BlockPos(data[1], data[2], data[3]), data[0]);
        }
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_radiation_scrubber";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getRadiationRemovalRate(Context context, Arguments args) {
        return new Object[]{this.rawScrubberRate};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getEfficiency(Context context, Arguments args) {
        return new Object[]{Math.abs(100.0 * this.getChunkBufferContributionFraction() / MAX_SCRUBBER_RATE_FRACTION)};
    }
}

