/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import nc.capability.radiation.IDefaultRadiationResistance;
import nc.capability.radiation.IEntityRads;
import nc.capability.radiation.IRadiation;
import nc.capability.radiation.IRadiationSource;
import nc.config.NCConfig;
import nc.radiation.RadBiomes;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.ArmorHelper;
import nc.util.NCMath;
import nc.util.PotionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class RadiationHelper {
    public static void addToChunkBuffer(IRadiationSource chunkRadiation, double addedRadiation) {
        chunkRadiation.setRadiationBuffer(chunkRadiation.getRadiationBuffer() + addedRadiation);
    }

    public static void addToChunkRadiation(IRadiationSource chunkRadiation, double addedRadiation) {
        chunkRadiation.setRadiationLevel(chunkRadiation.getRadiationLevel() + addedRadiation);
    }

    public static void addToChunkBuffer(Chunk chunk, double addedRadiation) {
        if (chunk == null || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource chunkRadiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (chunkRadiation == null) {
            return;
        }
        RadiationHelper.addToChunkBuffer(chunkRadiation, addedRadiation);
    }

    public static void addToChunkRadiation(Chunk chunk, double addedRadiation) {
        if (chunk == null || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource chunkRadiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (chunkRadiation == null) {
            return;
        }
        RadiationHelper.addToChunkRadiation(chunkRadiation, addedRadiation);
    }

    public static void addFractionToChunkBuffer(Chunk chunk, ITileRadiationEnvironment tile) {
        if (chunk == null || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource chunkRadiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (chunkRadiation == null) {
            return;
        }
        RadiationHelper.addToChunkBuffer(chunkRadiation, tile.getChunkBufferContributionFraction() * tile.getCurrentChunkBuffer());
    }

    public static void transferRadiationFromStackToChunkBuffer(ItemStack stack, Chunk chunk) {
        if (chunk == null || !stack.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null) || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource stackRadiation = (IRadiationSource)stack.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (stackRadiation == null) {
            return;
        }
        IRadiationSource chunkRadiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (chunkRadiation == null) {
            return;
        }
        RadiationHelper.addToChunkBuffer(chunkRadiation, stackRadiation.getRadiationLevel() * (double)stack.func_190916_E());
    }

    public static void transferRadiationFromSourceToChunkBuffer(ICapabilityProvider provider, Chunk chunk) {
        if (chunk == null || !provider.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null) || !chunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource sourceRadiation = (IRadiationSource)provider.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (sourceRadiation == null) {
            return;
        }
        IRadiationSource chunkRadiation = (IRadiationSource)chunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (chunkRadiation == null) {
            return;
        }
        RadiationHelper.addToChunkBuffer(chunkRadiation, sourceRadiation.getRadiationLevel());
    }

    public static void transferRadsFromInventoryToChunkBuffer(InventoryPlayer inventory, Chunk chunk) {
        if (!NCConfig.radiation_hardcore_stacks) {
            return;
        }
        for (ItemStack stack : inventory.field_70462_a) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromSourceToChunkBuffer((ICapabilityProvider)stack, chunk);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromSourceToChunkBuffer((ICapabilityProvider)stack, chunk);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            if (stack.func_190926_b()) continue;
            RadiationHelper.transferRadiationFromSourceToChunkBuffer((ICapabilityProvider)stack, chunk);
        }
    }

    public static void spreadRadiationFromChunk(Chunk sourceChunk, Chunk targetChunk) {
        IRadiationSource targetChunkRadiation;
        if (sourceChunk == null || !sourceChunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource sourceChunkRadiation = (IRadiationSource)sourceChunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (sourceChunkRadiation == null) {
            return;
        }
        if (targetChunk != null && targetChunk.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null) && (targetChunkRadiation = (IRadiationSource)targetChunk.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) != null && !sourceChunkRadiation.isRadiationNegligible() && (targetChunkRadiation.getRadiationLevel() == 0.0 || sourceChunkRadiation.getRadiationLevel() / targetChunkRadiation.getRadiationLevel() > 1.5)) {
            double radiationSpread = (sourceChunkRadiation.getRadiationLevel() - targetChunkRadiation.getRadiationLevel()) * NCConfig.radiation_spread_rate;
            sourceChunkRadiation.setRadiationLevel(sourceChunkRadiation.getRadiationLevel() - radiationSpread);
            targetChunkRadiation.setRadiationLevel(targetChunkRadiation.getRadiationLevel() + radiationSpread);
        }
        if (sourceChunkRadiation.isRadiationNegligible()) {
            sourceChunkRadiation.setRadiationLevel(0.0);
        }
    }

    public static double addRadsToPlayer(EntityPlayer player, IEntityRads playerRads, double rawRadiation, int updateRate) {
        double resistance = playerRads.getRadiationResistance() + RadiationHelper.getPlayerArmorRadResistance(player);
        double addedRadiation = rawRadiation <= 0.0 ? 0.0 : NCMath.square(rawRadiation) / (rawRadiation + resistance);
        playerRads.setTotalRads(playerRads.getTotalRads() + addedRadiation * (double)updateRate, true);
        return addedRadiation;
    }

    public static double getPlayerArmorRadResistance(EntityPlayer player) {
        double resistance = 0.0;
        return resistance += RadiationHelper.getArmorInventoryRadResistance((Entity)player);
    }

    private static double getArmorInventoryRadResistance(Entity entity) {
        if (entity == null) {
            return 0.0;
        }
        double resistance = 0.0;
        for (ItemStack armor : entity.func_184193_aE()) {
            IDefaultRadiationResistance armorResistance;
            if (armor.hasCapability(IDefaultRadiationResistance.CAPABILITY_DEFAULT_RADIATION_RESISTANCE, null) && (armorResistance = (IDefaultRadiationResistance)armor.getCapability(IDefaultRadiationResistance.CAPABILITY_DEFAULT_RADIATION_RESISTANCE, null)) != null) {
                resistance += armorResistance.getRadiationResistance();
            }
            if (!armor.func_77942_o() || !armor.func_77978_p().func_74764_b("ncRadiationResistance")) continue;
            resistance += armor.func_77978_p().func_74769_h("ncRadiationResistance");
        }
        return resistance;
    }

    public static double addRadsToEntity(EntityLiving entityLiving, IEntityRads entityRads, double rawRadiation, int updateRate) {
        double resistance = entityRads.getRadiationResistance() + RadiationHelper.getEntityArmorRadResistance(entityLiving);
        double addedRadiation = rawRadiation <= 0.0 ? 0.0 : NCMath.square(rawRadiation) / (rawRadiation + resistance);
        entityRads.setTotalRads(entityRads.getTotalRads() + addedRadiation * (double)updateRate, true);
        return addedRadiation;
    }

    public static double getEntityArmorRadResistance(EntityLiving entityLiving) {
        double resistance = 0.0;
        resistance += RadiationHelper.getArmorInventoryRadResistance((Entity)entityLiving);
        if (entityLiving instanceof EntityHorse) {
            resistance += RadiationHelper.getHorseArmorRadResistance((EntityHorse)entityLiving);
        }
        return resistance;
    }

    private static double getHorseArmorRadResistance(EntityHorse horse) {
        if (horse == null) {
            return 0.0;
        }
        double resistance = 0.0;
        NBTTagCompound compound = new NBTTagCompound();
        horse.func_70014_b(compound);
        ItemStack armor = new ItemStack(compound.func_74775_l("ArmorItem"));
        if (armor != null && ArmorHelper.isHorseArmor(armor.func_77973_b())) {
            IDefaultRadiationResistance armorResistance;
            if (armor.hasCapability(IDefaultRadiationResistance.CAPABILITY_DEFAULT_RADIATION_RESISTANCE, null) && (armorResistance = (IDefaultRadiationResistance)armor.getCapability(IDefaultRadiationResistance.CAPABILITY_DEFAULT_RADIATION_RESISTANCE, null)) != null) {
                resistance += armorResistance.getRadiationResistance();
            }
            if (armor.func_77942_o() && armor.func_77978_p().func_74764_b("ncRadiationResistance")) {
                resistance += armor.func_77978_p().func_74769_h("ncRadiationResistance");
            }
        }
        return resistance;
    }

    public static double transferRadsFromInventoryToPlayer(EntityPlayer player, IEntityRads playerRads, Chunk chunk, int updateRate) {
        double radiationLevel = 0.0;
        InventoryPlayer inventory = player.field_71071_by;
        for (ItemStack stack : inventory.field_70462_a) {
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, player, playerRads, updateRate);
        }
        for (ItemStack stack : inventory.field_70460_b) {
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, player, playerRads, updateRate);
        }
        for (ItemStack stack : inventory.field_184439_c) {
            radiationLevel += RadiationHelper.transferRadsFromStackToPlayer(stack, player, playerRads, updateRate);
        }
        return radiationLevel;
    }

    private static double transferRadsFromStackToPlayer(ItemStack stack, EntityPlayer player, IEntityRads playerRads, int updateRate) {
        if (stack.func_190926_b() || !stack.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return 0.0;
        }
        IRadiationSource stackRadiation = (IRadiationSource)stack.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (stackRadiation == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, stackRadiation.getRadiationLevel() * (double)stack.func_190916_E(), updateRate);
    }

    public static double transferRadsToPlayer(ICapabilityProvider provider, EntityPlayer player, IEntityRads playerRads, int updateRate) {
        if (provider == null || !provider.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return 0.0;
        }
        IRadiationSource sourceRadiation = (IRadiationSource)provider.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (sourceRadiation == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, sourceRadiation.getRadiationLevel(), updateRate);
    }

    public static double transferBackgroundRadsToPlayer(Biome biome, EntityPlayer player, IEntityRads playerRads, int updateRate) {
        Double biomeRadiation = RadBiomes.BIOME_MAP.get(biome);
        if (biomeRadiation == null) {
            return 0.0;
        }
        return RadiationHelper.addRadsToPlayer(player, playerRads, biomeRadiation, updateRate);
    }

    public static void transferRadsFromSourceToEntity(ICapabilityProvider provider, EntityLiving entityLiving, IEntityRads entityRads, int updateRate) {
        if (provider == null || !provider.hasCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null)) {
            return;
        }
        IRadiationSource sourceRadiation = (IRadiationSource)provider.getCapability(IRadiationSource.CAPABILITY_RADIATION_SOURCE, null);
        if (sourceRadiation == null) {
            return;
        }
        entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity(entityLiving, entityRads, sourceRadiation.getRadiationLevel(), updateRate));
    }

    public static void transferBackgroundRadsToEntity(Biome biome, EntityLiving entityLiving, IEntityRads entityRads, int updateRate) {
        Double biomeRadiation = RadBiomes.BIOME_MAP.get(biome);
        if (biomeRadiation != null) {
            entityRads.setRadiationLevel(RadiationHelper.addRadsToEntity(entityLiving, entityRads, biomeRadiation, updateRate));
        }
    }

    public static void applySymptoms(EntityLivingBase entity, IEntityRads entityRads, int updateRate) {
        int radPercentage = entityRads.getRadsPercentage();
        if (radPercentage < 40) {
            return;
        }
        if (radPercentage < 55) {
            entity.func_70690_d(PotionHelper.newEffect(18, 1, updateRate + 1));
        } else if (radPercentage < 70) {
            entity.func_70690_d(PotionHelper.newEffect(18, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(4, 1, updateRate + 1));
        } else if (radPercentage < 80) {
            entity.func_70690_d(PotionHelper.newEffect(18, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(4, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(17, 1, updateRate + 1));
        } else if (radPercentage < 90) {
            entity.func_70690_d(PotionHelper.newEffect(18, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(4, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(17, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(19, 1, updateRate + 1));
        } else {
            entity.func_70690_d(PotionHelper.newEffect(18, 3, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(4, 3, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(17, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(19, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(20, 1, updateRate + 1));
        }
    }

    public static void applyMobBuffs(EntityLiving entity, IEntityRads entityRads, int updateRate) {
        int radPercentage = entityRads.getRadsPercentage();
        if (radPercentage < 40) {
            return;
        }
        if (radPercentage < 55) {
            entity.func_70690_d(PotionHelper.newEffect(1, 1, updateRate + 1));
        } else if (radPercentage < 70) {
            entity.func_70690_d(PotionHelper.newEffect(1, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(8, 1, updateRate + 1));
        } else if (radPercentage < 80) {
            entity.func_70690_d(PotionHelper.newEffect(1, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(8, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(11, 1, updateRate + 1));
        } else if (radPercentage < 90) {
            entity.func_70690_d(PotionHelper.newEffect(1, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(8, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(11, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(22, 1, updateRate + 1));
        } else {
            entity.func_70690_d(PotionHelper.newEffect(1, 3, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(8, 3, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(11, 2, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(22, 1, updateRate + 1));
            entity.func_70690_d(PotionHelper.newEffect(10, 1, updateRate + 1));
        }
    }

    public static TextFormatting getRadsTextColor(IEntityRads playerRads) {
        int radsPercent = playerRads.getRadsPercentage();
        return radsPercent < 30 ? TextFormatting.WHITE : (radsPercent < 55 ? TextFormatting.YELLOW : (radsPercent < 80 ? TextFormatting.RED : TextFormatting.DARK_RED));
    }

    public static TextFormatting getRadiationTextColor(double radiation) {
        if (radiation < 1.0E-9) {
            return TextFormatting.WHITE;
        }
        return radiation < 0.01 ? TextFormatting.YELLOW : (radiation < 1.0 ? TextFormatting.RED : TextFormatting.DARK_RED);
    }

    public static TextFormatting getRadiationTextColor(IRadiation irradiated) {
        return RadiationHelper.getRadiationTextColor(irradiated.getRadiationLevel());
    }
}

