/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import cubex2.cs4.plugins.vanilla.IMCBase;
import cubex2.cs4.plugins.vanilla.IMCFunction;
import cubex2.cs4.plugins.vanilla.IMCItemStack;
import cubex2.cs4.plugins.vanilla.IMCNBT;
import cubex2.cs4.plugins.vanilla.IMCResourceLocation;
import cubex2.cs4.plugins.vanilla.IMCString;
import java.lang.reflect.Type;

class IMCDeserializer
implements JsonDeserializer<IMCBase> {
    IMCDeserializer() {
    }

    public IMCBase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String type = object.get("type").getAsString();
        Class<? extends IMCBase> imcClass = IMCDeserializer.getImplClass(type);
        return (IMCBase)context.deserialize(json, imcClass);
    }

    private static Class<? extends IMCBase> getImplClass(String type) throws JsonParseException {
        switch (type) {
            case "string": {
                return IMCString.class;
            }
            case "nbt": {
                return IMCNBT.class;
            }
            case "resource": {
                return IMCResourceLocation.class;
            }
            case "itemstack": {
                return IMCItemStack.class;
            }
            case "function": {
                return IMCFunction.class;
            }
        }
        throw new JsonParseException("Invalid imc type: " + type);
    }
}

