/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla.block;

import cubex2.cs4.plugins.vanilla.ContentBlockCarpet;
import cubex2.cs4.plugins.vanilla.block.BlockMixin;
import cubex2.cs4.plugins.vanilla.block.CSBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCarpet
extends Block
implements CSBlock<ContentBlockCarpet> {
    protected static final AxisAlignedBB CARPET_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    private final ContentBlockCarpet content;

    public BlockCarpet(Material material, ContentBlockCarpet content) {
        super(material, MapColor.field_151660_b);
        this.content = content;
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB bounds = this.getContent().bounds.get(this.getSubtype(state)).orElse(BlockMixin.DEFAULT_AABB_MARKER);
        return bounds == BlockMixin.DEFAULT_AABB_MARKER ? CARPET_AABB : bounds;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? true : super.func_176225_a(state, blockAccess, pos, side);
    }

    public BlockFaceShape func_193383_a(IBlockAccess blockAccess, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    public int getSubtype(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public ContentBlockCarpet getContent() {
        return this.content;
    }

    @Override
    public int[] getSubtypes() {
        return this.content.subtypes;
    }
}

