/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.fluid;

import java.util.Random;
import minechem.api.ICustomRenderer;
import minechem.block.tile.TileRadioactiveFluid;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMinechem;
import minechem.fluid.FluidMolecule;
import minechem.fluid.reaction.ChemicalFluidReactionHandler;
import minechem.handler.HandlerExplosiveFluid;
import minechem.init.ModConfig;
import minechem.init.ModMaterial;
import minechem.item.MatterState;
import minechem.item.MinechemChemicalType;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidMinechem
extends BlockFluidClassic
implements ITileEntityProvider,
ICustomRenderer {
    private final boolean isRadioactivity;
    public static final Material materialFluidBlock = Material.field_151586_h;
    private final boolean solid;

    public BlockFluidMinechem(FluidMinechem fluid, Material material) {
        super((Fluid)fluid, material);
        this.setQuantaPerBlock(fluid.getQuanta());
        this.isRadioactivity = fluid instanceof FluidElement ? ((FluidElement)fluid).element.radioactivity() != RadiationEnum.stable : (fluid instanceof FluidMolecule ? ((FluidMolecule)fluid).molecule.radioactivity() != RadiationEnum.stable : false);
        this.solid = fluid.getChemical().roomState() == MatterState.SOLID;
        this.stack = new FluidStack((Fluid)fluid, 1000);
        this.func_149663_c(this.getFluid().getName());
        this.setRegistryName(this.getFluid().getName());
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
        fluid.setBlock((Block)this);
        if (!FluidRegistry.getBucketFluids().contains((Object)fluid)) {
            FluidRegistry.addBucketForFluid((Fluid)fluid);
        }
    }

    public String func_149739_a() {
        String fluidUnlocalizedName = this.getFluid().getUnlocalizedName();
        return fluidUnlocalizedName.substring(0, fluidUnlocalizedName.length() - 5);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkStatus(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void checkStatus(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        if (ModConfig.reactionFluidMeetFluid) {
            for (EnumFacing face : EnumFacing.values()) {
                if (!this.checkToReact(world, x + face.func_82601_c(), y + face.func_96559_d(), z + face.func_82599_e(), x, y, z)) continue;
                return;
            }
        }
        this.checkToExplode(world, x, y, z);
    }

    private boolean checkToReact(World world, int dx, int dy, int dz, int sx, int sy, int sz) {
        return ChemicalFluidReactionHandler.checkToReact((Block)this, world.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c(), world, dx, dy, dz, sx, sy, sz);
    }

    private void checkToExplode(World world, int x, int y, int z) {
        MinechemChemicalType type = MinechemUtil.getChemical((Block)this);
        float level = HandlerExplosiveFluid.getInstance().getExplosiveFluid(type);
        if (Float.isNaN(level)) {
            return;
        }
        boolean flag = false;
        for (EnumFacing face : EnumFacing.values()) {
            if (!HandlerExplosiveFluid.getInstance().existingFireSource(world.func_180495_p(new BlockPos(x + face.func_82601_c(), y + face.func_96559_d(), z + face.func_82599_e())).func_177230_c())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return;
        }
        world.func_175655_b(new BlockPos(x, y, z), true);
        world.func_175698_g(new BlockPos(x, y, z));
        world.func_72876_a(null, (double)x, (double)y, (double)z, HandlerExplosiveFluid.getInstance().getExplosiveFluid(type), true);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.isRadioactivity && state.func_177230_c().func_176201_c(state) == 0;
    }

    public TileEntity func_149915_a(World world, int i) {
        return this.hasTileEntity(this.func_176203_a(i)) ? new TileRadioactiveFluid() : null;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int eventID, int eventParameter) {
        super.func_189539_a(state, world, pos, eventID, eventParameter);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(eventID, eventParameter) : false;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        MinechemChemicalType type = MinechemUtil.getChemical((Block)this);
        world.func_175655_b(pos, true);
        world.func_175698_g(pos);
        world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), HandlerExplosiveFluid.getInstance().getExplosiveFluid(type), true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.solid) {
            super.func_180650_b(world, pos, state, rand);
        }
        this.checkStatus(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.checkStatus(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Material material;
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (this.field_149764_J == ModMaterial.FLUID) {
            int i = (Integer)stateIn.func_177229_b((IProperty)LEVEL);
            if (i > 0 && i < 8) {
                if (rand.nextInt(64) == 0) {
                    worldIn.func_184134_a(d0 + 0.5, d1 + 0.5, d2 + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
                }
            } else if (rand.nextInt(10) == 0) {
                worldIn.func_175688_a(EnumParticleTypes.SUSPENDED, d0 + (double)rand.nextFloat(), d1 + (double)rand.nextFloat(), d2 + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !(material = worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 1.05;
            double d7 = d2 + (double)rand.nextFloat();
            if (this.field_149764_J == ModMaterial.FLUID) {
                worldIn.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 1.0, 0.0, new int[0]);
            } else {
                worldIn.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        Item item = Item.func_150898_a((Block)this);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        final ModelResourceLocation modelResourceLocation = new ModelResourceLocation("minechem:fluid", this.getFluid().getName());
        ModelLoader.setCustomMeshDefinition((Item)item, stack -> modelResourceLocation);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState p_178132_1_) {
                return modelResourceLocation;
            }
        });
    }
}

