/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.multiblock;

import javax.annotation.Nullable;
import minechem.api.ICustomRenderer;
import minechem.block.multiblock.tile.TileGhostBlock;
import minechem.tileentity.multiblock.ghostblock.GhostBlockItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockGhost
extends BlockContainer
implements ICustomRenderer {
    public BlockGhost() {
        super(Material.field_151573_f);
        this.setRegistryName("ghost_block");
        this.func_149663_c("ghost_block");
        this.func_149715_a(0.5f);
        this.func_149711_c(1000.0f);
        this.func_149752_b(1000.0f);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register(new GhostBlockItem((Block)this).setRegistryName(this.getRegistryName()));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileGhostBlock) {
            TileGhostBlock ghostTile = (TileGhostBlock)te;
            return ghostTile.getBlockAsItemStack();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileGhostBlock ghostBlock;
        ItemStack blockAsStack;
        super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGhostBlock && this.playerIsHoldingItem(player, blockAsStack = (ghostBlock = (TileGhostBlock)tileEntity).getBlockAsItemStack())) {
            world.func_180501_a(pos, ghostBlock.getRenderedBlockState(), 3);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            return true;
        }
        return true;
    }

    private boolean playerIsHoldingItem(EntityPlayer entityPlayer, ItemStack itemstack) {
        ItemStack helditem = entityPlayer.field_71071_by.func_70448_g();
        return !helditem.func_190926_b() && !itemstack.func_190926_b() && helditem.func_77973_b() == itemstack.func_77973_b() && helditem.func_77952_i() == itemstack.func_77952_i();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176209_a(IBlockState state, boolean bool) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess access, BlockPos pos, EnumFacing facing) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World var1, int i) {
        return new TileGhostBlock();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack itemStack) {
        if (entity instanceof EntityPlayer) {
            // empty if block
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        for (int i = 0; i < 2; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        stack = this.getItemBlockWithNBT(te);
        BlockGhost.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    private ItemStack getItemBlockWithNBT(@Nullable TileEntity te) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (te != null) {
            te.func_189515_b(nbttagcompound);
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return stack;
    }
}

