/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.multiblock.tile;

import javax.annotation.Nullable;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.init.ModConfig;
import minechem.init.ModItems;
import minechem.init.ModNetworking;
import minechem.item.ItemElement;
import minechem.item.blueprint.BlueprintFusion;
import minechem.item.element.ElementEnum;
import minechem.network.message.FusionUpdateMessage;
import minechem.utils.MinechemUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileFusionCore
extends TileReactorCore
implements ISidedInventory {
    public static boolean canProcess = false;
    public static int fusedResult = 0;
    public static int inputLeft = 0;
    public static int inputRight = 1;
    public static int output = 2;
    int timer;

    public TileFusionCore() {
        this(null);
    }

    public TileFusionCore(EnumFacing structureFacing) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.setBlueprint(new BlueprintFusion());
        this.setStructureFacing(structureFacing);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.structureFormed) {
            return;
        }
        ++this.timer;
        if (!this.field_145850_b.field_72995_K && this.structureFormed) {
            if (!canProcess && this.getEnergyRequired() <= this.getEnergyStored() && this.inputsCanBeFused() && this.canOutput()) {
                canProcess = true;
            }
            if (canProcess && this.useEnergy(this.getEnergyRequired())) {
                this.fuseInputs();
                this.removeInputs();
                canProcess = false;
            } else {
                fusedResult = 0;
            }
        }
        if (this.timer >= 20) {
            this.timer = 0;
            FusionUpdateMessage message = new FusionUpdateMessage(this, this.structureFormed);
            ModNetworking.INSTANCE.sendToDimension((IMessage)message, this.func_145831_w().field_73011_w.getDimension());
            this.func_70296_d();
            IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (iblockstate != null) {
                this.func_145831_w().func_184138_a(this.func_174877_v(), iblockstate, iblockstate, 3);
            }
        }
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return false;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return false;
    }

    private void fuseInputs() {
        if (((ItemStack)this.inventory.get(output)).func_190926_b()) {
            this.inventory.set(output, (Object)new ItemStack((Item)ModItems.element, 1, fusedResult));
        } else if (((ItemStack)this.inventory.get(output)).func_77952_i() == fusedResult) {
            ((ItemStack)this.inventory.get(output)).func_190917_f(1);
        } else {
            canProcess = false;
        }
    }

    public int[] func_180463_a(EnumFacing facing) {
        switch (facing.func_176745_a() / 2) {
            case 0: {
                return new int[]{output};
            }
            case 1: {
                return new int[]{inputLeft};
            }
            case 2: {
                return new int[]{inputRight};
            }
        }
        return new int[0];
    }

    @Override
    public String func_70005_c_() {
        return "container.minechemFusion";
    }

    @Override
    public int func_70302_i_() {
        return 4;
    }

    @Override
    @Nullable
    public ItemStack func_70304_b(int i) {
        return ItemStack.field_190927_a;
    }

    public boolean inputsCanBeFused() {
        if (!((ItemStack)this.inventory.get(inputLeft)).func_190926_b() && !((ItemStack)this.inventory.get(inputRight)).func_190926_b() && ((ItemStack)this.inventory.get(inputLeft)).func_77973_b() instanceof ItemElement && ((ItemStack)this.inventory.get(inputRight)).func_77973_b() instanceof ItemElement) {
            int left = ((ItemStack)this.inventory.get(inputLeft)).func_77952_i();
            int right = ((ItemStack)this.inventory.get(inputRight)).func_77952_i();
            fusedResult = left + right;
            return left > 0 && right > 0 && ElementEnum.getByID(fusedResult) != null;
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return (slot == inputLeft || slot == inputRight) && itemstack.func_77973_b() instanceof ItemElement;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.structureFormed;
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        fusedResult = nbtTagCompound.func_74762_e("fusedResult");
        canProcess = nbtTagCompound.func_74767_n("canProcess");
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        MinechemUtil.readTagListToItemStackList(nbtTagCompound.func_150295_c("inventory", 10));
    }

    private void removeInputs() {
        this.func_70298_a(inputLeft, 1);
        this.func_70298_a(inputRight, 1);
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory.set(slot, (Object)itemstack);
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    public boolean canOutput() {
        if (((ItemStack)this.inventory.get(output)).func_190926_b()) {
            return true;
        }
        if (((ItemStack)this.inventory.get(output)).func_77952_i() == fusedResult) {
            return ((ItemStack)this.inventory.get(output)).func_190916_E() < 64;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("fusedResult", fusedResult);
        nbtTagCompound.func_74757_a("canProcess", canProcess);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackListToTagList((NonNullList<ItemStack>)this.inventory);
        nbtTagCompound.func_74782_a("inventory", (NBTBase)inventoryTagList);
        return nbtTagCompound;
    }

    @Override
    public int getEnergyRequired() {
        if (!((ItemStack)this.inventory.get(inputLeft)).func_190926_b() && !((ItemStack)this.inventory.get(inputRight)).func_190926_b() && this.inputsCanBeFused() && ModConfig.powerUseEnabled) {
            return (((ItemStack)this.inventory.get(inputLeft)).func_77952_i() + ((ItemStack)this.inventory.get(inputRight)).func_77952_i()) * ModConfig.fusionMultiplier;
        }
        return 0;
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

