/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.multiblock.tile;

import java.util.List;
import minechem.api.IMinechemBlueprint;
import minechem.block.multiblock.tile.TileFissionCore;
import minechem.block.multiblock.tile.TileFusionCore;
import minechem.block.tile.TileEntityProxy;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModBlocks;
import minechem.init.ModBlueprints;
import minechem.init.ModConfig;
import minechem.init.ModRegistries;
import minechem.utils.BlueprintUtil;
import minechem.utils.LocalPosition;
import minechem.utils.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.tuple.Pair;

public class TileReactorCore
extends TileMinechemEnergyBase {
    int offsetX;
    int offsetY;
    int offsetZ;
    public IMinechemBlueprint blueprint;
    public IBlockState[][][] structure;
    protected boolean structureFormed;
    protected SafeTimeTracker tracker = new SafeTimeTracker();
    protected EnumFacing structureFacing;

    public TileReactorCore() {
        super(ModConfig.maxFusionStorage);
    }

    public LocalPosition getLocalPos() {
        return new LocalPosition(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), this.structureFacing);
    }

    public void setBlueprint(IMinechemBlueprint blueprint) {
        this.blueprint = blueprint;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetZ = 0;
        if (blueprint != null) {
            this.structure = blueprint.getStructure();
            this.offsetX = this.field_174879_c.func_177958_n() - blueprint.getManagerPosX();
            this.offsetY = this.field_174879_c.func_177956_o() - blueprint.getManagerPosY();
            this.offsetZ = this.field_174879_c.func_177952_p() - blueprint.getManagerPosZ();
        }
    }

    public IMinechemBlueprint getBlueprint() {
        return this.blueprint;
    }

    public void setStructureFacing(EnumFacing structureFacing) {
        this.structureFacing = structureFacing;
    }

    public EnumFacing getStructureFacing() {
        return this.structureFacing;
    }

    private boolean checkComplete() {
        return BlueprintUtil.isStructureComplete(this.getBlueprint(), this.getStructureFacing(), this.func_145831_w(), this.func_174877_v());
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tracker.markTimeIfDelay(this.field_145850_b, 40L)) {
            if (this.structureFormed && !this.checkComplete()) {
                this.unlinkProxies();
                this.structureFormed = false;
            }
            if (!this.structureFormed && this.checkComplete()) {
                this.linkProxies();
                this.structureFormed = true;
            }
            if (!this.structureFormed) {
                this.scanForValidStructure();
            }
            super.func_73660_a();
        }
    }

    private void scanForValidStructure() {
        Pair<IMinechemBlueprint, EnumFacing> bp = BlueprintUtil.getBlueprintFromStructure(this.func_145831_w(), this.func_174877_v());
        if (bp != null) {
            if (bp.getLeft() == ModBlueprints.fusion) {
                TileFusionCore fusion = new TileFusionCore((EnumFacing)bp.getRight());
                fusion.func_145834_a(this.func_145831_w());
                fusion.func_174878_a(this.func_174877_v());
                fusion.setBlockType(ModBlocks.reactor_core);
                this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)fusion);
                fusion.setBlueprint((IMinechemBlueprint)bp.getLeft());
                fusion.setStructureFacing((EnumFacing)bp.getRight());
                fusion.structureFormed = true;
                fusion.linkProxies();
            }
            if (bp.getLeft() == ModBlueprints.fission) {
                TileFissionCore fission = new TileFissionCore((EnumFacing)bp.getRight());
                fission.setBlockType(ModBlocks.reactor_core);
                this.func_145831_w().func_175690_a(this.func_174877_v(), (TileEntity)fission);
                fission.setBlueprint((IMinechemBlueprint)bp.getLeft());
                fission.setStructureFacing((EnumFacing)bp.getRight());
                fission.structureFormed = true;
                fission.linkProxies();
            }
            if (!this.func_145831_w().field_72995_K) {
                this.func_70296_d();
                IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
                if (iblockstate != null) {
                    this.func_145831_w().func_184138_a(this.func_174877_v(), iblockstate, iblockstate, 3);
                }
            }
        }
    }

    public void unlinkProxies() {
        if (this.getBlueprint() != null) {
            for (int y = 0; y < this.blueprint.ySize(); ++y) {
                for (int x = 0; x < this.blueprint.xSize(); ++x) {
                    for (int z = 0; z < this.blueprint.zSize(); ++z) {
                        this.unlinkProxy(x, y, z);
                    }
                }
            }
        }
    }

    private void unlinkProxy(int x, int y, int z) {
        int worldX = this.offsetX + x;
        int worldY = this.offsetY + y;
        int worldZ = this.offsetZ + z;
        BlockPos tilePos = new BlockPos(worldX, worldY, worldZ);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(tilePos);
        if (tileEntity != null && tileEntity instanceof TileEntityProxy && ((TileEntityProxy)tileEntity).getManager() != null) {
            this.field_145850_b.func_175690_a(tilePos, (TileEntity)new TileEntityProxy());
        }
    }

    public void linkProxies() {
        if (this.getBlueprint() != null) {
            for (int y = 0; y < this.blueprint.ySize(); ++y) {
                for (int x = 0; x < this.blueprint.xSize(); ++x) {
                    for (int z = 0; z < this.blueprint.zSize(); ++z) {
                        this.linkProxy(x, y, z);
                    }
                }
            }
        }
    }

    private void linkProxy(int x, int y, int z) {
        int worldX = this.offsetX + x;
        int worldY = this.offsetY + y;
        int worldZ = this.offsetZ + z;
        BlockPos tilePos = new BlockPos(worldX, worldY, worldZ);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(tilePos);
        if (tileEntity != null && tileEntity instanceof TileEntityProxy) {
            ((TileEntityProxy)tileEntity).setManager(this);
            IEnergyStorage energyStorage = (IEnergyStorage)((TileEntityProxy)tileEntity).getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage instanceof TileEntityProxy.EnergySettableMultiBlock) {
                ((TileEntityProxy.EnergySettableMultiBlock)energyStorage).setManager(this);
            }
            ((TileEntityProxy)tileEntity).func_70296_d();
            IBlockState iblockstate = this.func_145831_w().func_180495_p(tilePos);
            if (iblockstate != null) {
                this.func_145831_w().func_184138_a(tilePos, iblockstate, iblockstate, 3);
            }
        }
    }

    private boolean isManager(BlockPos pos) {
        return pos.func_177958_n() == this.blueprint.getManagerPosX() && pos.func_177956_o() == this.blueprint.getManagerPosY() && pos.func_177952_p() == this.blueprint.getManagerPosZ();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("structureFormed", this.structureFormed);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.structureFormed = nbt.func_74767_n("structureFormed");
    }

    private boolean areBlocksCorrect() {
        if (this.getBlueprint() != null) {
            for (int y = 0; y < this.blueprint.ySize(); ++y) {
                for (int x = 0; x < this.blueprint.xSize(); ++x) {
                    for (int z = 0; z < this.blueprint.zSize(); ++z) {
                        MultiBlockStatusEnum multiBlockStatusEnum = this.checkBlock(x, y, z);
                        if (multiBlockStatusEnum != MultiBlockStatusEnum.INCORRECT) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        List bpList = ModRegistries.MINECHEM_BLUEPRINTS.getValues();
        for (IMinechemBlueprint bp : bpList) {
            for (int y = 0; y < bp.ySize(); ++y) {
                for (int x = 0; x < bp.xSize(); ++x) {
                    for (int z = 0; z < bp.zSize(); ++z) {
                        MultiBlockStatusEnum multiBlockStatusEnum = this.checkBlock(x, y, z);
                        if (multiBlockStatusEnum != MultiBlockStatusEnum.INCORRECT) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private MultiBlockStatusEnum checkBlock(int x, int y, int z) {
        if (this.getBlueprint() != null) {
            if (x == this.blueprint.getManagerPosX() && y == this.blueprint.getManagerPosY() && z == this.blueprint.getManagerPosZ()) {
                return MultiBlockStatusEnum.CORRECT;
            }
            LocalPosition.Pos3 worldPos = this.getLocalPos().getLocalPos(x, y, z);
            int worldX = this.func_174877_v().func_177958_n() + (this.offsetX + x);
            int worldY = this.func_174877_v().func_177956_o() + (this.offsetY + y);
            int worldZ = this.func_174877_v().func_177952_p() + (this.offsetZ + z);
            IBlockState structureState = this.structure[y][x][z];
            Block structureBlock = structureState.func_177230_c();
            int structureBlockMetadata = structureBlock.func_176201_c(structureState);
            IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(worldX, worldY, worldZ));
            Block block = state.func_177230_c();
            int blockMetadata = block.func_176201_c(state);
            if (block == Blocks.field_150350_a && structureState.func_177230_c() != Blocks.field_150350_a) {
                return MultiBlockStatusEnum.INCORRECT;
            }
            if (structureBlock == block && structureBlockMetadata == blockMetadata) {
                return MultiBlockStatusEnum.CORRECT;
            }
        }
        return MultiBlockStatusEnum.INCORRECT;
    }

    @Override
    public int func_70302_i_() {
        return 0;
    }

    @Override
    public boolean func_191420_l() {
        return false;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    @Override
    public int func_174887_a_(int id) {
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    @Override
    public String func_70005_c_() {
        return "";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int getEnergyRequired() {
        return 0;
    }

    public static enum MultiBlockStatusEnum {
        CORRECT,
        INCORRECT;

    }
}

