/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.tile;

import minechem.api.IMinechemBlueprint;
import minechem.block.multiblock.tile.TileFissionCore;
import minechem.block.multiblock.tile.TileFusionCore;
import minechem.block.multiblock.tile.TileGhostBlock;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModBlocks;
import minechem.init.ModBlueprints;
import minechem.init.ModItems;
import minechem.init.ModRegistries;
import minechem.init.ModSounds;
import minechem.utils.BlueprintUtil;
import minechem.utils.LocalPosition;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class TileBlueprintProjector
extends TileMinechemEnergyBase {
    IMinechemBlueprint blueprint;
    IMinechemBlueprint lastBlueprint;
    IBlockState[][][] structure;
    int timer = 0;
    boolean needToBuild = true;

    public TileBlueprintProjector() {
        super(100000);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        ++this.timer;
        if (this.timer <= 20) {
            return;
        }
        this.timer = 0;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.blueprint != null) {
            if (this.isComplete()) {
                if (this.getEnergyStored() >= this.getEnergyRequired()) {
                    this.projectBlueprint();
                    this.playSound();
                }
            } else if (this.getEnergyStored() >= this.getEnergyRequired()) {
                this.projectBlueprint();
                this.playSound();
                this.useEnergy(this.getEnergyRequired());
            }
        }
        if (this.timer % 5 == 0) {
            this.destroyProjection();
            this.func_70296_d();
            IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (iblockstate != null) {
                this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
        }
    }

    private boolean isComplete() {
        return BlueprintUtil.isStructureComplete(this.getBlueprint(), this.getFacing(), this.func_145831_w(), this.func_174877_v());
    }

    private void playSound() {
        if (this.blueprint != null) {
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), ModSounds.BLUEPRINT_PROJECTOR, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    private EnumFacing getFacing() {
        int facing = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176201_c(this.field_145850_b.func_180495_p(this.field_174879_c));
        return EnumFacing.values()[facing].func_176734_d();
    }

    private void projectBlueprint() {
        if (this.field_145850_b == null) {
            return;
        }
        EnumFacing direction = this.getFacing();
        LocalPosition position = new LocalPosition(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), direction);
        LocalPosition worldPos = new LocalPosition(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ(), direction);
        position.moveForwards(this.blueprint.zSize() + 1);
        position.moveLeft(Math.floor(this.blueprint.xSize() / 2));
        LocalPosition.Pos3 mgrPos = position.getLocalPos(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ());
        int totalIncorrectCount = 0;
        if (!this.isComplete()) {
            if (!this.needToBuild) {
                this.needToBuild = true;
            }
            boolean shouldProjectGhostBlocks = true;
            totalIncorrectCount = this.blueprint.getTotalSize();
            for (int x = 0; x < this.blueprint.xSize(); ++x) {
                int verticalIncorrectCount = this.blueprint.ySize() * this.blueprint.zSize();
                for (int y = 0; y < this.blueprint.ySize(); ++y) {
                    for (int z = 0; z < this.blueprint.zSize(); ++z) {
                        if (shouldProjectGhostBlocks) {
                            TileReactorCore.MultiBlockStatusEnum multiBlockStatusEnum = this.projectGhostBlock(x, y, z, position);
                            if (multiBlockStatusEnum != TileReactorCore.MultiBlockStatusEnum.CORRECT) continue;
                            --verticalIncorrectCount;
                            --totalIncorrectCount;
                            continue;
                        }
                        this.destroyGhostBlock(x, y, z, position);
                    }
                }
                if (verticalIncorrectCount == 0) continue;
                shouldProjectGhostBlocks = false;
            }
            if (this.func_145831_w().func_175625_s(new BlockPos(mgrPos.x, mgrPos.y, mgrPos.z)) instanceof TileReactorCore) {
                ((TileReactorCore)this.func_145831_w().func_175625_s(new BlockPos(mgrPos.x, mgrPos.y, mgrPos.z))).unlinkProxies();
            }
        }
        if (!(totalIncorrectCount != 0 || this.isComplete() && this.func_145831_w().func_175625_s(new BlockPos(mgrPos.x, mgrPos.y, mgrPos.z)) instanceof TileReactorCore)) {
            this.buildStructure(position);
        }
    }

    private void buildStructure(LocalPosition position) {
        if (this.needToBuild) {
            IBlockState[][][] resultStructure = this.blueprint.getStructure();
            TileEntity managerTileEntity = this.buildManagerBlock(position);
            if (managerTileEntity != null && managerTileEntity instanceof TileReactorCore) {
                for (int x = 0; x < this.blueprint.xSize(); ++x) {
                    for (int y = 0; y < this.blueprint.ySize(); ++y) {
                        for (int z = 0; z < this.blueprint.zSize(); ++z) {
                            if (this.isManagerBlock(x, y, z)) continue;
                            IBlockState iBlockState = resultStructure[y][x][z];
                        }
                    }
                }
                ((TileReactorCore)managerTileEntity).linkProxies();
            }
            this.needToBuild = false;
        }
    }

    private void setBlock(BlockPos posIn, LocalPosition position, IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        LocalPosition.Pos3 worldPos = position.getLocalPos(posIn);
        this.func_145831_w().func_180501_a(new BlockPos(worldPos.x, worldPos.y, worldPos.z), state, 3);
    }

    private boolean isManagerBlock(int x, int y, int z) {
        return x == this.blueprint.getManagerPosX() && y == this.blueprint.getManagerPosY() && z == this.blueprint.getManagerPosZ();
    }

    private TileEntity getManager() {
        if (this.getBlueprint() != null) {
            EnumFacing direction = this.getFacing();
            LocalPosition position = new LocalPosition(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), direction);
            position.moveForwards(this.blueprint.zSize() + 1);
            position.moveLeft(Math.floor(this.blueprint.xSize() / 2));
            LocalPosition.Pos3 worldPos = position.getLocalPos(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ());
            return this.func_145831_w().func_175625_s(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
        }
        return null;
    }

    private TileEntity buildManagerBlock(LocalPosition position) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(this.blueprint.getManagerPosX(), this.blueprint.getManagerPosY(), this.blueprint.getManagerPosZ());
        if (this.func_145831_w().func_180495_p(new BlockPos(worldPos.x, worldPos.y, worldPos.z)) == ModBlocks.reactor_core) {
            if (this.func_145831_w().func_175625_s(new BlockPos(worldPos.x, worldPos.y, worldPos.z)) != null) {
                this.func_145831_w().func_175713_t(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
            }
            if (this.blueprint == ModBlueprints.fusion) {
                TileFusionCore fusion = new TileFusionCore(position.orientation);
                fusion.func_145834_a(this.func_145831_w());
                fusion.func_174878_a(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
                ObfuscationReflectionHelper.setPrivateValue(TileEntity.class, (Object)((Object)fusion), (Object)ModBlocks.reactor_core, (String[])new String[]{"blockType", "field_145854_h"});
                this.func_145831_w().func_175700_a((TileEntity)fusion);
            }
            if (this.blueprint == ModBlueprints.fission) {
                TileFissionCore fission = new TileFissionCore(position.orientation);
                fission.func_145834_a(this.func_145831_w());
                fission.func_174878_a(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
                ObfuscationReflectionHelper.setPrivateValue(TileEntity.class, (Object)((Object)fission), (Object)ModBlocks.reactor_core, (String[])new String[]{"blockType", "field_145854_h"});
                this.func_145831_w().func_175700_a((TileEntity)fission);
            }
        }
        return this.func_145831_w().func_175625_s(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
    }

    private TileReactorCore.MultiBlockStatusEnum projectGhostBlock(int x, int y, int z, LocalPosition position) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(x, y, z);
        IBlockState structureState = this.structure[y][x][z];
        IBlockState state = this.func_145831_w().func_180495_p(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
        Block block = state.func_177230_c();
        Block structureBlock = structureState.func_177230_c();
        int blockMetadata = block.func_176201_c(state);
        int structureBlockMetadata = structureBlock.func_176201_c(structureState);
        if (block == Blocks.field_150350_a && structureState.func_177230_c() != Blocks.field_150350_a) {
            this.createGhostBlock(worldPos.x, worldPos.y, worldPos.z, structureState);
            return TileReactorCore.MultiBlockStatusEnum.INCORRECT;
        }
        if (structureBlock == block && structureBlockMetadata == blockMetadata) {
            return TileReactorCore.MultiBlockStatusEnum.CORRECT;
        }
        return TileReactorCore.MultiBlockStatusEnum.INCORRECT;
    }

    private void createGhostBlock(int x, int y, int z, IBlockState state) {
        this.func_145831_w().func_180501_a(new BlockPos(x, y, z), ModBlocks.ghostBlock.func_176203_a(0), 3);
        TileEntity tileEntity = this.func_145831_w().func_175625_s(new BlockPos(x, y, z));
        if (tileEntity instanceof TileGhostBlock) {
            TileGhostBlock ghostBlock = (TileGhostBlock)tileEntity;
            ghostBlock.setRenderedBlockState(state);
        }
    }

    public void destroyProjection() {
        this.destroyProjection(true);
    }

    public void destroyProjection(boolean override) {
        if (this.getEnergyStored() >= this.getEnergyRequired() && this.blueprint != null && !override) {
            return;
        }
        if (this.blueprint == null && this.lastBlueprint != null) {
            this.structure = this.lastBlueprint.getStructure();
            LocalPosition position = new LocalPosition(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.getFacing());
            position.moveForwards(this.lastBlueprint.xSize() + 1);
            position.moveLeft(Math.floor(this.lastBlueprint.xSize() / 2));
            for (int x = 0; x < this.lastBlueprint.xSize(); ++x) {
                for (int y = 0; y < this.lastBlueprint.ySize(); ++y) {
                    for (int z = 0; z < this.lastBlueprint.zSize(); ++z) {
                        this.destroyGhostBlock(x, y, z, position);
                    }
                }
            }
            this.structure = null;
            this.lastBlueprint = null;
        }
    }

    private void destroyGhostBlock(int x, int y, int z, LocalPosition position) {
        LocalPosition.Pos3 worldPos = position.getLocalPos(x, y, z);
        Block block = this.func_145831_w().func_180495_p(new BlockPos(worldPos.x, worldPos.y, worldPos.z)).func_177230_c();
        if (block == ModBlocks.ghostBlock) {
            this.func_145831_w().func_175698_g(new BlockPos(worldPos.x, worldPos.y, worldPos.z));
        }
    }

    public void setBlueprint(IMinechemBlueprint blueprint) {
        this.destroyProjection();
        if (blueprint != null) {
            this.blueprint = blueprint;
            this.lastBlueprint = blueprint;
            this.structure = blueprint.getStructure();
        } else {
            this.blueprint = null;
            this.structure = null;
        }
        this.func_70296_d();
    }

    public IMinechemBlueprint takeBlueprint() {
        IMinechemBlueprint blueprint = this.blueprint;
        this.setBlueprint(null);
        return blueprint;
    }

    public boolean hasBlueprint() {
        return this.blueprint != null;
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack returnStack = super.func_70298_a(slot, amount);
        this.destroyProjection();
        this.setBlueprint(null);
        return returnStack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack itemstack) {
        super.func_70299_a(slot, itemstack);
        if (!itemstack.func_190926_b()) {
            IMinechemBlueprint blueprint = BlueprintUtil.getBlueprint(itemstack);
            this.destroyProjection();
            this.setBlueprint(blueprint);
        }
    }

    @Override
    public String func_70005_c_() {
        return "container.blueprintprojector";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        ItemStack blueprintStack = this.func_70301_a(0);
        if (!blueprintStack.func_190926_b()) {
            nbtTagCompound.func_74782_a("blueprint", (NBTBase)blueprintStack.func_77955_b(new NBTTagCompound()));
        }
        nbtTagCompound.func_74778_a("lastBlueprint", this.lastBlueprint == null ? "" : this.lastBlueprint.getRegistryName().toString());
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        String regName;
        super.func_145839_a(nbtTagCompound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        NBTTagCompound blueprintNBT = (NBTTagCompound)nbtTagCompound.func_74781_a("blueprint");
        if (blueprintNBT != null) {
            ItemStack blueprintStack = new ItemStack(blueprintNBT);
            IMinechemBlueprint blueprint = BlueprintUtil.getBlueprint(blueprintStack);
            this.setBlueprint(blueprint);
            this.inventory.set(0, (Object)blueprintStack);
            this.func_70299_a(0, blueprintStack);
        }
        if (nbtTagCompound.func_150297_b("lastBlueprint", 8) && !(regName = nbtTagCompound.func_74779_i("lastBlueprint")).isEmpty()) {
            this.lastBlueprint = (IMinechemBlueprint)ModRegistries.MINECHEM_BLUEPRINTS.getValue(new ResourceLocation(regName));
        }
    }

    public IMinechemBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == ModItems.blueprint && BlueprintUtil.getBlueprint(itemstack) != null;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEnergyRequired() {
        return 100;
    }
}

