/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.tile;

import javax.annotation.Nullable;
import minechem.block.multiblock.tile.TileFissionCore;
import minechem.block.multiblock.tile.TileFusionCore;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityProxy
extends TileMinechemEnergyBase
implements ISidedInventory {
    public TileReactorCore manager;
    int managerXOffset;
    int managerYOffset;
    int managerZOffset;
    final EnergySettableMultiBlock energyStorage = new EnergySettableMultiBlock(null);

    public TileEntityProxy() {
        super(ModConfig.energyPacketSize);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? CapabilityEnergy.ENERGY.cast((Object)this.energyStorage) : null);
    }

    public TileReactorCore getManager() {
        boolean posMatch;
        int xx = this.func_174877_v().func_177958_n();
        int yy = this.func_174877_v().func_177956_o();
        int zz = this.func_174877_v().func_177952_p();
        boolean bl = posMatch = this.managerXOffset == xx && this.managerYOffset == yy && this.managerZOffset == zz;
        if (!posMatch && this.manager == null) {
            TileEntity te = this.field_145850_b.func_175625_s(new BlockPos(this.func_174877_v().func_177958_n() + this.managerXOffset, this.func_174877_v().func_177956_o() + this.managerYOffset, this.func_174877_v().func_177952_p() + this.managerZOffset));
            this.manager = te instanceof TileFusionCore ? (TileFusionCore)te : (te instanceof TileFissionCore ? (TileFissionCore)te : (te instanceof TileReactorCore ? (TileReactorCore)te : null));
            this.energyStorage.setManager(this.manager);
        }
        return this.manager;
    }

    @Override
    public void func_73660_a() {
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.manager != null) {
            nbtTagCompound.func_74768_a("managerXOffset", this.manager.func_174877_v().func_177958_n());
            nbtTagCompound.func_74768_a("managerYOffset", this.manager.func_174877_v().func_177956_o());
            nbtTagCompound.func_74768_a("managerZOffset", this.manager.func_174877_v().func_177952_p());
        }
        return nbtTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        boolean posMatch;
        super.func_145839_a(nbtTagCompound);
        this.managerXOffset = nbtTagCompound.func_74762_e("managerXOffset");
        this.managerYOffset = nbtTagCompound.func_74762_e("managerYOffset");
        this.managerZOffset = nbtTagCompound.func_74762_e("managerZOffset");
        int xx = this.func_174877_v().func_177958_n();
        int yy = this.func_174877_v().func_177956_o();
        int zz = this.func_174877_v().func_177952_p();
        boolean bl = posMatch = this.managerXOffset == xx && this.managerYOffset == yy && this.managerZOffset == zz;
        if (this.field_145850_b != null && !posMatch) {
            BlockPos tilePos = new BlockPos(this.func_174877_v().func_177958_n() + this.managerXOffset, this.func_174877_v().func_177956_o() + this.managerYOffset, this.func_174877_v().func_177952_p() + this.managerZOffset);
            TileEntity te = this.field_145850_b.func_175625_s(tilePos);
            if (te instanceof TileFusionCore) {
                this.manager = (TileFusionCore)te;
            } else if (te instanceof TileFissionCore) {
                this.manager = (TileFissionCore)te;
            } else if (te instanceof TileReactorCore) {
                this.manager = (TileReactorCore)te;
            }
            this.energyStorage.setManager(this.manager);
        }
    }

    public void setManager(TileReactorCore managerTileEntity) {
        this.manager = managerTileEntity;
        if (managerTileEntity != null) {
            this.managerXOffset = managerTileEntity.func_174877_v().func_177958_n() - this.field_174879_c.func_177958_n();
            this.managerYOffset = managerTileEntity.func_174877_v().func_177956_o() - this.field_174879_c.func_177956_o();
            this.managerZOffset = managerTileEntity.func_174877_v().func_177952_p() - this.field_174879_c.func_177952_p();
            this.energyStorage.setManager(this.manager);
            this.func_70296_d();
            IBlockState iblockstate = this.func_145831_w().func_180495_p(this.func_174877_v());
            if (iblockstate != null) {
                this.func_145831_w().func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
        }
    }

    @Override
    public int func_70302_i_() {
        if (this.manager != null) {
            return ((ISidedInventory)this.manager).func_70302_i_();
        }
        return 0;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        if (this.manager != null && this.manager instanceof ISidedInventory) {
            return ((ISidedInventory)this.manager).func_70301_a(i);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.manager != null && this.manager instanceof ISidedInventory) {
            return ((ISidedInventory)this.manager).func_70298_a(i, j);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70304_b(int i) {
        if (this.manager != null && this.manager instanceof ISidedInventory) {
            return ((ISidedInventory)this.manager).func_70304_b(i);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        if (this.manager != null && this.manager instanceof ISidedInventory) {
            ((ISidedInventory)this.manager).func_70299_a(i, itemstack);
        }
    }

    @Override
    public String func_70005_c_() {
        return "Multiblock Minechem proxy";
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        if (this.manager != null) {
            return ((ISidedInventory)this.manager).func_70297_j_();
        }
        return 0;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.manager != null) {
            return ((ISidedInventory)this.manager).func_94041_b(i, itemstack);
        }
        return false;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing enumFacing) {
        if (this.manager != null) {
            return ((ISidedInventory)this.manager).func_180463_a(enumFacing);
        }
        return new int[0];
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return ModConfig.AllowAutomation && this.func_94041_b(slot, itemstack);
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return ModConfig.AllowAutomation && facing.func_176745_a() == 0 && slot == 2;
    }

    @Override
    public int getEnergyRequired() {
        return 0;
    }

    @Override
    public boolean func_191420_l() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnergy(int amount) {
        if (this.getForgeEnergyCap() instanceof EnergySettableMultiBlock) {
            ((EnergySettableMultiBlock)this.getForgeEnergyCap()).setEnergy(amount);
        }
    }

    public static class EnergySettableMultiBlock
    implements IEnergyStorage {
        private TileReactorCore manager;

        public EnergySettableMultiBlock(TileReactorCore manager) {
            this.manager = manager;
        }

        public void setManager(TileReactorCore manager) {
            this.manager = manager;
        }

        public TileReactorCore getManager() {
            return this.manager;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive() || this.getManager() == null) {
                return 0;
            }
            return this.getManager().receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            if (this.getManager() == null) {
                return 0;
            }
            return this.getManager().getEnergyStored();
        }

        public int getMaxEnergyStored() {
            if (this.getManager() == null) {
                return 0;
            }
            return this.getManager().getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public void setEnergy(int amount) {
            if (this.getManager() != null) {
                this.getManager().setEnergy(Math.abs(amount));
            }
        }
    }
}

