/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.tile;

import javax.annotation.Nullable;
import minechem.block.tile.TileMinechemBase;
import minechem.init.ModConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileMinechemEnergyBase
extends TileMinechemBase {
    private static int maxEnergyReceived = ModConfig.energyPacketSize;
    private int maxEnergy;
    public int energyStored;

    public TileMinechemEnergyBase(int maxEnergy) {
        this.maxEnergy = maxEnergy;
        this.energyStored = 0;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? CapabilityEnergy.ENERGY.cast((Object)new EnergySettable(this)) : null);
    }

    public void syncEnergyValue(int syncAt) {
        if (this.getEnergyStored() > syncAt) {
            this.useEnergy(this.getEnergyStored() - syncAt);
        } else if (this.getEnergyStored() < syncAt) {
            this.receiveEnergy(syncAt - this.getEnergyStored(), false);
        }
    }

    protected IEnergyStorage getForgeEnergyCap() {
        return (IEnergyStorage)this.getCapability(CapabilityEnergy.ENERGY, null);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.getForgeEnergyCap() != null) {
            return this.getForgeEnergyCap().receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        if (this.getForgeEnergyCap() != null) {
            return this.getForgeEnergyCap().getMaxEnergyStored();
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.getForgeEnergyCap() != null) {
            return this.getForgeEnergyCap().getEnergyStored();
        }
        return 0;
    }

    public void setEnergy(int amount) {
        if (this.getForgeEnergyCap() != null && this.getForgeEnergyCap() instanceof EnergySettable) {
            ((EnergySettable)this.getForgeEnergyCap()).setEnergy(amount);
        }
    }

    public boolean useEnergy(int energy) {
        if (!ModConfig.powerUseEnabled) {
            return true;
        }
        if (this.getEnergyStored() - energy < 0) {
            return false;
        }
        if (this.getEnergyStored() - energy > this.getMaxEnergyStored()) {
            return false;
        }
        this.energyStored -= energy;
        super.func_70296_d();
        return true;
    }

    public int getPowerRemainingScaled(double scale) {
        return (int)((double)this.getEnergyStored() * (scale / (double)this.getMaxEnergyStored()));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("energy", this.getEnergyStored());
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyStored = nbt.func_74762_e("energy");
    }

    public int getEnergyRequired() {
        return 0;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public static class EnergySettable
    implements IEnergyStorage {
        private final TileMinechemEnergyBase tile;

        public EnergySettable(TileMinechemEnergyBase tile) {
            this.tile = tile;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyReceived = Math.min(this.tile.maxEnergy - this.tile.energyStored, Math.min(maxEnergyReceived, maxReceive));
            if (!simulate) {
                this.tile.energyStored += energyReceived;
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return this.tile.energyStored;
        }

        public int getMaxEnergyStored() {
            return this.tile.maxEnergy;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public void setEnergy(int amount) {
            this.tile.energyStored = Math.abs(amount);
        }
    }
}

