/*
 * Decompiled with CFR 0.152.
 */
package minechem.block.tile;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModConfig;
import minechem.init.ModItems;
import minechem.init.ModNetworking;
import minechem.network.message.MessageSyncSynthesisMachine;
import minechem.recipe.handler.RecipeHandlerSynthesis;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import minechem.utils.RecipeUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class TileSynthesis
extends TileMinechemEnergyBase
implements ISidedInventory {
    public static final int SLOT_ID_CHEMISTS_JOURNAL = 0;
    public static final int SLOT_ID_OUTPUT_JOURNAL = 1;
    public static final int SLOT_ID_OUTPUT_MATRIX = 2;
    public static final int[] SLOT_IDS_MATRIX = new int[]{3, 4, 5, 6, 7, 8, 9, 10, 11};
    public static final int[] SLOT_IDS_STORAGE_BUFFER = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
    private NonNullList<ItemStack> cachedRecipeStacks = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private int timer = 0;

    public TileSynthesis() {
        super(ModConfig.maxSynthesizerStorage);
        this.inventory = NonNullList.func_191197_a((int)31, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, facing));
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (slot == 0) {
            this.onTakeJournal();
        }
        if (slot < SLOT_IDS_MATRIX[0] || slot <= SLOT_IDS_MATRIX[8]) {
            // empty if block
        }
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            ItemStack itemstack = ItemStack.field_190927_a;
            if (slot == 2) {
                return super.func_70298_a(slot, amount);
            }
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= amount) {
                itemstack = (ItemStack)this.inventory.get(slot);
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            itemstack = ((ItemStack)this.inventory.get(slot)).func_77979_a(amount);
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public int func_70302_i_() {
        return 31;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList inventoryTagList = nbt.func_150295_c("inventory", 10);
        this.inventory = MinechemUtil.readTagListToItemStackList(inventoryTagList);
    }

    private void onTakeJournal() {
        this.checkRecipe();
    }

    private void onPutJournal(@Nonnull ItemStack stack) {
        ISynthesisRecipe recipe;
        ItemStack activeItem = ModItems.journal.getActiveStack(stack);
        if (!activeItem.func_190926_b() && (recipe = RecipeHandlerSynthesis.getRecipeFromOutput(activeItem)) != null) {
            this.fillMatrixWithRecipe(recipe);
        }
    }

    private void fillMatrixWithRecipe(ISynthesisRecipe recipe) {
        NonNullList<ItemStack> molecules = RecipeUtil.getRecipeAsStackList(recipe);
        this.clearMatrix();
        for (int i = 0; i < molecules.size(); ++i) {
            if (molecules.get(i) != null) {
                ItemStack stack = (ItemStack)molecules.get(i);
                if (!stack.func_190926_b()) {
                    this.func_70299_a(SLOT_IDS_MATRIX[i], stack);
                    continue;
                }
                this.func_70299_a(SLOT_IDS_MATRIX[i], ItemStack.field_190927_a);
                continue;
            }
            this.func_70299_a(SLOT_IDS_MATRIX[i], ItemStack.field_190927_a);
        }
    }

    private void clearMatrix() {
        for (int element : SLOT_IDS_MATRIX) {
            this.inventory.set(element, (Object)ItemStack.field_190927_a);
        }
    }

    private NonNullList<ItemStack> getMatrixStackList() {
        return this.getMatrixStackList(false);
    }

    private NonNullList<ItemStack> getMatrixStackList(boolean excludeEmptyStacks) {
        NonNullList matrixStacks = excludeEmptyStacks ? NonNullList.func_191196_a() : NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < SLOT_IDS_MATRIX.length; ++i) {
            ItemStack stack = this.func_70301_a(SLOT_IDS_MATRIX[i]);
            if (stack.func_190926_b()) continue;
            if (excludeEmptyStacks) {
                matrixStacks.add((Object)stack);
                continue;
            }
            matrixStacks.set(i, (Object)stack);
        }
        return matrixStacks;
    }

    private boolean recipeHasChanged() {
        NonNullList<ItemStack> matrixStacks = this.getMatrixStackList();
        for (int i = 0; i < 9; ++i) {
            ItemStack matrixStack = (ItemStack)matrixStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)matrixStack, (ItemStack)((ItemStack)this.cachedRecipeStacks.get(i)))) continue;
            return true;
        }
        return false;
    }

    private void updateCachedRecipeStacks() {
        for (int i = 0; i < 9; ++i) {
            this.cachedRecipeStacks.set(i, this.inventory.get(SLOT_IDS_MATRIX[i]));
        }
    }

    public InventoryCraftingFake getCraftingInv() {
        return new InventoryCraftingFake(this.getMatrixStackList());
    }

    private void updateRecipeOutput() {
        ISynthesisRecipe recipe = this.getCurrentRecipe();
        if (recipe != null) {
            this.inventory.set(1, (Object)recipe.getRecipeOutput());
        } else {
            this.inventory.set(1, (Object)ItemStack.field_190927_a);
        }
    }

    public ISynthesisRecipe getCurrentRecipe() {
        return RecipeHandlerSynthesis.findMatchingRecipe(this.getCraftingInv(), this.field_145850_b);
    }

    private boolean isCurrentRecipeShaped() {
        return this.getCurrentRecipe() == null ? false : RecipeHandlerSynthesis.isShaped(this.getCurrentRecipe());
    }

    private boolean isCurrentRecipeShapeless() {
        return this.getCurrentRecipe() == null ? false : RecipeHandlerSynthesis.isShapeless(this.getCurrentRecipe());
    }

    private Map<ItemStack, Integer> getRecipeStackCosts() {
        int i;
        HashMap<ItemStack, Integer> returnData = new HashMap<ItemStack, Integer>();
        HashMap<Integer, Pair> data = new HashMap<Integer, Pair>();
        NonNullList<ItemStack> matrixList = this.getMatrixStackList();
        for (i = 0; i < matrixList.size(); ++i) {
            ItemStack stack = (ItemStack)matrixList.get(i);
            int count = stack.func_190916_E();
            ItemStack tmpStack = stack.func_77946_l();
            tmpStack.func_190920_e(1);
            if (data.get(i) == null) {
                data.put(i, Pair.of((Object)tmpStack, (Object)count));
                continue;
            }
            data.put(i, Pair.of((Object)tmpStack, (Object)(count += ((Integer)((Pair)data.get(i)).getRight()).intValue())));
        }
        for (i = 0; i < data.size(); ++i) {
            if (((ItemStack)((Pair)data.get(i)).getLeft()).func_190926_b()) continue;
            returnData.put((ItemStack)((Pair)data.get(i)).getLeft(), (Integer)((Pair)data.get(i)).getRight());
        }
        return returnData;
    }

    private Map<ItemStack, Integer> getStorageStackAmounts() {
        HashMap<ItemStack, Integer> data = new HashMap<ItemStack, Integer>();
        NonNullList<ItemStack> storageList = this.getStorageBuffer(true);
        for (ItemStack stack : storageList) {
            int count = stack.func_190916_E();
            ItemStack tmpStack = RadiationUtil.getStackWithoutRadiation(stack.func_77946_l());
            tmpStack.func_190920_e(1);
            if (!this.isStackAdded(data, tmpStack)) {
                data.put(tmpStack, count);
                continue;
            }
            data.put(tmpStack, count += this.getCount(data, tmpStack));
        }
        return data;
    }

    private int getCount(Map<ItemStack, Integer> data, ItemStack scompStack) {
        for (ItemStack stack : data.keySet()) {
            if (!ItemStack.func_77989_b((ItemStack)RadiationUtil.getStackWithoutRadiation(stack), (ItemStack)RadiationUtil.getStackWithoutRadiation(scompStack))) continue;
            return data.get(RadiationUtil.getStackWithoutRadiation(stack));
        }
        return 0;
    }

    private boolean isStackAdded(Map<ItemStack, Integer> data, ItemStack scompStack) {
        for (ItemStack stack : data.keySet()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)scompStack)) continue;
            return true;
        }
        return false;
    }

    private boolean doesStorageContainEnoughToCraft() {
        if (this.getStorageBuffer(true).size() > 0) {
            Map<ItemStack, Integer> storageAmounts = this.getStorageStackAmounts();
            Map<ItemStack, Integer> recipeCosts = this.getRecipeStackCosts();
            for (ItemStack stack : recipeCosts.keySet()) {
                if (this.isStackAdded(storageAmounts, stack) && this.getCount(storageAmounts, stack) >= this.getCount(recipeCosts, stack)) continue;
                return false;
            }
        }
        return true;
    }

    private NonNullList<ItemStack> getStorageBuffer(boolean excludeEmptyStacks) {
        int size = SLOT_IDS_STORAGE_BUFFER.length;
        NonNullList stackList = NonNullList.func_191196_a();
        for (int i = 0; i < size; ++i) {
            ItemStack currentStack = this.func_70301_a(SLOT_IDS_STORAGE_BUFFER[i]);
            if (!excludeEmptyStacks) {
                stackList.add((Object)currentStack);
                continue;
            }
            if (!excludeEmptyStacks || currentStack.func_190926_b()) continue;
            stackList.add((Object)currentStack);
        }
        return stackList;
    }

    public void checkRecipe() {
        this.updateRecipeOutput();
    }

    private boolean canMergeRecipeOutputToMatrixOutputSlot() {
        if (this.getCurrentRecipe() != null) {
            ItemStack recipeOutput = this.getCurrentRecipe().getRecipeOutput();
            ItemStack stackInMatrixOutput = this.func_70301_a(2);
            if (stackInMatrixOutput.func_190926_b()) {
                return true;
            }
            return recipeOutput.func_77969_a(stackInMatrixOutput) && stackInMatrixOutput.func_190916_E() + recipeOutput.func_190916_E() <= stackInMatrixOutput.func_77976_d();
        }
        return false;
    }

    private boolean areValuesAllZero(Map<ItemStack, Integer> amounts) {
        for (ItemStack stack : amounts.keySet()) {
            if (amounts.get(stack) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean testAndConsumeCraftingItems(Map<Integer, ItemStack> undo, boolean strictDamage) {
        int keep = 0;
        InventoryCraftingFake inventory = this.getCraftingInv();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            int count = stack.func_190916_E();
            for (int element : SLOT_IDS_STORAGE_BUFFER) {
                int slotIdx = element;
                ItemStack input = this.func_70301_a(slotIdx);
                if (!input.func_190926_b() && input.func_190916_E() > keep && TileSynthesis.match(stack, input, strictDamage)) {
                    int ss = count;
                    if (input.func_190916_E() - ss < keep) {
                        ss = input.func_190916_E() - keep;
                    }
                    count -= ss;
                    if (!undo.containsKey(slotIdx)) {
                        undo.put(slotIdx, input.func_77946_l());
                    }
                    input.func_77979_a(ss);
                    if (input.func_190926_b()) {
                        this.func_70299_a(slotIdx, ItemStack.field_190927_a);
                    }
                }
                if (count == 0) break;
            }
            if (count <= 0) continue;
            return false;
        }
        return RecipeHandlerSynthesis.findMatchingRecipe(this.getCraftingInv(), this.func_145831_w()) != null;
    }

    private static boolean match(ItemStack target, ItemStack input, boolean strictDamage) {
        if (strictDamage) {
            return OreDictionary.itemMatches((ItemStack)target, (ItemStack)input, (boolean)false);
        }
        if (input.func_190926_b() && !target.func_190926_b() || !input.func_190926_b() && target.func_190926_b()) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b();
    }

    private void undo(Map<Integer, ItemStack> undo) {
        for (Map.Entry<Integer, ItemStack> entry : undo.entrySet()) {
            this.func_70299_a(entry.getKey(), entry.getValue());
        }
        undo.clear();
    }

    private void tryToCraft() {
        if (this.doesStorageContainEnoughToCraft() && this.canMergeRecipeOutputToMatrixOutputSlot() && this.hasEnoughPower()) {
            ItemStack matrixOutputStack;
            HashMap<Integer, ItemStack> undo = new HashMap<Integer, ItemStack>();
            if (!this.testAndConsumeCraftingItems(undo, true)) {
                this.undo(undo);
                if (!this.testAndConsumeCraftingItems(undo, false)) {
                    this.undo(undo);
                    return;
                }
            } else if (ModConfig.powerUseEnabled) {
                int cost = this.getCurrentRecipe().getEnergyCost();
                this.setEnergy(this.getEnergyStored() - cost);
            }
            if ((matrixOutputStack = this.func_70301_a(2)).func_190926_b()) {
                this.func_70299_a(2, this.getCurrentRecipe().getRecipeOutput());
            } else {
                matrixOutputStack.func_190917_f(1);
            }
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            ModNetworking.INSTANCE.sendToAll((IMessage)new MessageSyncSynthesisMachine(this));
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.tryToCraft();
        if (this.timer < 10) {
            ++this.timer;
        } else {
            this.timer = 0;
            this.checkRecipe();
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            if (state != null) {
                this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
            }
        }
    }

    @Override
    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.inventory.set(slot, (Object)stack.func_77946_l());
        if (slot == 0 && !stack.func_190926_b()) {
            this.onPutJournal(stack);
        }
        if (slot >= SLOT_IDS_MATRIX[0] && slot <= SLOT_IDS_MATRIX[8]) {
            this.checkRecipe();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList inventoryTagList = MinechemUtil.writeItemStackListToTagList((NonNullList<ItemStack>)this.inventory);
        nbt.func_74782_a("inventory", (NBTBase)inventoryTagList);
        return nbt;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 255, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public String func_70005_c_() {
        return "container.synthesis";
    }

    public boolean hasEnoughPower() {
        if (!ModConfig.powerUseEnabled) {
            return true;
        }
        if (this.getCurrentRecipe() != null) {
            return this.getEnergyStored() >= this.getCurrentRecipe().getEnergyCost();
        }
        return true;
    }

    @Override
    public int getEnergyRequired() {
        if (this.getCurrentRecipe() != null && ModConfig.powerUseEnabled) {
            return this.getCurrentRecipe().getEnergyCost();
        }
        return 0;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public int func_174887_a_(int i) {
        return 0;
    }

    @Override
    public void func_174885_b(int i, int i1) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
    }

    public int[] func_180463_a(EnumFacing facing) {
        int[] slots = new int[SLOT_IDS_STORAGE_BUFFER.length + 1];
        slots[0] = 2;
        for (int i = 1; i < SLOT_IDS_STORAGE_BUFFER.length; ++i) {
            slots[i] = SLOT_IDS_STORAGE_BUFFER[i];
        }
        return slots;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing facing) {
        return ModConfig.AllowAutomation && (itemstack.func_77973_b() == ModItems.element || itemstack.func_77973_b() == ModItems.molecule) && slot >= SLOT_IDS_STORAGE_BUFFER[0] && slot < SLOT_IDS_STORAGE_BUFFER[0] + SLOT_IDS_STORAGE_BUFFER.length;
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing facing) {
        return ModConfig.AllowAutomation && slot == 2;
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public static class InventoryCraftingFake
    extends InventoryCrafting {
        private final NonNullList<ItemStack> invList;

        public InventoryCraftingFake(NonNullList<ItemStack> invList) {
            super(null, 3, 3);
            this.invList = invList;
        }

        public int func_70302_i_() {
            return this.invList.size();
        }

        public boolean func_191420_l() {
            for (ItemStack itemstack : this.invList) {
                if (itemstack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.func_70302_i_() ? ItemStack.field_190927_a : (ItemStack)this.invList.get(index);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.invList, (int)index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack itemstack = ItemStackHelper.func_188382_a(this.invList, (int)index, (int)count);
            return itemstack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.invList.set(index, (Object)stack);
        }

        public void func_174888_l() {
            this.invList.clear();
        }

        public void func_194018_a(RecipeItemHelper helper) {
            for (ItemStack itemstack : this.invList) {
                helper.func_194112_a(itemstack);
            }
        }
    }
}

