/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.block.tile.TileMicroscope;
import minechem.client.gui.GuiContainerTabbed;
import minechem.client.gui.GuiMicroscopeToggle;
import minechem.client.gui.renderitem.RenderItemMicroscope;
import minechem.client.gui.widget.tab.TabHelp;
import minechem.container.ContainerMicroscope;
import minechem.init.ModGlobals;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.RecipeDecomposerChance;
import minechem.recipe.RecipeDecomposerSelect;
import minechem.recipe.handler.RecipeHandlerDecomposer;
import minechem.recipe.handler.RecipeHandlerSynthesis;
import minechem.utils.MinechemUtil;
import minechem.utils.RecipeUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class GuiMicroscope
extends GuiContainerTabbed {
    int guiWidth = 176;
    int guiHeight = 217;
    int eyepieceX = 25;
    int eyepieceY = 26;
    int inputSlotX = 44;
    int inputSlotY = 45;
    int slideShowTimer = 0;
    int currentSlide = 0;
    public InventoryPlayer inventoryPlayer;
    protected TileMicroscope microscope;
    GuiMicroscopeToggle recipeSwitch;
    private boolean isShapedRecipe;

    public GuiMicroscope(InventoryPlayer inventoryPlayer, TileMicroscope microscope) {
        super(new ContainerMicroscope(inventoryPlayer, microscope), new RenderItemMicroscope());
        ((RenderItemMicroscope)this.renderItem).setGui(this);
        this.inventoryPlayer = inventoryPlayer;
        this.microscope = microscope;
        this.field_146999_f = this.guiWidth;
        this.field_147000_g = this.guiHeight;
        this.recipeSwitch = new GuiMicroscopeToggle(this);
        this.addTab(new TabHelp(this, MinechemUtil.getLocalString("help.microscope")));
    }

    public int getGuiWidth() {
        return this.guiWidth;
    }

    public int getGuiHeight() {
        return this.guiHeight;
    }

    public int getEyePieceX() {
        return this.eyepieceX;
    }

    public int getEyePieceY() {
        return this.eyepieceY;
    }

    public boolean isMouseInMicroscope() {
        this.mouseX = this.getMouseX();
        this.mouseY = this.getMouseY();
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        int h = 54;
        int w = 54;
        return this.mouseX >= (x += this.eyepieceX) && this.mouseX <= x + w && this.mouseY >= (y += this.eyepieceY) && this.mouseY <= y + h;
    }

    private void drawMicroscopeOverlay() {
        this.field_73735_i = 600.0f;
        this.func_73729_b(this.eyepieceX, this.eyepieceY, 176, 0, 54, 54);
    }

    private void drawUnshapedOverlay() {
        this.field_73735_i = 0.0f;
        this.func_73729_b(97, 26, 176, 70, 54, 54);
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String info = MinechemUtil.getLocalString("gui.title.microscope");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        GlStateManager.func_179147_l();
        this.field_146289_q.func_78276_b(info, (this.guiWidth - infoWidth) / 2, 5, 0);
        super.func_146979_b(par1, par2);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.MICROSCOPE);
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, this.guiWidth, this.guiHeight);
        this.drawMicroscopeOverlay();
        if (!this.isShapedRecipe) {
            this.drawUnshapedOverlay();
        }
        GlStateManager.func_179121_F();
        this.recipeSwitch.setPos(x + 153, y + 26);
        this.recipeSwitch.draw(this.field_146297_k.field_71446_o);
        ItemStack itemstack = this.microscope.func_70301_a(0);
        this.clearRecipeMatrix();
        if (!itemstack.func_190926_b()) {
            if (this.recipeSwitch.getState() == 0) {
                this.drawSynthesisRecipe(itemstack, x, y);
            } else {
                this.isShapedRecipe = false;
                this.drawDecomposerRecipe(itemstack, x, y);
            }
        }
    }

    @Override
    protected void drawSlotCustom(Slot slotIn) {
        int x = slotIn.field_75223_e;
        int y = slotIn.field_75221_f;
        ItemStack stack = slotIn.func_75211_c();
        if (slotIn.field_75222_d == 0 && !stack.func_190926_b()) {
            this.field_73735_i = 200.0f;
            this.renderItem.field_77023_b = 200.0f;
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            this.renderItem.func_180450_b(stack, x, y);
            this.field_73735_i = 0.0f;
            this.renderItem.field_77023_b = 0.0f;
            return;
        }
        super.drawSlotCustom(slotIn);
    }

    private void clearRecipeMatrix() {
        for (int slot = 2; slot < 11; ++slot) {
            this.field_147002_h.func_75141_a(slot, ItemStack.field_190927_a);
        }
    }

    private void drawSynthesisRecipe(ItemStack inputstack, int x, int y) {
        ISynthesisRecipe recipe = RecipeHandlerSynthesis.getRecipeFromOutput(inputstack);
        if (recipe != null) {
            this.drawSynthesisRecipeMatrix(recipe, x, y);
            this.drawSynthesisRecipeCost(recipe, x, y);
            this.drawRecipeType(recipe, x, y);
            this.isShapedRecipe = recipe.isShaped();
        }
    }

    private void drawSynthesisRecipeMatrix(ISynthesisRecipe recipe, int x, int y) {
        NonNullList<ItemStack> shapedRecipe = RecipeUtil.getRecipeAsStackList(recipe);
        int slot = 2;
        for (ItemStack itemstack : shapedRecipe) {
            this.field_147002_h.func_75141_a(slot, itemstack);
            if (++slot < 11) continue;
            break;
        }
    }

    private void drawRecipeType(ISynthesisRecipe recipe, int x, int y) {
        if (!this.recipeSwitch.isMoverOver()) {
            String type = RecipeHandlerSynthesis.isShaped(recipe) ? "Shaped" : "Shapeless";
            String cost = String.format("%s", type);
            this.field_146289_q.func_78276_b(cost, x + 100, y + 95, 0);
        }
    }

    private void drawSynthesisRecipeCost(ISynthesisRecipe recipe, int x, int y) {
        if (!this.recipeSwitch.isMoverOver()) {
            String cost = String.format("%d Energy", RecipeHandlerSynthesis.getEnergyCost(recipe));
            this.field_146289_q.func_78276_b(cost, x + 100, y + 85, 0);
        }
    }

    private void drawDecomposerRecipe(@Nonnull ItemStack inputstack, int x, int y) {
        RecipeDecomposer recipe = RecipeHandlerDecomposer.instance.getRecipe(inputstack);
        if (recipe != null) {
            NonNullList<ItemStack> output = MinechemUtil.convertChemicalsIntoItemStacks(recipe.getOutputRaw());
            if (recipe instanceof RecipeDecomposerSelect) {
                this.drawDecomposerRecipeSelectMatrix(((RecipeDecomposerSelect)recipe).getAllPossibleOutputs(), x, y);
            } else {
                this.drawDecomposerRecipeMatrix(output, x, y);
            }
            this.drawDecomposerChance(recipe, x, y);
        }
    }

    private void drawDecomposerRecipeMatrix(NonNullList<ItemStack> output, int x, int y) {
        int slot = 2;
        for (ItemStack itemstack : output) {
            this.field_147002_h.func_75141_a(slot, itemstack);
            if (++slot < 11) continue;
            break;
        }
    }

    private void drawDecomposerRecipeSelectMatrix(ArrayList<ArrayList<PotionChemical>> outputs, int x, int y) {
        if (this.slideShowTimer == 160) {
            this.slideShowTimer = 0;
            ++this.currentSlide;
        }
        if (this.currentSlide == outputs.size()) {
            this.currentSlide = 0;
        }
        ++this.slideShowTimer;
        ArrayList<PotionChemical> output = outputs.get(this.currentSlide);
        NonNullList<ItemStack> outputStack = MinechemUtil.convertChemicalsIntoItemStacks(output);
        this.drawDecomposerRecipeMatrix(outputStack, x, y);
    }

    private void drawDecomposerChance(RecipeDecomposer recipe, int x, int y) {
        if (!this.recipeSwitch.isMoverOver() && recipe instanceof RecipeDecomposerChance) {
            RecipeDecomposerChance recipeChance = (RecipeDecomposerChance)recipe;
            int chance = (int)(recipeChance.getChance() * 100.0f);
            String info = String.format("%d%%", chance);
            this.field_146289_q.func_78276_b(info, x + 108, y + 85, 0);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        this.recipeSwitch.mouseClicked(x, y, mouseButton);
    }

    @Override
    protected void drawStack(ItemStack stack, int x, int y, String altText) {
        Slot slot = (Slot)this.field_147002_h.field_75151_b.get(0);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = this.field_146297_k.field_71466_p;
        }
        boolean shouldRenderHeldZoomed = false;
        shouldRenderHeldZoomed = this.isMouseInMicroscope();
        if (shouldRenderHeldZoomed) {
            this.renderItem.func_180450_b(stack, x, y);
            GlStateManager.func_179126_j();
        } else {
            this.field_146296_j.func_180450_b(stack, x, y);
        }
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.field_147012_x.func_190926_b() ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }
}

