/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.io.IOException;
import minechem.block.tile.TileSynthesis;
import minechem.client.gui.GuiContainerTabbed;
import minechem.client.gui.widget.tab.TabHelp;
import minechem.client.gui.widget.tab.TabSynthesisState;
import minechem.container.ContainerSynthesis;
import minechem.init.ModGlobals;
import minechem.init.ModNetworking;
import minechem.inventory.slot.SlotFake;
import minechem.network.message.MessageFakeSlotScroll;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiSynthesis
extends GuiContainerTabbed {
    int guiWidth = 176;
    int guiHeight = 242;

    public GuiSynthesis(InventoryPlayer inventoryPlayer, TileSynthesis synthesis) {
        super(new ContainerSynthesis(inventoryPlayer, synthesis));
        this.field_146999_f = this.guiWidth;
        this.field_147000_g = this.guiHeight;
        this.addTab(new TabSynthesisState((Gui)this, synthesis));
        this.addTab(new TabHelp(this, MinechemUtil.getLocalString("help.synthesis")));
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = MinechemUtil.getLocalString("gui.title.synthesis");
        String storageHeader = MinechemUtil.getLocalString("gui.synthesis.input_storage");
        String invHeader = MinechemUtil.getLocalString("gui.title.inventory");
        String outputHeader = MinechemUtil.getLocalString("gui.synthesis.output");
        String invMakes = MinechemUtil.getLocalString("gui.synthesis.creates") + ":";
        int titleWidth = this.field_146289_q.func_78256_a(title);
        int makesWidth = this.field_146289_q.func_78256_a(invMakes);
        this.field_146289_q.func_78276_b(title, (this.guiWidth - titleWidth) / 2, 5, 0);
        this.field_146289_q.func_78276_b(invMakes, (this.guiWidth - makesWidth) / 2, 73, 0);
        this.field_146289_q.func_78276_b(storageHeader, 8, 103, 0);
        this.field_146289_q.func_78276_b(invHeader, 8, 150, 0);
        this.field_146289_q.func_78276_b(outputHeader, 125, 25, 0);
        super.func_146979_b(par1, par2);
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.SYNTHESIS);
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        this.func_73729_b(x, y, 0, 0, this.guiWidth, this.guiHeight);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && GuiSynthesis.func_146272_n() && this.isOverSynthesisMatrixSlot()) {
            int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.mouseWheelEvent(x, y, i / Math.abs(i));
        }
    }

    private boolean isOverSynthesisMatrixSlot() {
        Slot slot = this.getSlotUnderMouse();
        return slot != null && slot instanceof SlotFake;
    }

    private void mouseWheelEvent(int x, int y, int wheel) {
        Slot slot = this.getSlot(x, y);
        ScrollDirection direction = wheel > 0 ? ScrollDirection.DOWN : ScrollDirection.UP;
        int times = Math.abs(wheel);
        for (int h = 0; h < times; ++h) {
            MessageFakeSlotScroll p = new MessageFakeSlotScroll(direction, slot.field_75222_d);
            ModNetworking.INSTANCE.sendToServer((IMessage)p);
        }
    }

    private Slot getSlot(int x, int y) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.isMouseOverSlot(slot, x, y) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    public static enum ScrollDirection {
        UP(-1),
        IDLE(0),
        DOWN(1);

        private final int id;

        private ScrollDirection(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

