/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.util.HashMap;
import minechem.client.gui.GuiContainerTabbed;
import minechem.utils.MinechemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;

public abstract class GuiTogglable {
    protected int numStates;
    protected int state = 0;
    protected int zLevel = 100;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected int mouseX;
    protected int mouseY;
    protected Minecraft mc;
    protected GuiContainerTabbed container;
    protected ResourceLocation texture;
    protected HashMap<Integer, ToggleButton> buttons = new HashMap();

    public GuiTogglable() {
        this.mc = FMLClientHandler.instance().getClient();
    }

    public void draw(TextureManager renderEngine) {
        renderEngine.func_110577_a(this.texture);
        ToggleButton button = this.buttons.get(this.state);
        this.drawTexturedModalRect(this.x, this.y, button.u, button.v, this.width, this.height);
        String tooltip = MinechemUtil.getLocalString(button.tooltip);
        int cx = (this.container.field_146294_l - this.container.getXSize()) / 2;
        int cy = (this.container.field_146295_m - this.container.getYSize()) / 2;
        int tooltipWidth = this.mc.field_71466_p.func_78256_a(tooltip);
        if (this.isMoverOver()) {
            GlStateManager.func_179097_i();
            this.container.func_146279_a(tooltip, cx + 77 - tooltipWidth / 2, cy + 100);
            GlStateManager.func_179126_j();
        }
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void mouseClicked(int x, int y, int mouseButton) {
        if (this.isMoverOver()) {
            this.onClicked();
        }
    }

    public boolean isMoverOver() {
        this.mouseX = this.container.getMouseX();
        this.mouseY = this.container.getMouseY();
        return this.mouseX > this.x && this.mouseX < this.x + this.width && this.mouseY > this.y && this.mouseY < this.y + this.height;
    }

    public int getState() {
        return this.state;
    }

    private void onClicked() {
        ++this.state;
        if (this.state == this.numStates) {
            this.state = 0;
        }
    }

    public void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)(par1 + 0), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        vb.func_181662_b((double)(par1 + par5), (double)(par2 + par6), (double)this.zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + par6) * var8)).func_181675_d();
        vb.func_181662_b((double)(par1 + par5), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)((float)(par3 + par5) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        vb.func_181662_b((double)(par1 + 0), (double)(par2 + 0), (double)this.zLevel).func_187315_a((double)((float)(par3 + 0) * var7), (double)((float)(par4 + 0) * var8)).func_181675_d();
        tessellator.func_78381_a();
    }

    public class ToggleButton {
        public int u;
        public int v;
        public String tooltip;
    }
}

