/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget;

import java.util.List;
import minechem.api.client.gui.widget.IGuiMaterialListSlot;
import minechem.client.gui.GuiBlueprintProjector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class GuiMaterialListSlot
implements IGuiMaterialListSlot {
    final ItemStack stack;
    int count;
    int index;
    int x;
    int y;
    final List<String> tooltip;
    final GuiBlueprintProjector gui;
    final int width = 49;
    final int height = 10;

    public GuiMaterialListSlot(GuiBlueprintProjector gui, int index, int x, int y, Pair<ItemStack, Integer> listItem, List<String> tooltip) {
        this.gui = gui;
        this.index = index;
        this.x = x;
        this.y = y;
        this.stack = (ItemStack)listItem.getLeft();
        this.count = (Integer)listItem.getRight();
        this.tooltip = tooltip;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.getGui().getProjector().hasBlueprint()) {
            int yOffset = this.getGui().guiTop() + this.getY() + 50;
            return mouseX >= this.getGui().guiLeft() + this.getX() + 1 && mouseX < this.getGui().guiLeft() + this.getX() + this.width() && mouseY >= yOffset + this.getIndex() && mouseY < yOffset + this.height();
        }
        return false;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int width() {
        return 49;
    }

    @Override
    public int height() {
        return 10;
    }

    public GuiBlueprintProjector getGui() {
        return this.gui;
    }

    @Override
    public Pair<ItemStack, Integer> get() {
        return Pair.of((Object)this.stack, (Object)this.count);
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    @Override
    public void draw(int x, int y, int mouseX, int mouseY) {
        this.x = x;
        this.y = y;
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
        int round = y / 10;
        this.drawItem(x + 8, y * 2 + 77 - this.getIndex(), (ItemStack)this.get().getLeft());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        Minecraft.func_71410_x().field_71466_p.func_78276_b("x " + this.get().getRight(), x + 34, y * 2 + 107, 0);
        GlStateManager.func_179121_F();
    }

    protected void drawItem(int x, int y, ItemStack is) {
        this.getGui().setZLevel(100.0f);
        this.getGui().setItemRenderZLevel(100.0f);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        this.getGui().getItemRenderer().func_180450_b(is, x, y);
        GlStateManager.func_179097_i();
        this.getGui().setItemRenderZLevel(0.0f);
        this.getGui().setZLevel(0.0f);
    }
}

