/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget.tab;

import minechem.block.tile.TileBlueprintProjector;
import minechem.client.gui.widget.tab.GuiTabState;
import minechem.init.ModConfig;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;

public class TabBlueprintProjectorState
extends GuiTabState {
    public TabBlueprintProjectorState(Gui gui, TileBlueprintProjector projector) {
        super(gui);
        this.tileEntity = projector;
    }

    @Override
    public void update() {
        super.update();
        TileBlueprintProjector projector = (TileBlueprintProjector)this.tileEntity;
        this.state = !ModConfig.powerUseEnabled || projector.getEnergyStored() > ModConfig.costDecomposition ? GuiTabState.TabState.powered : GuiTabState.TabState.unpowered;
        this.overlayColor = this.state.color;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(x + 1, y + 3);
        if (!this.isFullyOpened()) {
            return;
        }
        this.fontRenderer.func_78279_b(MinechemUtil.getLocalString(this.state.tooltip), x + 22, y + 3, this.maxWidth, this.headerColour);
        if (ModConfig.powerUseEnabled) {
            String[] lines;
            this.fontRenderer.func_175063_a(MinechemUtil.getLocalString("tab.title.stored") + ":", (float)(x + 5), (float)(y + 30), this.subheaderColour);
            String print = this.tileEntity.getEnergyStored() + " FE (" + String.valueOf(this.tileEntity.getPowerRemainingScaled(100.0)) + "%)";
            this.fontRenderer.func_78276_b(print, x + 5, y + 40, this.textColour);
            String energyMsg = MinechemUtil.getLocalString("tab.title.activation_energy_projector");
            int yPos = y + 60;
            for (String str : lines = energyMsg.split("\n")) {
                this.fontRenderer.func_175063_a(str, (float)(x + 5), (float)yPos, this.subheaderColour);
                yPos += 10;
            }
            this.fontRenderer.func_78276_b(String.valueOf(this.tileEntity.getEnergyRequired()) + " FE", x + 5, yPos, this.textColour);
        }
    }
}

