/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget.tab;

import minechem.block.multiblock.tile.TileFissionCore;
import minechem.block.multiblock.tile.TileFusionCore;
import minechem.client.gui.widget.tab.GuiTabState;
import minechem.init.ModConfig;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.IInventory;

public class TabFissionState
extends GuiTabState {
    private int lastKnownEnergyCost = 0;

    public TabFissionState(Gui gui, TileFissionCore fission) {
        super(gui);
        this.tileEntity = fission;
        this.state = GuiTabState.TabState.norecipe;
    }

    @Override
    public void update() {
        TileFusionCore fissionTile;
        super.update();
        if (this.tileEntity instanceof TileFusionCore && (fissionTile = (TileFusionCore)this.tileEntity) instanceof IInventory) {
            TileFusionCore tileInv = fissionTile;
            if (tileInv.func_70301_a(0).func_190926_b()) {
                this.state = GuiTabState.TabState.norecipe;
            } else {
                this.lastKnownEnergyCost = (tileInv.func_70301_a(0).func_77952_i() + 1) * ModConfig.fissionMultiplier;
                this.state = ((TileFissionCore)this.tileEntity).inputIsFissionable() ? (this.tileEntity.getEnergyRequired() < this.tileEntity.getEnergyStored() ? GuiTabState.TabState.powered : GuiTabState.TabState.unpowered) : GuiTabState.TabState.norecipe;
            }
        }
        this.overlayColor = this.state.color;
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.state == GuiTabState.TabState.unpowered && this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

