/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import minechem.client.model.generated.IModelParticleProvider;
import minechem.client.model.generated.ModelProperties;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractBakedPropertiesModel
implements IModelParticleProvider {
    protected final ModelProperties properties;

    public AbstractBakedPropertiesModel(ModelProperties properties) {
        this.properties = properties;
    }

    public boolean func_177555_b() {
        return this.properties.isAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.properties.isGui3d();
    }

    public boolean func_188618_c() {
        return this.properties.isBuiltInRenderer();
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.properties.getParticleTexture();
    }

    protected List<BakedQuad> getAllQuads(IBlockState state) {
        LinkedList<BakedQuad> allQuads = new LinkedList<BakedQuad>();
        allQuads.addAll(this.func_188616_a(state, null, 0L));
        for (EnumFacing face : EnumFacing.field_82609_l) {
            allQuads.addAll(this.func_188616_a(state, face, 0L));
        }
        return allQuads;
    }

    @Override
    public Set<TextureAtlasSprite> getHitEffects(@Nonnull RayTraceResult traceResult, IBlockState state, IBlockAccess world, BlockPos pos) {
        Vec3d vec = traceResult.field_72307_f.func_178788_d(new Vec3d((Vec3i)traceResult.func_178782_a()));
        return this.getAllQuads(state).stream().filter(quad -> quad.func_178210_d() == traceResult.field_178784_b).filter(quad -> this.checkDepth((BakedQuad)quad, vec, traceResult.field_178784_b)).map(BakedQuad::func_187508_a).collect(Collectors.toSet());
    }

    protected boolean checkDepth(BakedQuad quad, Vec3d hit, EnumFacing hitFace) {
        int[] quadData = quad.func_178209_a();
        VertexFormat format = quad.getFormat();
        int e = AbstractBakedPropertiesModel.getPositionElement(format);
        Vec3d posVec = new Vec3d(0.0, 0.0, 0.0);
        float[] pos = new float[4];
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])quadData, (float[])pos, (VertexFormat)format, (int)v, (int)e);
            posVec.func_178787_e(new Vec3d((double)pos[0], (double)pos[1], (double)pos[2]));
        }
        posVec = new Vec3d(posVec.field_72450_a / 4.0, posVec.field_72448_b / 4.0, posVec.field_72449_c / 4.0);
        double diff = 0.0;
        switch (hitFace.func_176740_k()) {
            case X: {
                diff = Math.abs(hit.field_72450_a - posVec.field_72450_a);
                break;
            }
            case Y: {
                diff = Math.abs(hit.field_72448_b - posVec.field_72448_b);
                break;
            }
            case Z: {
                diff = Math.abs(hit.field_72449_c - posVec.field_72449_c);
            }
        }
        return !(diff > 0.01);
    }

    @Override
    public Set<TextureAtlasSprite> getDestroyEffects(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getAllQuads(state).stream().map(BakedQuad::func_187508_a).collect(Collectors.toSet());
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.properties instanceof ModelProperties.PerspectiveProperties) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (IModelState)((ModelProperties.PerspectiveProperties)this.properties).getModelState(), (ItemCameraTransforms.TransformType)cameraTransformType);
        }
        return IModelParticleProvider.super.handlePerspective(cameraTransformType);
    }

    public static int getPositionElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (!format.func_177348_c(e).func_177374_g()) continue;
            return e;
        }
        return -1;
    }
}

