/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CharacterSprite
extends TextureAtlasSprite {
    private static final Map<Character, CharacterSprite> CHARCTER_SPRITE_CACHE = new HashMap<Character, CharacterSprite>();
    private static ResourceLocation FONT_TEXTURE;
    private final char character;

    private CharacterSprite(char character) {
        super("minechem:charsprite_" + String.valueOf(character) + "" + (Character.isUpperCase(character) ? "_upper" : ""));
        this.character = character;
        this.func_110966_b(16);
        this.func_110969_c(16);
    }

    public static final TextureAtlasSprite getSpriteForChar(char character) {
        if (!CHARCTER_SPRITE_CACHE.containsKey(Character.valueOf(character))) {
            CHARCTER_SPRITE_CACHE.put(Character.valueOf(character), new CharacterSprite(character));
        }
        return CHARCTER_SPRITE_CACHE.get(Character.valueOf(character));
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, final ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        int mp = Minecraft.func_71410_x().field_71474_y.field_151442_I + 1;
        BufferedImage[] ingot_image = new BufferedImage[mp];
        IResource charmap = null;
        BufferedImage charmap_image = null;
        Object sizeInfo = null;
        try {
            charmap = manager.func_110536_a(CharacterSprite.getFontTexture());
            charmap_image = ImageIO.read(charmap.func_110527_b());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (charmap == null || charmap_image == null) {
            return false;
        }
        int xPos = (Integer)this.getCharPos(this.character).getLeft();
        int yPos = (Integer)this.getCharPos(this.character).getRight();
        BufferedImage output_image = new BufferedImage(this.field_130223_c, this.field_130224_d, 6);
        int[] new_data = new int[64];
        for (int i = 0; i < this.field_130223_c; ++i) {
            for (int j = 0; j < this.field_130224_d; ++j) {
                int color = i >= 8 || j >= 8 ? 0 : charmap_image.getRGB(i + xPos, j + yPos);
                output_image.setRGB(i, j, color);
            }
        }
        ingot_image[0] = output_image;
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)output_image, "PNG", stream);
            final byte[] bytes = stream.toByteArray();
            this.func_188539_a(new IResource(){

                @Nonnull
                public ResourceLocation func_177241_a() {
                    return location;
                }

                @Nonnull
                public InputStream func_110527_b() {
                    return new ByteArrayInputStream(bytes);
                }

                public boolean func_110528_c() {
                    return false;
                }

                @Nullable
                public <T extends IMetadataSection> T func_110526_a(String sectionName) {
                    return null;
                }

                @Nonnull
                public String func_177240_d() {
                    return "minechem";
                }

                public void close() throws IOException {
                }
            }, mp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ResourceLocation getFontTexture() {
        if (FONT_TEXTURE == null) {
            FONT_TEXTURE = (ResourceLocation)ReflectionHelper.getPrivateValue(FontRenderer.class, (Object)Minecraft.func_71410_x().field_71466_p, (String[])new String[]{"locationFontTexture", "field_111273_g"});
        }
        return FONT_TEXTURE;
    }

    public Pair<Integer, Integer> getCharPos(char ch) {
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        return Pair.of((Object)(i % 16 * 8), (Object)(i / 16 * 8));
    }

    private static int getAlpha(int col) {
        return (col & 0xFF000000) >> 24;
    }

    private static int getRed(int col) {
        return (col & 0xFF0000) >> 16;
    }

    private static int getGreen(int col) {
        return (col & 0xFF00) >> 8;
    }

    private static int getBlue(int col) {
        return col & 0xFF;
    }

    private static int makeCol(int red, int green, int blue) {
        return CharacterSprite.makeCol(red, green, blue, 255);
    }

    private static int makeCol(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

