/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.Optional;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;

public class FontModelUtil {
    private static final EnumFacing[] HORIZONTALS = new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN};
    private static final EnumFacing[] VERTICALS = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private static final ResourceLocation FONT_TEXTURE = new ResourceLocation("minechem", "textures/models/font.png");

    public static ResourceLocation getFontTexture() {
        return FONT_TEXTURE;
    }

    public static ImmutableList<BakedQuad> getQuadsForChar(char ch, int tint, VertexFormat format, Optional<TRSRTransformation> transform) {
        return FontModelUtil.getQuadsForChar(ch, tint, FontModelUtil.getFontTexture(), format, transform);
    }

    public static ImmutableList<BakedQuad> getQuadsForChar(char ch, int tint, ResourceLocation sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        return FontModelUtil.getQuadsForChar(ch, tint, Minecraft.func_71410_x().func_147117_R().func_110572_b(sprite.toString()), format, transform);
    }

    public static ImmutableList<BakedQuad> getQuadsForChar(char ch, int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        int off;
        int off2;
        boolean face;
        boolean building;
        int u;
        int v;
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000".indexOf(ch);
        int uMax = i % 16 * 8;
        int vMax = i / 16 * 8;
        FaceData faceData = new FaceData(uMax, vMax);
        boolean translucent = false;
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] pixels = sprite.func_147965_a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u2 = 0; u2 < uMax; ++u2) {
                    boolean t;
                    int alpha = FontModelUtil.getAlpha(pixels, uMax, vMax, u2, v);
                    boolean bl = t = (float)alpha / 255.0f <= 0.1f;
                    if (!t && alpha < 255) {
                        translucent = true;
                    }
                    if (ptu && !t) {
                        faceData.set(EnumFacing.WEST, u2, v);
                    }
                    if (!ptu && t) {
                        faceData.set(EnumFacing.EAST, u2 - 1, v);
                    }
                    if (ptv[u2] && !t) {
                        faceData.set(EnumFacing.UP, u2, v);
                    }
                    if (!ptv[u2] && t) {
                        faceData.set(EnumFacing.DOWN, u2, v - 1);
                    }
                    ptu = t;
                    ptv[u2] = t;
                }
                if (ptu) continue;
                faceData.set(EnumFacing.EAST, uMax - 1, v);
            }
            for (u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                faceData.set(EnumFacing.DOWN, u, vMax - 1);
            }
        }
        for (EnumFacing facing : HORIZONTALS) {
            for (v = 0; v < vMax; ++v) {
                int uStart = 0;
                int uEnd = uMax;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            uStart = u3;
                        }
                        uEnd = u3 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == EnumFacing.DOWN ? 1 : 0;
                        builder.add((Object)FontModelUtil.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off2, u3 - uStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off = facing == EnumFacing.DOWN ? 1 : 0;
                builder.add((Object)FontModelUtil.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off, uEnd - uStart));
            }
        }
        for (EnumFacing facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                int vEnd = vMax;
                building = false;
                for (int v2 = 0; v2 < vMax; ++v2) {
                    face = faceData.get(facing, u, v2);
                    if (!translucent) {
                        if (!face) continue;
                        if (!building) {
                            building = true;
                            vStart = v2;
                        }
                        vEnd = v2 + 1;
                        continue;
                    }
                    if (building && !face) {
                        off2 = facing == EnumFacing.EAST ? 1 : 0;
                        builder.add((Object)FontModelUtil.buildSideQuad(format, transform, facing, tint, sprite, u + off2, vStart, v2 - vStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v2;
                }
                if (!building) continue;
                off = facing == EnumFacing.EAST ? 1 : 0;
                builder.add((Object)FontModelUtil.buildSideQuad(format, transform, facing, tint, sprite, u + off, vStart, vEnd - vStart));
            }
        }
        builder.add((Object)FontModelUtil.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)FontModelUtil.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        return builder.build();
    }

    private static int getAlpha(int[] pixels, int uMax, int vMax, int u, int v) {
        return pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF;
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v, int size) {
        float eps = 0.01f;
        int width = sprite.func_94211_a();
        int height = sprite.func_94216_b();
        float x0 = (float)u / (float)width;
        float y0 = (float)v / (float)height;
        float x1 = x0;
        float y1 = y0;
        float z0 = 0.46875f;
        float z1 = 0.53125f;
        switch (side) {
            case WEST: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case EAST: {
                y1 = (float)(v + size) / (float)height;
                break;
            }
            case DOWN: {
                z0 = 0.53125f;
                z1 = 0.46875f;
            }
            case UP: {
                x1 = (float)(u + size) / (float)width;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float dx = (float)side.func_176730_m().func_177958_n() * 0.01f / (float)width;
        float dy = (float)side.func_176730_m().func_177956_o() * 0.01f / (float)height;
        float u0 = 16.0f * (x0 - dx);
        float u1 = 16.0f * (x1 - dx);
        float v0 = 16.0f * (1.0f - y0 - dy);
        float v1 = 16.0f * (1.0f - y1 - dy);
        return FontModelUtil.buildQuad(format, transform, FontModelUtil.remap(side), sprite, tint, x0, y0, z0, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z0, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static EnumFacing remap(EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y ? side.func_176734_d() : side;
    }

    private static BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        FontModelUtil.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        FontModelUtil.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        FontModelUtil.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        FontModelUtil.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        transform.get().getMatrix().transform((Tuple4f)vec);
                        builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private static class FaceData {
        private final EnumMap<EnumFacing, BitSet> data = new EnumMap(EnumFacing.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(EnumFacing.WEST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.EAST, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.UP, new BitSet(uMax * vMax));
            this.data.put(EnumFacing.DOWN, new BitSet(uMax * vMax));
        }

        public void set(EnumFacing facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(EnumFacing facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }
}

