/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public interface ITransformFactory {
    public IModelState getModelState(JsonObject var1);

    public static interface IStandardTransformFactory
    extends ITransformFactory {
        @Override
        default public IModelState getModelState(JsonObject object) {
            HashMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
            TRSRTransformation thirdRh = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, "thirdperson_righthand");
            TRSRTransformation thirdLh = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, "thirdperson_lefthand");
            if (thirdLh == TRSRTransformation.identity()) {
                thirdLh = thirdRh;
            }
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdRh);
            map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, thirdLh);
            TRSRTransformation firstRh = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, "firstperson_righthand");
            TRSRTransformation firstLh = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, "firstperson_lefthand");
            if (firstLh == TRSRTransformation.identity()) {
                firstLh = firstRh;
            }
            map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstRh);
            map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, firstLh);
            TRSRTransformation head = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.HEAD, "firstperson_lefthand");
            TRSRTransformation gui = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.GUI, "firstperson_lefthand");
            TRSRTransformation ground = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.GROUND, "firstperson_lefthand");
            TRSRTransformation fixed = IStandardTransformFactory.load(this, object, ItemCameraTransforms.TransformType.FIXED, "firstperson_lefthand");
            map.put(ItemCameraTransforms.TransformType.HEAD, head);
            map.put(ItemCameraTransforms.TransformType.GUI, gui);
            map.put(ItemCameraTransforms.TransformType.GROUND, ground);
            map.put(ItemCameraTransforms.TransformType.FIXED, fixed);
            return part -> Optional.ofNullable(map.get(part.get()));
        }

        public TRSRTransformation getTransform(ItemCameraTransforms.TransformType var1, JsonObject var2);

        public static TRSRTransformation load(IStandardTransformFactory me, JsonObject object, ItemCameraTransforms.TransformType type, String name) {
            if (object.has(name)) {
                return me.getTransform(type, object.getAsJsonObject(name));
            }
            return TRSRTransformation.identity();
        }
    }
}

