/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.vecmath.Vector3f;
import minechem.client.model.generated.ITransformFactory;
import minechem.client.model.generated.Matrix4;
import minechem.client.model.generated.Vector3;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.ModContainer;

public class Transforms {
    private static final TRSRTransformation flipX = new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();
    private static Map<ResourceLocation, ITransformFactory> transformFactories = new HashMap<ResourceLocation, ITransformFactory>();
    public static final IModelState DEFAULT_BLOCK;
    public static final IModelState DEFAULT_ITEM;
    public static final IModelState DEFAULT_TOOL;
    public static final IModelState DEFAULT_BOW;
    public static final IModelState DEFAULT_HANDHELD_ROD;

    public static TRSRTransformation create(float tx, float ty, float tz, float rx, float ry, float rz, float s) {
        return Transforms.create(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Vector3f(rx, ry, rz), new Vector3f(s, s, s));
    }

    public static TRSRTransformation create(Vector3 transform, Vector3 rotation, Vector3 scale) {
        return Transforms.create(transform.vector3f(), rotation.vector3f(), scale.vector3f());
    }

    public static TRSRTransformation create(Vector3f transform, Vector3f rotation, Vector3f scale) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(transform, TRSRTransformation.quatFromXYZDegrees((Vector3f)rotation), scale, null));
    }

    public static TRSRTransformation flipLeft(TRSRTransformation transform) {
        return TRSRTransformation.blockCenterToCorner((TRSRTransformation)flipX.compose(TRSRTransformation.blockCornerToCenter((TRSRTransformation)transform)).compose(flipX));
    }

    public static void loadTransformFactory(ModContainer mod, JsonObject transforms) {
        for (Map.Entry entry : transforms.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                String key = (String)entry.getKey();
                String value = ((JsonElement)entry.getValue()).getAsString();
                try {
                    Class<?> clazz = Class.forName(value);
                    if (ITransformFactory.class.isAssignableFrom(clazz)) {
                        Transforms.registerTransformFactory(new ResourceLocation(mod.getModId(), key), (ITransformFactory)clazz.newInstance());
                        continue;
                    }
                    throw new JsonSyntaxException("Class '" + value + "' is not an instance of ITransformFactory");
                }
                catch (ClassNotFoundException e) {
                    throw new JsonSyntaxException("Could not find class: '" + value + "'!", (Throwable)e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new JsonSyntaxException("Could not instantiate '" + value + "'!", (Throwable)e);
                }
            }
            throw new JsonParseException("transforms: Entry is expected to be a string and is not.. " + entry.getValue());
        }
    }

    public static void registerTransformFactory(ResourceLocation type, ITransformFactory factory) {
        if (transformFactories.containsKey(type)) {
            // empty if block
        }
        transformFactories.put(type, factory);
    }

    public static ITransformFactory getTransformFactory(ResourceLocation type) {
        if (!transformFactories.containsKey(type)) {
            throw new IllegalArgumentException(String.format("Unable to get TransformFactory for unregistered type{%s}!", type));
        }
        return transformFactories.get(type);
    }

    public static void registerDefaultFactories() {
        Transforms.registerTransformFactory(new ResourceLocation("minecraft:default"), new ITransformFactory.IStandardTransformFactory(){

            @Override
            public TRSRTransformation getTransform(ItemCameraTransforms.TransformType type, JsonObject object) {
                Vector3 rot = this.parseVec3(object, "rotation", Vector3.zero.copy());
                Vector3 trans = this.parseVec3(object, "translation", Vector3.zero.copy());
                trans.multiply(0.0625);
                trans.x = Transforms.clip(trans.x, -5.0, 5.0);
                trans.y = Transforms.clip(trans.y, -5.0, 5.0);
                trans.z = Transforms.clip(trans.z, -5.0, 5.0);
                Vector3 scale = this.parseVec3(object, "scale", Vector3.one);
                scale.x = Transforms.clip(scale.x, -4.0, 4.0);
                scale.y = Transforms.clip(scale.y, -4.0, 4.0);
                scale.z = Transforms.clip(scale.z, -4.0, 4.0);
                return Transforms.create(trans, rot, scale);
            }

            private Vector3 parseVec3(JsonObject object, String key, Vector3 defaultValue) {
                if (object.has(key)) {
                    JsonArray array = JsonUtils.func_151214_t((JsonObject)object, (String)key);
                    if (array.size() == 3) {
                        float[] floats = new float[3];
                        for (int i = 0; i < 3; ++i) {
                            floats[i] = JsonUtils.func_151220_d((JsonElement)array.get(i), (String)(key + "[ " + i + " ]"));
                        }
                        return new Vector3(floats);
                    }
                    throw new JsonParseException("Expected 3 " + key + " values, found: " + array.size());
                }
                return defaultValue;
            }
        });
    }

    public static double clip(double value, double min, double max) {
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<IModelState> parseFromJson(JsonObject json) {
        int y;
        int x;
        Object rot;
        Optional<Object> ret = Optional.empty();
        if ((json.has("x") || json.has("y")) && !(ret = Optional.of(new TRSRTransformation((ModelRotation)(rot = ModelRotation.func_177524_a((int)(x = JsonUtils.func_151208_a((JsonObject)json, (String)"x", (int)0)), (int)(y = JsonUtils.func_151208_a((JsonObject)json, (String)"y", (int)0))))))).isPresent()) {
            throw new JsonParseException("Invalid BlockModelRotation x: " + x + " y: " + y);
        }
        if (!json.has("transform")) return ret;
        JsonElement transformElement = json.get("transform");
        if (transformElement.isJsonPrimitive() && transformElement.getAsJsonPrimitive().isString()) {
            String transform = transformElement.getAsString();
            switch (transform) {
                case "identity": {
                    return Optional.of(TRSRTransformation.identity());
                }
                case "ccl:default-block": {
                    return Optional.of(DEFAULT_BLOCK);
                }
                case "ccl:default-item": {
                    return Optional.of(DEFAULT_ITEM);
                }
                case "ccl:default-tool": {
                    return Optional.of(DEFAULT_TOOL);
                }
                case "ccl:default-bow": {
                    return Optional.of(DEFAULT_BOW);
                }
                case "ccl:default-handheld-rod": {
                    return Optional.of(DEFAULT_HANDHELD_ROD);
                }
            }
            return ret;
        } else {
            void var7_19;
            TRSRTransformation t;
            if (!transformElement.isJsonObject()) {
                try {
                    TRSRTransformation base = (TRSRTransformation)GSON.fromJson(transformElement, TRSRTransformation.class);
                    return Optional.of(TRSRTransformation.blockCenterToCorner((TRSRTransformation)base));
                }
                catch (JsonParseException e) {
                    throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformElement);
                }
            }
            JsonObject transform = transformElement.getAsJsonObject();
            if (transform.has("type")) {
                JsonElement typeElement = transform.get("type");
                if (!typeElement.isJsonPrimitive()) throw new JsonParseException("type: expected as string but was not a string. got: " + typeElement);
                if (!typeElement.getAsJsonPrimitive().isString()) throw new JsonParseException("type: expected as string but was not a string. got: " + typeElement);
                ResourceLocation type = new ResourceLocation(typeElement.getAsString());
                try {
                    ITransformFactory factory = Transforms.getTransformFactory(type);
                    return Optional.of(factory.getModelState(transform));
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("Unregistered type!" + type, (Throwable)e);
                }
            }
            EnumMap transforms = Maps.newEnumMap(ItemCameraTransforms.TransformType.class);
            if (transform.has("thirdperson")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson"), TRSRTransformation.class);
                transform.remove("thirdperson");
                transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("thirdperson_righthand")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson_righthand"), TRSRTransformation.class);
                transform.remove("thirdperson_righthand");
                transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("thirdperson_lefthand")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("thirdperson_lefthand"), TRSRTransformation.class);
                transform.remove("thirdperson_lefthand");
                transforms.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("firstperson")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson"), TRSRTransformation.class);
                transform.remove("firstperson");
                transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("firstperson_righthand")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson_righthand"), TRSRTransformation.class);
                transform.remove("firstperson_righthand");
                transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("firstperson_lefthand")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("firstperson_lefthand"), TRSRTransformation.class);
                transform.remove("firstperson_lefthand");
                transforms.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("head")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("head"), TRSRTransformation.class);
                transform.remove("head");
                transforms.put(ItemCameraTransforms.TransformType.HEAD, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("gui")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("gui"), TRSRTransformation.class);
                transform.remove("gui");
                transforms.put(ItemCameraTransforms.TransformType.GUI, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("ground")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("ground"), TRSRTransformation.class);
                transform.remove("ground");
                transforms.put(ItemCameraTransforms.TransformType.GROUND, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            if (transform.has("fixed")) {
                t = (TRSRTransformation)GSON.fromJson(transform.get("fixed"), TRSRTransformation.class);
                transform.remove("fixed");
                transforms.put(ItemCameraTransforms.TransformType.FIXED, TRSRTransformation.blockCenterToCorner((TRSRTransformation)t));
            }
            int k = transform.entrySet().size();
            if (transform.has("matrix")) {
                --k;
            }
            if (transform.has("translation")) {
                --k;
            }
            if (transform.has("rotation")) {
                --k;
            }
            if (transform.has("scale")) {
                --k;
            }
            if (transform.has("post-rotation")) {
                --k;
            }
            if (k > 0) {
                throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation'");
            }
            TRSRTransformation base = TRSRTransformation.identity();
            if (!transform.entrySet().isEmpty()) {
                base = (TRSRTransformation)GSON.fromJson((JsonElement)transform, TRSRTransformation.class);
                base = TRSRTransformation.blockCenterToCorner((TRSRTransformation)base);
            }
            if (transforms.isEmpty()) {
                TRSRTransformation tRSRTransformation = base;
                return Optional.of(var7_19);
            } else {
                IModelState iModelState = part -> {
                    ImmutableMap map = Maps.immutableEnumMap((Map)transforms);
                    if (!(part.isPresent() && part.get() instanceof ItemCameraTransforms.TransformType && map.containsKey(part.get()))) {
                        TRSRTransformation base2 = TRSRTransformation.identity();
                        if (!transform.entrySet().isEmpty()) {
                            base2 = (TRSRTransformation)GSON.fromJson((JsonElement)transform, TRSRTransformation.class);
                            base2 = TRSRTransformation.blockCenterToCorner((TRSRTransformation)base2);
                        }
                        return Optional.of(base2);
                    }
                    return Optional.ofNullable(map.get(part.get()));
                };
            }
            return Optional.of(var7_19);
        }
    }

    public static TRSRTransformation fromMatrix4(Matrix4 matrix4) {
        return new TRSRTransformation(matrix4.toMatrix4f());
    }

    static {
        HashMap<ItemCameraTransforms.TransformType, TRSRTransformation> map = new HashMap<ItemCameraTransforms.TransformType, TRSRTransformation>();
        TRSRTransformation thirdPerson = Transforms.create(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        map.put(ItemCameraTransforms.TransformType.GUI, Transforms.create(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        map.put(ItemCameraTransforms.TransformType.GROUND, Transforms.create(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        map.put(ItemCameraTransforms.TransformType.FIXED, Transforms.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.create(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.create(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        DEFAULT_BLOCK = part -> null;
        map = new HashMap();
        thirdPerson = Transforms.create(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TRSRTransformation firstPerson = Transforms.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        map.put(ItemCameraTransforms.TransformType.GROUND, Transforms.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.HEAD, Transforms.create(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, thirdPerson);
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.flipLeft(thirdPerson));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, firstPerson);
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.flipLeft(firstPerson));
        DEFAULT_ITEM = part -> null;
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, Transforms.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, Transforms.create(0.0f, 4.0f, 0.5f, 0.0f, -90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.create(0.0f, 4.0f, 0.5f, 0.0f, 90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_TOOL = part -> null;
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, Transforms.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, Transforms.create(-1.0f, -2.0f, 2.5f, -80.0f, 260.0f, -40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.create(-1.0f, -2.0f, 2.5f, -80.0f, -280.0f, 40.0f, 0.9f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.create(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.create(1.13f, 3.2f, 1.13f, 0.0f, 90.0f, -25.0f, 0.68f));
        DEFAULT_BOW = part -> null;
        map = new HashMap();
        map.put(ItemCameraTransforms.TransformType.GROUND, Transforms.create(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, Transforms.create(0.0f, 4.0f, 2.5f, 0.0f, 90.0f, 55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, Transforms.create(0.0f, 4.0f, 2.5f, 0.0f, -90.0f, -55.0f, 0.85f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, Transforms.create(0.0f, 1.6f, 0.8f, 0.0f, 90.0f, 25.0f, 0.68f));
        map.put(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, Transforms.create(0.0f, 1.6f, 0.8f, 0.0f, -90.0f, -25.0f, 0.68f));
        DEFAULT_HANDHELD_ROD = part -> null;
        Transforms.registerDefaultFactories();
    }
}

