/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.render;

import com.google.common.collect.Maps;
import java.util.Map;
import minechem.block.tile.TileDecomposer;
import minechem.client.model.ModelDecomposer;
import minechem.init.ModGlobals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class RenderDecomposer
extends TileEntitySpecialRenderer<TileDecomposer> {
    private static final Map<BlockPos, ModelDecomposer> MODELREGISTRY = Maps.newHashMap();
    ModelDecomposer model = new ModelDecomposer();

    public void render(TileDecomposer tileEntity, double x, double y, double z, float var8, int var9, float alpha) {
        TileDecomposer decomposer = tileEntity;
        this.model = this.getModelForTile(decomposer.func_174877_v());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        boolean isRunning = decomposer.isCooking() && decomposer.getState() != TileDecomposer.State.jammed;
        this.func_147499_a(isRunning ? ModGlobals.ModResources.Model.DECOMPOSER_ON : ModGlobals.ModResources.Model.DECOMPOSER_OFF);
        if (isRunning) {
            this.model.updateWindillRotation();
        }
        this.model.render(0.0625f);
        GlStateManager.func_179121_F();
    }

    public ModelDecomposer getModelForTile(BlockPos pos) {
        if (!MODELREGISTRY.containsKey(pos)) {
            MODELREGISTRY.put(pos, new ModelDecomposer());
        }
        return MODELREGISTRY.get(pos);
    }

    public static class ItemRenderDecomposer
    extends TileEntityItemStackRenderer {
        ModelDecomposer model = new ModelDecomposer();

        public void func_192838_a(ItemStack stack, float partialTicks) {
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)0.5, (double)1.5, (double)0.5);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Model.DECOMPOSER_ON);
            this.model.updateWindillRotation();
            this.model.render(0.0625f);
            GlStateManager.func_179137_b((double)-0.5, (double)-1.5, (double)-0.5);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
    }
}

