/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.render;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import minechem.client.model.generated.CharacterSprite;
import minechem.client.render.ILayer;
import minechem.utils.RenderUtil;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.common.model.TRSRTransformation;
import org.lwjgl.opengl.GL11;

public class TextLayer
implements ILayer {
    private static final Map<String, List<BakedQuad>> STRING_QUAD_CACHE = new HashMap<String, List<BakedQuad>>();
    private final String text;

    public TextLayer(String text) {
        this.text = text;
    }

    @Override
    public void render(int colour) {
        float scale = 0.3f;
        RenderHelper.func_74518_a();
        GL11.glShadeModel((int)7424);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(scale / scale + scale / scale + 0.25f), (float)0.0f);
        RenderUtil.renderQuads(TextLayer.getQuadsForString(this.text), 1.0f);
        GlStateManager.func_179152_a((float)(-scale * scale), (float)(-scale * scale), (float)(-scale * scale));
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    public static List<BakedQuad> getQuadsForString(String str) {
        char[] chars = str.toCharArray();
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            sprites[i] = CharacterSprite.getSpriteForChar(chars[i]);
        }
        STRING_QUAD_CACHE.put(str, (List<BakedQuad>)RenderUtil.getQuadsForSprites(DefaultVertexFormats.field_176599_b, Optional.of(TRSRTransformation.identity()), sprites));
        return STRING_QUAD_CACHE.get(str);
    }
}

