/*
 * Decompiled with CFR 0.152.
 */
package minechem.container;

import java.util.ArrayList;
import java.util.List;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.block.tile.TileDecomposer;
import minechem.inventory.slot.SlotOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerDecomposer
extends Container
implements IRadiationShield,
INoDecay {
    protected TileDecomposer decomposer;
    protected final int kPlayerInventorySlotStart;
    protected final int kPlayerInventorySlotEnd;
    protected final int kDecomposerInventoryEnd;
    private InventoryPlayer playerInventory;

    public ContainerDecomposer(InventoryPlayer inventoryPlayer, TileDecomposer decomposer) {
        this.decomposer = decomposer;
        this.playerInventory = inventoryPlayer;
        this.kPlayerInventorySlotStart = decomposer.func_70302_i_();
        this.kPlayerInventorySlotEnd = this.kPlayerInventorySlotStart + 36;
        this.kDecomposerInventoryEnd = decomposer.func_70302_i_();
        this.func_75146_a(new Slot(decomposer, 0, 80, 16){});
        this.bindOutputSlots();
        this.bindPlayerInventory(inventoryPlayer);
    }

    private void bindOutputSlots() {
        int x = 8;
        int y = 62;
        int slot = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotOutput(this.decomposer, 1 + slot, x + j * 18, y + i * 18));
                ++slot;
            }
        }
    }

    private void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 102 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 160));
        }
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slot) {
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        ItemStack stack = ItemStack.field_190927_a;
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot < this.kDecomposerInventoryEnd) {
                if (!this.func_75135_a(stackInSlot, this.kPlayerInventorySlotStart, this.field_75151_b.size(), true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (this.decomposer.func_94041_b(0, stackInSlot) && !this.func_75135_a(stackInSlot, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (slot < 37 && stackInSlot.func_190916_E() == stack.func_190916_E() && !this.func_75135_a(stackInSlot, 37, 46, false)) {
                    return ItemStack.field_190927_a;
                }
                if (slot > 36 && stackInSlot.func_190916_E() == stack.func_190916_E() && !this.func_75135_a(stackInSlot, 10, 37, false)) {
                    return ItemStack.field_190927_a;
                }
            }
            if (stackInSlot.func_190916_E() == 0) {
                slotObject.func_75215_d(ItemStack.field_190927_a);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slotObject.func_190901_a(entityPlayer, stackInSlot);
        }
        return stack;
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        return 0.4f;
    }

    @Override
    public List<ItemStack> getStorageInventory() {
        ArrayList<ItemStack> storageInventory = new ArrayList<ItemStack>();
        for (int slot : TileDecomposer.outputSlots) {
            ItemStack stack = this.func_75139_a(slot).func_75211_c();
            if (stack.func_190926_b()) continue;
            storageInventory.add(stack);
        }
        return storageInventory;
    }

    @Override
    public List<ItemStack> getPlayerInventory() {
        ArrayList<ItemStack> playerInventoryStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.playerInventory.func_70302_i_(); ++i) {
            playerInventoryStacks.add(this.playerInventory.func_70301_a(i));
        }
        return playerInventoryStacks;
    }
}

