/*
 * Decompiled with CFR 0.152.
 */
package minechem.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import minechem.init.ModFluids;
import minechem.init.ModItems;
import minechem.item.ItemBase;
import minechem.item.ItemElement;
import minechem.item.ItemMolecule;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HandlerMoleculeDecay {
    private static HandlerMoleculeDecay instance = null;
    private final Map<MoleculeEnum, PotionChemical[]> decayedMoleculesPre;
    private final Map<MoleculeEnum, PotionChemical[]> decayedMoleculesCache = new WeakHashMap<MoleculeEnum, PotionChemical[]>();

    public static HandlerMoleculeDecay getInstance() {
        if (instance == null) {
            instance = new HandlerMoleculeDecay();
        }
        return instance;
    }

    private HandlerMoleculeDecay() {
        this.decayedMoleculesPre = new WeakHashMap<MoleculeEnum, PotionChemical[]>();
        this.initDecayedMoleculesPre();
    }

    public RadiationUtil handleRadiationMoleculeBucket(World world, @Nonnull ItemStack itemStack, IInventory inventory, double x, double y, double z) {
        PotionChemical[] decayedChemicals = this.getDecayedMolecule((MoleculeEnum)MinechemUtil.getChemicalTypeFromBucket(itemStack));
        for (int i = 0; i < decayedChemicals.length; ++i) {
            decayedChemicals[i].amount *= 8 * itemStack.func_190916_E();
        }
        ItemStack[] items = this.toItemStacks(decayedChemicals);
        for (int i = 1; i < items.length; ++i) {
            ItemStack stack = MinechemUtil.addItemToInventory(inventory, items[i]);
            if (stack.func_190926_b()) continue;
            MinechemUtil.throwItemStack(world, itemStack, x, y, z);
        }
        Item item = items[0].func_77973_b();
        if (item instanceof ItemMolecule) {
            itemStack = MinechemUtil.getBucketForFluid(ModFluids.FLUID_MOLECULES.get(MinechemUtil.getMolecule(items[0])));
        } else if (item instanceof ItemElement) {
            itemStack = MinechemUtil.getBucketForFluid(ModFluids.FLUID_ELEMENTS.get(MinechemUtil.getElement(items[0])));
        }
        itemStack.func_190920_e(items[0].func_190916_E() / 8);
        itemStack.func_77982_d(items[0].func_77978_p());
        return ItemElement.initiateRadioactivity(itemStack, world);
    }

    public RadiationUtil handleRadiationMolecule(World world, ItemStack itemStack, IInventory inventory, double x, double y, double z) {
        PotionChemical[] decayedChemicals = this.getDecayedMolecule(MinechemUtil.getMolecule(itemStack));
        for (int i = 0; i < decayedChemicals.length; ++i) {
            decayedChemicals[i].amount *= itemStack.func_190916_E();
        }
        ItemStack[] items = this.toItemStacks(decayedChemicals);
        for (int i = 1; i < items.length; ++i) {
            ItemStack stack = MinechemUtil.addItemToInventory(inventory, items[i]);
            if (stack.func_190926_b()) continue;
            MinechemUtil.throwItemStack(world, itemStack, x, y, z);
        }
        itemStack = new ItemStack(items[0].func_77973_b(), items[0].func_190916_E(), items[0].func_77952_i());
        itemStack.func_77982_d(items[0].func_77978_p());
        return ItemElement.initiateRadioactivity(itemStack, world);
    }

    private void initDecayedMoleculesPre() {
    }

    private PotionChemical[] getDecayedMolecule(MoleculeEnum molecule) {
        PotionChemical[] chemicals = this.decayedMoleculesPre.get(molecule);
        if (chemicals != null) {
            return this.copyOf(chemicals);
        }
        chemicals = this.decayedMoleculesCache.get(molecule);
        if (chemicals == null) {
            Set<PotionChemical> potionChemicalsSet = this.computDecayMolecule(molecule);
            chemicals = potionChemicalsSet.toArray(new PotionChemical[potionChemicalsSet.size()]);
            this.decayedMoleculesCache.put(molecule, chemicals);
        }
        return this.copyOf(chemicals);
    }

    private ItemStack[] toItemStacks(PotionChemical[] chemicalsArray) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        ArrayList<PotionChemical> chemicals = new ArrayList<PotionChemical>(chemicalsArray.length);
        for (PotionChemical element : chemicalsArray) {
            chemicals.add(element);
        }
        while (!chemicals.isEmpty()) {
            int thisDamage;
            ItemBase thisType;
            int index = chemicals.size() - 1;
            PotionChemical chemical = (PotionChemical)chemicals.remove(index);
            if (chemical instanceof Element) {
                thisType = ModItems.element;
                thisDamage = ((Element)chemical).element.atomicNumber();
            } else {
                if (!(chemical instanceof Molecule)) continue;
                thisType = ModItems.molecule;
                thisDamage = ((Molecule)chemical).molecule.id();
            }
            for (int l = 0; l < itemStacks.size() && chemical.amount > 0; ++l) {
                ItemStack stack = (ItemStack)itemStacks.get(l);
                if (stack.func_77973_b() != thisType || stack.func_77952_i() != thisDamage) continue;
                int freeSpace = 64 - stack.func_190916_E();
                int append = freeSpace > chemical.amount ? chemical.amount : freeSpace;
                chemical.amount -= append;
                stack.func_190917_f(append);
            }
            if (chemical.amount <= 0) continue;
            itemStacks.add(new ItemStack((Item)thisType, chemical.amount, thisDamage));
        }
        return itemStacks.toArray(new ItemStack[itemStacks.size()]);
    }

    private Set<PotionChemical> computDecayMolecule(MoleculeEnum molecule) {
        ArrayList<PotionChemical> chemicals = molecule.components();
        HashSet<PotionChemical> outChemicals = new HashSet<PotionChemical>();
        if (molecule.radioactivity() == RadiationEnum.stable) {
            outChemicals.add(new Molecule(molecule));
            return outChemicals;
        }
        for (PotionChemical chemical1 : chemicals) {
            PotionChemical chemical = chemical1.copy();
            if (chemical instanceof Element) {
                Element element = (Element)chemical;
                if (element.element.radioactivity() != RadiationEnum.stable) {
                    element.element = ElementEnum.getByID(element.element.atomicNumber() - 1);
                }
            } else if (chemical instanceof Molecule) {
                Molecule molecule2 = (Molecule)chemical;
                if (molecule2.molecule.radioactivity() != RadiationEnum.stable) {
                    PotionChemical[] chemicals2 = this.getDecayedMolecule(molecule2.molecule);
                    Collections.addAll(outChemicals, chemicals2);
                    chemical = null;
                }
            }
            if (chemical == null) continue;
            outChemicals.add(chemical);
        }
        return outChemicals;
    }

    private PotionChemical[] copyOf(PotionChemical[] a) {
        PotionChemical[] b = new PotionChemical[a.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = a[i].clone();
        }
        return b;
    }
}

