/*
 * Decompiled with CFR 0.152.
 */
package minechem.handler.oredict;

import java.util.Arrays;
import java.util.List;
import minechem.api.IOreDictionaryHandler;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.recipe.RecipeDecomposer;

public class OreDictionaryExtraUtilitiesHandler
implements IOreDictionaryHandler {
    private static final int BURNT_QUARTZ = 0;
    private static final int ICE_STONE = 1;
    private String[] blockTypes = new String[]{"burntquartz", "icestone"};
    private List<String> blockList = Arrays.asList(this.blockTypes);

    @Override
    public boolean canHandle(String oreName) {
        return this.blockList.contains(oreName);
    }

    @Override
    public void handle(String oreName) {
        switch (this.blockList.indexOf(oreName)) {
            case 0: {
                RecipeDecomposer.addOreDictRecipe(oreName, new Molecule(MoleculeEnum.siliconDioxide, 4), new Molecule(MoleculeEnum.arsenicOxide, 1), new Molecule(MoleculeEnum.galliumOxide, 1));
            }
            case 1: {
                RecipeDecomposer.addOreDictRecipe(oreName, new Molecule(MoleculeEnum.water, 4));
            }
        }
    }
}

