/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModConfig {
    public static Configuration config;
    public static boolean generateOre;
    public static int UraniumOreClusterSize;
    public static int UraniumOreDensity;
    public static boolean DebugMode;
    public static int UpdateRadius;
    public static boolean AllowAutomation;
    public static int halfLifeMultiplier;
    public static int recursiveDepth;
    public static boolean advancedTurtleAI;
    public static boolean vialPlacing;
    public static boolean FoodSpiking;
    public static boolean SwordEffects;
    public static boolean fluidEffects;
    public static boolean decaySafeMachines;
    public static boolean recreationalChemicalEffects;
    public static boolean powerUseEnabled;
    public static int costDecomposition;
    public static int synthesisMultiplier;
    public static int fusionMultiplier;
    public static int fissionMultiplier;
    public static int energyPacketSize;
    public static int maxSynthesizerStorage;
    public static int maxDecomposerStorage;
    public static int maxFissionStorage;
    public static int maxFusionStorage;
    public static boolean reactionItemMeetFluid;
    public static boolean reactionFluidMeetFluid;
    public static boolean enableWaterBucketIntoH2ORecipe;
    public static boolean supportNEI;
    public static String[] DecomposerBlacklist;
    public static String[] SynthesisMachineBlacklist;
    public static NonNullList<ItemStack> decomposerBlacklist;
    public static NonNullList<ItemStack> synthesisBlacklist;
    public static int[] worldGenDimWhitelist;
    public static boolean displayMoleculeEffects;
    public static boolean decomposeChemicalFluids;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ModConfig.loadConfig();
        }
    }

    public static void loadConfig() {
        ArrayList<String> configList = new ArrayList<String>();
        LanguageMap languageMap = new LanguageMap();
        config.addCustomCategoryComment("worldgen", languageMap.func_74805_b("config.worldgen.description"));
        config.addCustomCategoryComment("blacklist", languageMap.func_74805_b("config.blacklist.description"));
        config.addCustomCategoryComment("power", languageMap.func_74805_b("config.power.description"));
        config.addCustomCategoryComment("general", languageMap.func_74805_b("config.general.description"));
        Property prop = config.get("general", "displayMoleculeEffects", displayMoleculeEffects);
        prop.setComment(languageMap.func_74805_b("config.moleculeEffects.description"));
        prop.setLanguageKey("config.moleculeEffects.name");
        displayMoleculeEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("worldgen", "generateOre", generateOre);
        prop.setComment(languageMap.func_74805_b("config.worldgen.ore.description"));
        prop.setLanguageKey("config.worldgen.ore.tooltip");
        generateOre = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("worldgen", "uraniumOreClusterSize", UraniumOreClusterSize);
        prop.setMinValue(1).setMaxValue(10);
        prop.setComment(languageMap.func_74805_b("config.uraniumoreclustersize.description"));
        prop.setLanguageKey("config.uraniumoreclustersize");
        UraniumOreClusterSize = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("worldgen", "DimensionWHitelistForWorldGen", worldGenDimWhitelist);
        prop.setComment(languageMap.func_74805_b("config.worldgen.dimwhitelist.description"));
        prop.setLanguageKey("config.worldgen.dimwhitelist.tooltip");
        worldGenDimWhitelist = prop.getIntList();
        configList.add(prop.getName());
        prop = config.get("worldgen", "uraniumoredensity", UraniumOreDensity);
        prop.setMinValue(1).setMaxValue(64);
        prop.setComment(languageMap.func_74805_b("config.uraniumoredensity.description"));
        prop.setLanguageKey("config.uraniumoredensity");
        UraniumOreDensity = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "debugMode", DebugMode);
        prop.setComment(languageMap.func_74805_b("config.debugmode.description"));
        prop.setLanguageKey("config.debugmode");
        DebugMode = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "advancedTurtleAI", advancedTurtleAI);
        prop.setComment(languageMap.func_74805_b("config.advancedTurtleAI.description"));
        prop.setLanguageKey("config.advancedTurtleAI.name");
        advancedTurtleAI = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "updateRadius", UpdateRadius);
        prop.setMinValue(1).setMaxValue(50);
        prop.setComment(languageMap.func_74805_b("config.updateradius.description"));
        prop.setLanguageKey("config.updateradius");
        UpdateRadius = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "allowAutomation", AllowAutomation);
        prop.setComment(languageMap.func_74805_b("config.allowautomation.description"));
        prop.setLanguageKey("config.allowautomation");
        AllowAutomation = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "vialPlacing", vialPlacing);
        prop.setComment(languageMap.func_74805_b("config.vialplacing.description"));
        prop.setLanguageKey("config.vialplacing");
        vialPlacing = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "foodSpiking", FoodSpiking);
        prop.setComment(languageMap.func_74805_b("config.foodspiking.description"));
        prop.setLanguageKey("config.foodspiking");
        FoodSpiking = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "swordEffects", SwordEffects);
        prop.setComment(languageMap.func_74805_b("config.swordeffects.description"));
        prop.setLanguageKey("config.swordeffects");
        SwordEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "halfLifeMultiplier", UpdateRadius);
        prop.setMinValue(1).setMaxValue(200);
        prop.setComment(languageMap.func_74805_b("config.halfLifeMultiplier.description"));
        prop.setLanguageKey("config.halfLifeMultiplier.name");
        halfLifeMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "recursiveDepth", recursiveDepth);
        prop.setMinValue(3).setMaxValue(20).requiresMcRestart();
        prop.setComment(languageMap.func_74805_b("config.recursiveDepth.description"));
        prop.setLanguageKey("config.recursiveDepth.name");
        recursiveDepth = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("general", "decaySafeMachines", SwordEffects);
        prop.setComment(languageMap.func_74805_b("config.decaySafeMachines.description"));
        prop.setLanguageKey("config.decaySafeMachines.name");
        decaySafeMachines = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "recreationalChemicalEffects", recreationalChemicalEffects);
        prop.setComment(languageMap.func_74805_b("config.recreationalChemicalEffects.description"));
        prop.setLanguageKey("config.recreationalChemicalEffects");
        recreationalChemicalEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "fluidEffects", SwordEffects);
        prop.setComment(languageMap.func_74805_b("config.fluideffects.description"));
        prop.setLanguageKey("config.fluideffects.name");
        fluidEffects = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "reactionItemMeetFluid", reactionItemMeetFluid);
        prop.setComment(languageMap.func_74805_b("config.reactionItemMeetFluid.description"));
        prop.setLanguageKey("config.reactionItemMeetFluid");
        reactionItemMeetFluid = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "reactionFluidMeetFluid", reactionFluidMeetFluid);
        prop.setComment(languageMap.func_74805_b("config.reactionFluidMeetFluid.description"));
        prop.setLanguageKey("config.reactionFluidMeetFluid");
        reactionFluidMeetFluid = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "supportNEI", reactionFluidMeetFluid);
        prop.setComment(languageMap.func_74805_b("config.supportNEI.description"));
        prop.setLanguageKey("config.supportNEI.name");
        supportNEI = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("general", "enableWaterBucketIntoH2ORecipe", enableWaterBucketIntoH2ORecipe);
        prop.setComment(languageMap.func_74805_b("config.enableWaterBucketIntoH2ORecipe.description"));
        prop.setLanguageKey("config.enableWaterBucketIntoH2ORecipe.name");
        enableWaterBucketIntoH2ORecipe = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("blacklist", "decomposition", new String[]{"minecraft:dirt"});
        prop.setLanguageKey("config.blacklist.decomposition.tooltip").setRequiresMcRestart(true);
        prop.setComment(languageMap.func_74805_b("config.blacklist.decomposition.example"));
        DecomposerBlacklist = prop.getStringList();
        configList.add(prop.getName());
        prop = config.get("blacklist", "synthesis", new String[]{"minecraft:diamond", "ore:ore*", "*:dragon_egg"});
        prop.setLanguageKey("config.blacklist.synthesis.tooltip").setRequiresMcRestart(true);
        prop.setComment(languageMap.func_74805_b("config.blacklist.synthesis.example"));
        SynthesisMachineBlacklist = prop.getStringList();
        configList.add(prop.getName());
        prop = config.get("power", "enable", powerUseEnabled);
        prop.setComment(languageMap.func_74805_b("config.power.enable.description"));
        prop.setLanguageKey("config.power.enable.name").setRequiresMcRestart(true);
        powerUseEnabled = prop.getBoolean();
        configList.add(prop.getName());
        prop = config.get("power", "maxDecomposerStorage", maxDecomposerStorage);
        prop.setComment(languageMap.func_74805_b("config.power.decomposer.max.description"));
        prop.setLanguageKey("config.power.decomposer.max.name");
        maxDecomposerStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costDecomposition", costDecomposition);
        prop.setMinValue(1).setMaxValue(maxDecomposerStorage);
        prop.setComment(languageMap.func_74805_b("config.power.decomposer.cost.description"));
        prop.setLanguageKey("config.power.decomposer.cost.name");
        costDecomposition = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxSynthesizerStorage", maxSynthesizerStorage);
        prop.setComment(languageMap.func_74805_b("config.power.synthesizer.max.description"));
        prop.setLanguageKey("config.power.synthesizer.max.name");
        maxSynthesizerStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "energyPacketSize", energyPacketSize);
        prop.setComment(languageMap.func_74805_b("config.power.energyPacketSize.description"));
        prop.setLanguageKey("config.power.energyPacketSize.max.name");
        energyPacketSize = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costSythesisMultiplier", synthesisMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.setComment(languageMap.func_74805_b("config.power.synthesizer.cost.description"));
        prop.setLanguageKey("config.power.synthesizer.cost.name");
        synthesisMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costFissionMultiplier", fissionMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.setComment(languageMap.func_74805_b("config.power.fission.cost.description"));
        prop.setLanguageKey("config.power.fusion.cost.name");
        fissionMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxFissionStorage", maxFissionStorage);
        prop.setComment(languageMap.func_74805_b("config.power.fission.max.description"));
        prop.setLanguageKey("config.power.fission.max.name");
        maxFissionStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "costFusionMultiplier", fusionMultiplier);
        prop.setMinValue(1).setMaxValue(100);
        prop.setComment(languageMap.func_74805_b("config.power.fusion.cost.description"));
        prop.setLanguageKey("config.power.fusion.cost.name");
        fusionMultiplier = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("power", "maxFusionStorage", maxFusionStorage);
        prop.setComment(languageMap.func_74805_b("config.power.fusion.max.description"));
        prop.setLanguageKey("config.power.fusion.max.name");
        maxFusionStorage = prop.getInt();
        configList.add(prop.getName());
        prop = config.get("blacklist", "decomposeFluidChemicals", decomposeChemicalFluids);
        prop.setComment(languageMap.func_74805_b("config.decomposeFluidChemicals.description"));
        prop.setLanguageKey("config.decomposeFluidChemicals.name");
        decomposeChemicalFluids = prop.getBoolean();
        configList.add(prop.getName());
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("worldgen")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("blacklist")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("power")).getChildElements());
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }

    static {
        generateOre = true;
        UraniumOreClusterSize = 3;
        UraniumOreDensity = 5;
        DebugMode = false;
        UpdateRadius = 20;
        AllowAutomation = true;
        halfLifeMultiplier = 100;
        recursiveDepth = 10;
        advancedTurtleAI = false;
        vialPlacing = true;
        FoodSpiking = true;
        SwordEffects = true;
        fluidEffects = true;
        decaySafeMachines = false;
        recreationalChemicalEffects = true;
        powerUseEnabled = true;
        costDecomposition = 1000;
        synthesisMultiplier = 10;
        fusionMultiplier = 100;
        fissionMultiplier = 100;
        energyPacketSize = 100;
        maxSynthesizerStorage = 100000;
        maxDecomposerStorage = 100000;
        maxFissionStorage = 100000;
        maxFusionStorage = 100000;
        reactionItemMeetFluid = true;
        reactionFluidMeetFluid = true;
        enableWaterBucketIntoH2ORecipe = true;
        supportNEI = true;
        DecomposerBlacklist = new String[0];
        SynthesisMachineBlacklist = new String[0];
        decomposerBlacklist = NonNullList.func_191196_a();
        synthesisBlacklist = NonNullList.func_191196_a();
        worldGenDimWhitelist = new int[]{0};
        displayMoleculeEffects = true;
        decomposeChemicalFluids = true;
    }
}

