/*
 * Decompiled with CFR 0.152.
 */
package minechem.integration.jei;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSynthesisRecipeTransfer
implements IMessage,
IMessageHandler<PacketSynthesisRecipeTransfer, IMessage> {
    public Map<Integer, Integer> recipeMap;
    public List<Integer> craftingSlots;
    public List<Integer> inventorySlots;
    private boolean maxTransfer;
    private boolean requireCompleteSets;

    public PacketSynthesisRecipeTransfer() {
    }

    public PacketSynthesisRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    public void fromBytes(ByteBuf buf) {
        int recipeMapSize = buf.readInt();
        this.recipeMap = new HashMap<Integer, Integer>(recipeMapSize);
        for (int i = 0; i < recipeMapSize; ++i) {
            int slotIndex = buf.readInt();
            int recipeItem = buf.readInt();
            this.recipeMap.put(slotIndex, recipeItem);
        }
        int craftingSlotsSize = buf.readInt();
        this.craftingSlots = new ArrayList<Integer>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.readInt();
            this.craftingSlots.add(slotIndex);
        }
        int inventorySlotsSize = buf.readInt();
        this.inventorySlots = new ArrayList<Integer>(inventorySlotsSize);
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.readInt();
            this.inventorySlots.add(slotIndex);
        }
        this.maxTransfer = buf.readBoolean();
        this.requireCompleteSets = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.recipeMap.size());
        for (Map.Entry<Integer, Integer> recipeMapEntry : this.recipeMap.entrySet()) {
            buf.writeInt(recipeMapEntry.getKey().intValue());
            buf.writeInt(recipeMapEntry.getValue().intValue());
        }
        buf.writeInt(this.craftingSlots.size());
        for (Integer craftingSlot : this.craftingSlots) {
            buf.writeInt(craftingSlot.intValue());
        }
        buf.writeInt(this.inventorySlots.size());
        for (Integer inventorySlot : this.inventorySlots) {
            buf.writeInt(inventorySlot.intValue());
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public IMessage onMessage(PacketSynthesisRecipeTransfer message, MessageContext ctx) {
        SynthesisTransferHandlerServer.setItems((EntityPlayer)ctx.getServerHandler().field_147369_b, message.recipeMap, message.craftingSlots, message.inventorySlots, message.maxTransfer, message.requireCompleteSets);
        return null;
    }

    public static class SynthesisTransferHandlerServer {
        private SynthesisTransferHandlerServer() {
        }

        public static void setItems(EntityPlayer player, Map<Integer, Integer> slotIdMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
            Container container = player.field_71070_bA;
            HashMap<Integer, ItemStack> slotMap = new HashMap<Integer, ItemStack>(slotIdMap.size());
            for (Map.Entry<Integer, Integer> entry : slotIdMap.entrySet()) {
                Slot slot = container.func_75139_a(entry.getValue().intValue());
                ItemStack slotStack = slot.func_75211_c();
                if (slotStack.func_190926_b()) {
                    return;
                }
                ItemStack itemStack = slotStack.func_77946_l();
                slotMap.put(entry.getKey(), itemStack);
            }
            boolean transferAsCompleteSets = requireCompleteSets || !maxTransfer;
            Map<Integer, ItemStack> toTransfer = SynthesisTransferHandlerServer.removeItemsFromInventory(container, slotMap, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
            if (toTransfer.isEmpty()) {
                return;
            }
            ArrayList<ItemStack> clearedCraftingItems = new ArrayList<ItemStack>();
            for (Integer n : craftingSlots) {
                Slot craftingSlot = container.func_75139_a(n.intValue());
                if (!craftingSlot.func_75216_d()) continue;
                ItemStack craftingItem = craftingSlot.func_75209_a(Integer.MAX_VALUE);
                clearedCraftingItems.add(craftingItem);
            }
            for (Map.Entry entry : toTransfer.entrySet()) {
                Integer craftNumber = (Integer)entry.getKey();
                Integer slotNumber = craftingSlots.get(craftNumber);
                Slot slot = container.func_75139_a(slotNumber.intValue());
                ItemStack stack = (ItemStack)entry.getValue();
                stack.func_190920_e(stack.func_190916_E());
                if (slot.func_75214_a(stack)) {
                    slot.func_75215_d(stack);
                    continue;
                }
                clearedCraftingItems.add(stack);
            }
            for (ItemStack itemStack : clearedCraftingItems) {
                int added = SynthesisTransferHandlerServer.addStack(container, inventorySlots, itemStack);
                if (added >= itemStack.func_190916_E() || player.field_71071_by.func_70441_a(itemStack)) continue;
                player.func_71019_a(itemStack, false);
            }
            container.func_75142_b();
        }

        @Nonnull
        private static Map<Integer, ItemStack> removeItemsFromInventory(Container container, Map<Integer, ItemStack> required, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
            HashMap<Integer, ItemStack> result;
            block8: {
                boolean noItemsFound;
                result = new HashMap<Integer, ItemStack>(required.size());
                do {
                    HashMap<Slot, ItemStack> originalSlotContents = null;
                    if (transferAsCompleteSets) {
                        originalSlotContents = new HashMap<Slot, ItemStack>();
                    }
                    HashMap<Integer, ItemStack> foundItemsInSet = new HashMap<Integer, ItemStack>(required.size());
                    noItemsFound = true;
                    for (Map.Entry<Integer, ItemStack> entry : required.entrySet()) {
                        boolean resultItemStackLimitReached;
                        ItemStack requiredStack = entry.getValue().func_77946_l();
                        Slot slot = SynthesisTransferHandlerServer.getSlotWithStack(container, requiredStack, craftingSlots, inventorySlots);
                        boolean itemFound = slot != null && !slot.func_75211_c().func_190926_b();
                        ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                        boolean bl = resultItemStackLimitReached = resultItemStack != null && resultItemStack.func_190916_E() == resultItemStack.func_77976_d();
                        if (!itemFound || resultItemStackLimitReached) {
                            if (!transferAsCompleteSets) continue;
                            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                                ItemStack stack = (ItemStack)slotEntry.getValue();
                                ((Slot)slotEntry.getKey()).func_75215_d(stack);
                            }
                            break block8;
                        }
                        if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                            originalSlotContents.put(slot, slot.func_75211_c().func_77946_l());
                        }
                        ItemStack removedItemStack = slot.func_75209_a(1);
                        foundItemsInSet.put(entry.getKey(), removedItemStack);
                        noItemsFound = false;
                    }
                    for (Map.Entry<Integer, Object> entry : foundItemsInSet.entrySet()) {
                        ItemStack resultItemStack = (ItemStack)result.get(entry.getKey());
                        if (resultItemStack == null) {
                            result.put(entry.getKey(), (ItemStack)entry.getValue());
                            continue;
                        }
                        resultItemStack.func_190917_f(1);
                    }
                } while (maxTransfer && !noItemsFound);
            }
            return result;
        }

        @Nullable
        private static Slot getSlotWithStack(Container container, ItemStack stack, List<Integer> craftingSlots, List<Integer> inventorySlots) {
            Slot slot = SynthesisTransferHandlerServer.getSlotWithStack(container, craftingSlots, stack);
            if (slot == null) {
                slot = SynthesisTransferHandlerServer.getSlotWithStack(container, inventorySlots, stack);
            }
            return slot;
        }

        private static int addStack(Container container, Collection<Integer> slotIndexes, ItemStack stack) {
            Slot slot;
            ItemStack inventoryStack;
            int added = 0;
            for (Integer slotIndex : slotIndexes) {
                if (slotIndex < 0 || slotIndex >= container.field_75151_b.size() || (inventoryStack = (slot = container.func_75139_a(slotIndex.intValue())).func_75211_c()).func_190926_b() || !inventoryStack.func_77985_e() || !inventoryStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)inventoryStack, (ItemStack)stack)) continue;
                int remain = stack.func_190916_E() - added;
                int maxStackSize = Math.min(slot.func_178170_b(inventoryStack), inventoryStack.func_77976_d());
                int space = maxStackSize - inventoryStack.func_190916_E();
                if (space <= 0) continue;
                if (space >= remain) {
                    inventoryStack.func_190917_f(remain);
                    return stack.func_190916_E();
                }
                inventoryStack.func_190920_e(inventoryStack.func_77976_d());
                added += space;
            }
            if (added >= stack.func_190916_E()) {
                return added;
            }
            for (Integer slotIndex : slotIndexes) {
                if (slotIndex < 0 || slotIndex >= container.field_75151_b.size() || !(inventoryStack = (slot = container.func_75139_a(slotIndex.intValue())).func_75211_c()).func_190926_b()) continue;
                ItemStack stackToAdd = stack.func_77946_l();
                stackToAdd.func_190920_e(stack.func_190916_E() - added);
                slot.func_75215_d(stackToAdd);
                return stack.func_190916_E();
            }
            return added;
        }

        @Nullable
        private static Slot getSlotWithStack(Container container, Iterable<Integer> slotNumbers, ItemStack itemStack) {
            for (Integer slotNumber : slotNumbers) {
                Slot slot;
                ItemStack slotStack;
                if (slotNumber < 0 || slotNumber >= container.field_75151_b.size() || !ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)(slotStack = (slot = container.func_75139_a(slotNumber.intValue())).func_75211_c())) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)slotStack)) continue;
                return slot;
            }
            return null;
        }
    }
}

